/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IPaintedCart;
import mods.railcraft.api.carts.IRefuelableCart;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class RoutingLogic {
    public static final String REGEX_SYMBOL = "\\?";
    private Deque<Condition> conditions;
    private RoutingLogicException error;

    private RoutingLogic(LinkedList<String> data) {
        try {
            if (data == null) {
                throw new RoutingLogicException("railcraft.gui.routing.logic.blank", null);
            }
            this.parseTable(data);
        }
        catch (RoutingLogicException ex) {
            this.error = ex;
        }
    }

    public static RoutingLogic buildLogic(LinkedList<String> data) {
        return new RoutingLogic(data);
    }

    public RoutingLogicException getError() {
        return this.error;
    }

    public boolean isValid() {
        return this.conditions != null;
    }

    private void parseTable(LinkedList<String> data) throws RoutingLogicException {
        LinkedList<Condition> stack = new LinkedList<Condition>();
        Iterator<String> it = data.descendingIterator();
        while (it.hasNext()) {
            String line = it.next().trim();
            stack.push(this.parseLine(line, stack));
        }
        this.conditions = stack;
    }

    private EntityMinecart getRoutableCart(EntityMinecart cart) {
        Train train = Train.getTrain(cart);
        if (train == null) {
            return null;
        }
        if (train.size() == 1) {
            return cart;
        }
        if (train.isTrainEnd(cart)) {
            if (cart instanceof IRoutableCart) {
                return cart;
            }
            if (cart instanceof IPaintedCart) {
                return cart;
            }
            if (cart instanceof IRefuelableCart) {
                return cart;
            }
        }
        return train.getLocomotive();
    }

    public boolean matches(IRoutingTile tile, EntityMinecart cart) {
        if (this.conditions == null) {
            return false;
        }
        EntityMinecart controllingCart = this.getRoutableCart(cart);
        if (controllingCart == null) {
            return false;
        }
        for (Condition condition : this.conditions) {
            if (!condition.matches(tile, controllingCart)) continue;
            return true;
        }
        return false;
    }

    private Condition parseLine(String line, Deque<Condition> stack) throws RoutingLogicException {
        try {
            if (line.startsWith("Dest")) {
                return new DestCondition(line);
            }
            if (line.startsWith("Color")) {
                return new ColorCondition(line);
            }
            if (line.startsWith("Owner")) {
                return new OwnerCondition(line);
            }
            if (line.startsWith("Name")) {
                return new NameCondition(line);
            }
            if (line.startsWith("Type")) {
                return new TypeCondition(line);
            }
            if (line.startsWith("NeedsRefuel")) {
                return new RefuelCondition(line);
            }
            if (line.startsWith("Ridden")) {
                return new RiddenCondition(line);
            }
            if (line.startsWith("Riding")) {
                return new RidingCondition(line);
            }
            if (line.startsWith("Redstone")) {
                return new RedstoneCondition(line);
            }
            if (line.startsWith("Loco")) {
                return new LocoCondition(line);
            }
        }
        catch (RoutingLogicException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RoutingLogicException("railcraft.gui.routing.logic.malformed.syntax", line);
        }
        try {
            if (line.equals("NOT")) {
                return new NOT(stack.pop());
            }
            if (line.equals("AND")) {
                return new AND(stack.pop(), stack.pop());
            }
            if (line.equals("OR")) {
                return new OR(stack.pop(), stack.pop());
            }
        }
        catch (NoSuchElementException ex) {
            throw new RoutingLogicException("railcraft.gui.routing.logic.insufficient.operands", line);
        }
        throw new RoutingLogicException("railcraft.gui.routing.logic.unrecognized.keyword", line);
    }

    private class LocoCondition
    extends ParsedCondition {
        public LocoCondition(String line) throws RoutingLogicException {
            super("Loco", false, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            if (cart instanceof EntityLocomotive) {
                EntityLocomotive loco = (EntityLocomotive)cart;
                if (this.value.equalsIgnoreCase("Electric")) {
                    return loco.getCartType() == EnumCart.LOCO_ELECTRIC;
                }
                if (this.value.equalsIgnoreCase("Steam")) {
                    return loco.getCartType() == EnumCart.LOCO_STEAM_SOLID;
                }
                if (this.value.equalsIgnoreCase("Steam_Magic")) {
                    return loco.getCartType() == EnumCart.LOCO_STEAM_MAGIC;
                }
                if (this.value.equalsIgnoreCase("None")) {
                    return false;
                }
            }
            return this.value.equalsIgnoreCase("None");
        }
    }

    private class ColorCondition
    extends ParsedCondition {
        private final EnumColor primary;
        private final EnumColor secondary;

        public ColorCondition(String line) throws RoutingLogicException {
            super("Color", false, line);
            String[] colors = this.value.split(",");
            if (colors[0].equals("Any") || colors[0].equals("*")) {
                this.primary = null;
            } else {
                this.primary = EnumColor.fromName(colors[0]);
                if (this.primary == null) {
                    throw new RoutingLogicException("railcraft.gui.routing.logic.unrecognized.keyword", colors[0]);
                }
            }
            if (colors.length == 1 || colors[1].equals("Any") || colors[1].equals("*")) {
                this.secondary = null;
            } else {
                this.secondary = EnumColor.fromName(colors[1]);
                if (this.secondary == null) {
                    throw new RoutingLogicException("railcraft.gui.routing.logic.unrecognized.keyword", colors[1]);
                }
            }
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            if (cart instanceof IPaintedCart) {
                IPaintedCart pCart = (IPaintedCart)cart;
                return !(this.primary != null && this.primary.ordinal() != pCart.getPrimaryColor() || this.secondary != null && this.secondary.ordinal() != pCart.getSecondaryColor());
            }
            return false;
        }
    }

    private class RedstoneCondition
    extends ParsedCondition {
        private final boolean powered;

        public RedstoneCondition(String line) throws RoutingLogicException {
            super("Redstone", false, line);
            this.powered = Boolean.parseBoolean(this.value);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            return this.powered == tile.isPowered();
        }
    }

    private class RidingCondition
    extends ParsedCondition {
        public RidingCondition(String line) throws RoutingLogicException {
            super("Riding", false, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            for (EntityMinecart c : Train.getTrain(cart)) {
                if (c == null || !(c.field_70153_n instanceof EntityPlayer)) continue;
                return c.field_70153_n.func_70005_c_().equalsIgnoreCase(this.value);
            }
            return false;
        }
    }

    private class RiddenCondition
    extends ParsedCondition {
        private final boolean ridden;

        public RiddenCondition(String line) throws RoutingLogicException {
            super("Ridden", false, line);
            this.ridden = Boolean.parseBoolean(this.value);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            for (EntityMinecart c : Train.getTrain(cart)) {
                if (c == null || !(c.field_70153_n instanceof EntityPlayer)) continue;
                return this.ridden;
            }
            return !this.ridden;
        }
    }

    private class RefuelCondition
    extends ParsedCondition {
        private final boolean needsRefuel;

        public RefuelCondition(String line) throws RoutingLogicException {
            super("NeedsRefuel", false, line);
            this.needsRefuel = Boolean.parseBoolean(this.value);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            if (cart instanceof IRefuelableCart) {
                IRefuelableCart rCart = (IRefuelableCart)cart;
                return this.needsRefuel == rCart.needsRefuel();
            }
            return false;
        }
    }

    private class TypeCondition
    extends ParsedCondition {
        public TypeCondition(String line) throws RoutingLogicException {
            super("Type", false, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            ItemStack stack = cart.getCartItem();
            if (stack == null || stack.func_77973_b() == null) {
                return false;
            }
            GameRegistry.UniqueIdentifier itemName = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
            if (itemName != null) {
                String nameString = itemName.modId + ":" + itemName.name;
                return nameString.equalsIgnoreCase(this.value);
            }
            return false;
        }
    }

    private class NameCondition
    extends ParsedCondition {
        public NameCondition(String line) throws RoutingLogicException {
            super("Name", true, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            String customName = cart.func_95999_t();
            if (customName == null) {
                return "null".equals(this.value);
            }
            if (this.isRegex) {
                return customName.matches(this.value);
            }
            return this.value.equals(customName);
        }
    }

    private class OwnerCondition
    extends ParsedCondition {
        public OwnerCondition(String line) throws RoutingLogicException {
            super("Owner", false, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            return this.value.equalsIgnoreCase(CartTools.getCartOwner(cart).getName());
        }
    }

    private class DestCondition
    extends ParsedCondition {
        public DestCondition(String line) throws RoutingLogicException {
            super("Dest", true, line);
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            if (cart instanceof IRoutableCart) {
                String cartDest = ((IRoutableCart)cart).getDestination();
                if (this.value.equals("null")) {
                    return cartDest == null || cartDest.equals("");
                }
                if (this.isRegex) {
                    return cartDest.matches(this.value);
                }
                return cartDest.startsWith(this.value);
            }
            return false;
        }
    }

    private class OR
    extends Condition {
        private final Condition a;
        private final Condition b;

        public OR(Condition a, Condition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            return this.a.matches(tile, cart) || this.b.matches(tile, cart);
        }
    }

    private class AND
    extends Condition {
        private final Condition a;
        private final Condition b;

        public AND(Condition a, Condition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            return this.a.matches(tile, cart) && this.b.matches(tile, cart);
        }
    }

    private class NOT
    extends Condition {
        private final Condition a;

        public NOT(Condition a) {
            this.a = a;
        }

        @Override
        public boolean matches(IRoutingTile tile, EntityMinecart cart) {
            return !this.a.matches(tile, cart);
        }
    }

    private abstract class ParsedCondition
    extends Condition {
        public final String keyword;
        public final String line;
        public final String value;
        public final boolean isRegex;

        private ParsedCondition(String keyword, boolean supportsRegex, String line) throws RoutingLogicException {
            this.keyword = keyword;
            this.line = line;
            String keywordMatch = keyword + RoutingLogic.REGEX_SYMBOL + "?=";
            if (!line.matches(keywordMatch + ".*")) {
                throw new RoutingLogicException("railcraft.gui.routing.logic.unrecognized.keyword", line);
            }
            this.isRegex = line.matches(keyword + RoutingLogic.REGEX_SYMBOL + "=.*");
            if (!supportsRegex && this.isRegex) {
                throw new RoutingLogicException("railcraft.gui.routing.logic.regex.unsupported", line);
            }
            this.value = line.replaceFirst(keywordMatch, "");
            if (this.isRegex) {
                try {
                    Pattern.compile(this.value);
                }
                catch (PatternSyntaxException ex) {
                    throw new RoutingLogicException("railcraft.gui.routing.logic.regex.invalid", line);
                }
            }
        }

        @Override
        public abstract boolean matches(IRoutingTile var1, EntityMinecart var2);
    }

    private abstract class Condition {
        private Condition() {
        }

        public abstract boolean matches(IRoutingTile var1, EntityMinecart var2);
    }

    public class RoutingLogicException
    extends Exception {
        private final ToolTip tips = new ToolTip();

        public RoutingLogicException(String errorTag, String line) {
            this.tips.add(EnumChatFormatting.RED + LocalizationPlugin.translate(errorTag));
            if (line != null) {
                this.tips.add("\"" + line + "\"");
            }
        }

        public ToolTip getToolTip() {
            return this.tips;
        }
    }
}

