/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.tank;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineEta;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineZeta;
import mods.railcraft.common.modules.ModuleAdvancedTanks;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.entity.Entity;

public class GenericMultiTankBase
extends MetalTank {
    private final Set<Integer> tankBlocks = new HashSet<Integer>();
    private final int tankWallMeta;
    public final String tankMaterial;
    private final int capacity;
    public final IEnumMachine TANK_WALL;
    public final IEnumMachine TANK_VALVE;
    public final IEnumMachine TANK_GAUGE;

    public GenericMultiTankBase(String tankMat, int tankCapacity, IEnumMachine tankWall, IEnumMachine tankValve, IEnumMachine tankGauge) {
        this.tankMaterial = tankMat;
        this.capacity = tankCapacity;
        this.tankWallMeta = tankWall.ordinal();
        this.tankBlocks.add(tankWall.ordinal());
        this.tankBlocks.add(tankValve.ordinal());
        this.tankBlocks.add(tankGauge.ordinal());
        this.TANK_WALL = tankWall;
        this.TANK_VALVE = tankValve;
        this.TANK_GAUGE = tankGauge;
        this.setTankType(tankWall);
        this.setTankType(tankValve);
        this.setTankType(tankGauge);
        ModuleAdvancedTanks.cacheTankType.put(tankWall.getTag(), tankWall);
        ModuleAdvancedTanks.cacheTankType.put(tankValve.getTag(), tankValve);
        ModuleAdvancedTanks.cacheTankType.put(tankGauge.getTag(), tankGauge);
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public String getTitle() {
        return LocalizationPlugin.translate("railcraft.gui.tank." + this.tankMaterial);
    }

    @Override
    public boolean isTankBlock(int meta) {
        return this.tankBlocks.contains(meta);
    }

    @Override
    public boolean isWallBlock(int meta) {
        return meta == this.tankWallMeta;
    }

    @Override
    public float getResistance(Entity exploder) {
        return 25.0f;
    }

    private final void setTankType(IEnumMachine machine) {
        if (machine instanceof EnumMachineEta || machine instanceof EnumMachineZeta) {
            try {
                Method setTank = machine.getClass().getDeclaredMethod("setTankType", GenericMultiTankBase.class);
                setTank.invoke((Object)machine, this);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

