/*
 * Decompiled with CFR 0.152.
 */
package tectech.recipe;

import appeng.util.ReadableNumberConverter;
import codechicken.nei.PositionedStack;
import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GTNEIDefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import tectech.recipe.EyeOfHarmonyRecipe;
import tectech.util.CommonValues;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EyeOfHarmonyFrontend
extends RecipeMapFrontend {
    private static final int xDirMaxCount = 9;
    private static final int itemRows = 9;
    private static final int fluidRows = 2;
    public static final int maxItemInputs = 1;
    public static final int maxItemOutputs = 81;
    public static final int maxFluidInputs = 0;
    public static final int maxFluidOutputs = 18;
    private static final int yOrigin = 8;
    private static final long TRILLION = LongMath.pow((long)10L, (int)12);
    public static final int maxItemsToRender = 80;

    public EyeOfHarmonyFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder.logoPos(new Pos2d(8, 8)), neiPropertiesBuilder.recipeBackgroundSize(new Size(170, 243)).neiSpecialInfoFormatter(new EyeOfHarmonySpecialValueFormatter()));
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions(itemInputCount, 79, 8, 1, 1);
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions(Math.min(itemOutputCount, 81), 7, 44, 9, 12);
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 0, 0, 0, 0);
    }

    @Override
    public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        return UIHelper.getGridPositions(fluidOutputCount, 7, 206, 9, 3);
    }

    @Override
    public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GTNEIDefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        super.handleNEIItemTooltip(stack, currentTip, neiCachedRecipe);
        EyeOfHarmonyRecipe currentRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
        if (stack.func_77969_a(currentRecipe.getRecipeTriggerItem())) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.total_items", (Object[])new Object[]{GTUtility.formatNumbers(currentRecipe.getSumOfItems())}));
            return currentTip;
        }
        double percentage = (Double)currentRecipe.getItemStackToProbabilityMap().getOrDefault((Object)stack, (Object)-1.0);
        if (percentage != -1.0) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.solid_mass", (Object[])new Object[]{percentage}));
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.item_count", (Object[])new Object[]{GTUtility.formatNumbers((Long)currentRecipe.getItemStackToTrueStackSizeMap().get((Object)stack))}));
        }
        return currentTip;
    }

    @Override
    public void drawNEIOverlays(GTNEIDefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        EyeOfHarmonyRecipe EOHRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
        for (PositionedStack stack : neiCachedRecipe.mInputs) {
            if (!(stack instanceof GTNEIDefaultHandler.FixedPositionedStack) || !stack.item.func_77969_a(EOHRecipe.getRecipeTriggerItem())) continue;
            this.drawNEIOverlayText(StatCollector.func_74838_a((String)"NC"), stack);
        }
        for (PositionedStack stack : neiCachedRecipe.mOutputs) {
            if (!(stack instanceof GTNEIDefaultHandler.FixedPositionedStack) || !EOHRecipe.getItemStackToTrueStackSizeMap().containsKey((Object)stack.item)) continue;
            long stackSize = (Long)EOHRecipe.getItemStackToTrueStackSizeMap().get((Object)stack.item);
            String displayString = stackSize > 9999L ? ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize) : String.valueOf(stackSize);
            this.drawNEIOverlayText(displayString, stack, 0xFFFFFF, 0.5f, true, Alignment.BottomRight);
        }
    }

    private static class EyeOfHarmonySpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private EyeOfHarmonySpecialValueFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            EyeOfHarmonyRecipe recipe = (EyeOfHarmonyRecipe)recipeInfo.recipe.mSpecialItems;
            ArrayList<String> result = new ArrayList<String>();
            result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.Hydrogen.In", "Hydrogen") + ": " + GTUtility.formatNumbers(recipe.getHydrogenRequirement()) + " L");
            result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.Helium.In", "Helium") + ": " + GTUtility.formatNumbers(recipe.getHydrogenRequirement()) + " L");
            result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.SpacetimeTier", "Spacetime Tier") + ": " + CommonValues.EOH_TIER_FANCY_NAMES[(int)recipe.getSpacetimeCasingTierRequired()]);
            if (recipe.getEUOutput() < TRILLION) {
                result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.EU.Out", "EU Output") + ": " + GTUtility.formatNumbers(recipe.getEUOutput()) + " EU");
            } else {
                result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.EU.Out", "EU Output") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUOutput()) + " EU");
            }
            if (recipe.getEUOutput() < TRILLION) {
                result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.EU.In", "EU Input") + ": " + GTUtility.formatNumbers(recipe.getEUStartCost()) + " EU");
            } else {
                result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.EU.In", "EU Input") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUStartCost()) + " EU");
            }
            result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.BaseRecipeChance", "Base Recipe Chance") + ": " + GTUtility.formatNumbers(100.0 * recipe.getBaseRecipeSuccessChance()) + "%");
            result.add(GTLanguageManager.addStringLocalization("EOH.Recipe.RecipeEnergyEfficiency", "Recipe Energy Efficiency") + ": " + GTUtility.formatNumbers(100.0 * recipe.getRecipeEnergyEfficiency()) + "%");
            if (recipe.getOutputItems().size() > 80) {
                result.add("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + GTLanguageManager.addStringLocalization("EOH.Recipe.Warning.0", "Warning") + EnumChatFormatting.RESET + ": " + GTLanguageManager.addStringLocalization("EOH.Recipe.Warning.1", "Not all items displayed."));
            }
            return result;
        }
    }
}

