/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.enderStorage;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.IFluidHandler;
import tectech.mechanics.enderStorage.EnderFluidContainer;
import tectech.mechanics.enderStorage.EnderLinkTag;
import tectech.mechanics.enderStorage.EnderLinkTank;

public class EnderWorldSavedData
extends WorldSavedData {
    private static EnderWorldSavedData INSTANCE;
    private static final String DATA_NAME = "tectech_EnderWorldSavedData";
    private static final String ENDER_LIQUID_TAG_LINK = "tectech_EnderWorldSavedData_EnderLiquidTagLink";
    private static final String ENDER_LIQUID_TANK_LINK = "tectech_EnderWorldSavedData_EnderLiquidTankLink";
    private static final String ENDER_LIQUID_TAG_VERSION = "tectech_EnderWorldSavedData_Version";
    private Map<EnderLinkTag, EnderFluidContainer> EnderLiquidTagLink = new HashMap<EnderLinkTag, EnderFluidContainer>();
    private Map<EnderLinkTank, EnderLinkTag> EnderLiquidTankLink = new HashMap<EnderLinkTank, EnderLinkTag>();

    public EnderWorldSavedData() {
        super(DATA_NAME);
    }

    public EnderWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        int version = nbtTagCompound.func_74762_e(ENDER_LIQUID_TAG_VERSION);
        switch (version) {
            case 0: {
                MigratingObjectInputStream objectStream;
                ByteArrayInputStream is;
                byte[] bytes;
                try {
                    bytes = nbtTagCompound.func_74770_j(ENDER_LIQUID_TAG_LINK);
                    is = new ByteArrayInputStream(bytes);
                    try {
                        objectStream = new MigratingObjectInputStream(is);
                        try {
                            this.EnderLiquidTagLink = (Map)objectStream.readObject();
                        }
                        finally {
                            objectStream.close();
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    System.out.println("ENDER_LIQUID_TAG_LINK LOAD FAILED");
                    e.printStackTrace();
                }
                try {
                    bytes = nbtTagCompound.func_74770_j(ENDER_LIQUID_TANK_LINK);
                    is = new ByteArrayInputStream(bytes);
                    try {
                        objectStream = new MigratingObjectInputStream(is);
                        try {
                            this.EnderLiquidTankLink = (Map)objectStream.readObject();
                        }
                        finally {
                            objectStream.close();
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    System.out.println("ENDER_LIQUID_TANK_LINK LOAD FAILED");
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                List tags = ((NBTTagList)nbtTagCompound.func_74781_a((String)ENDER_LIQUID_TAG_LINK)).field_74747_a;
                this.EnderLiquidTagLink = new HashMap<EnderLinkTag, EnderFluidContainer>();
                for (NBTTagCompound tagLink : tags) {
                    EnderLinkTag tag = EnderLinkTag.load((NBTTagCompound)tagLink.func_74781_a("k"));
                    EnderFluidContainer container = EnderFluidContainer.load((NBTTagCompound)tagLink.func_74781_a("v"));
                    this.EnderLiquidTagLink.put(tag, container);
                }
                List tanks = ((NBTTagList)nbtTagCompound.func_74781_a((String)ENDER_LIQUID_TANK_LINK)).field_74747_a;
                this.EnderLiquidTankLink = new HashMap<EnderLinkTank, EnderLinkTag>();
                for (NBTTagCompound tankLink : tanks) {
                    EnderLinkTank tank = EnderLinkTank.load((NBTTagCompound)tankLink.func_74781_a("k"));
                    EnderLinkTag tag = EnderLinkTag.load((NBTTagCompound)tankLink.func_74781_a("v"));
                    this.EnderLiquidTankLink.put(tank, tag);
                }
                break;
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a(ENDER_LIQUID_TAG_VERSION, 1);
        HashSet usedTags = new HashSet();
        NBTTagList tanks = new NBTTagList();
        this.EnderLiquidTankLink.forEach((tank, tag) -> {
            if (tank.getFluidHandler() != null) {
                usedTags.add(tag);
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74782_a("k", (NBTBase)tank.save());
                entry.func_74782_a("v", (NBTBase)tag.save());
                tanks.func_74742_a((NBTBase)entry);
            }
        });
        nbtTagCompound.func_74782_a(ENDER_LIQUID_TANK_LINK, (NBTBase)tanks);
        NBTTagList tags = new NBTTagList();
        this.EnderLiquidTagLink.forEach((tag, container) -> {
            if (usedTags.contains(tag)) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74782_a("k", (NBTBase)tag.save());
                entry.func_74782_a("v", (NBTBase)container.save());
                tags.func_74742_a((NBTBase)entry);
            }
        });
        nbtTagCompound.func_74782_a(ENDER_LIQUID_TAG_LINK, (NBTBase)tags);
    }

    private static void loadInstance() {
        MapStorage storage;
        if (INSTANCE == null && (INSTANCE = (EnderWorldSavedData)(storage = DimensionManager.getWorld((int)0).field_72988_C).func_75742_a(EnderWorldSavedData.class, DATA_NAME)) == null) {
            INSTANCE = new EnderWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    private static Map<EnderLinkTag, EnderFluidContainer> getEnderLiquidLink() {
        EnderWorldSavedData.loadInstance();
        return EnderWorldSavedData.INSTANCE.EnderLiquidTagLink;
    }

    private static Map<EnderLinkTank, EnderLinkTag> getEnderLiquidTankLink() {
        EnderWorldSavedData.loadInstance();
        return EnderWorldSavedData.INSTANCE.EnderLiquidTankLink;
    }

    public static EnderFluidContainer getEnderFluidContainer(EnderLinkTag tag) {
        if (!EnderWorldSavedData.getEnderLiquidLink().containsKey(tag)) {
            EnderWorldSavedData.getEnderLiquidLink().put(tag, new EnderFluidContainer());
        }
        return EnderWorldSavedData.getEnderLiquidLink().get(tag);
    }

    public static EnderLinkTag getEnderLinkTag(IFluidHandler handler) {
        EnderLinkTank tank = new EnderLinkTank(handler);
        EnderLinkTag tag = EnderWorldSavedData.getEnderLiquidTankLink().get(tank);
        if (tag != null && Objects.equals(tag.getFrequency(), "")) {
            tag = null;
        }
        return tag;
    }

    public static void bindEnderLinkTag(IFluidHandler handler, EnderLinkTag tag) {
        EnderLinkTank tank = new EnderLinkTank(handler);
        if (!tag.equals(EnderWorldSavedData.getEnderLiquidTankLink().get(tank))) {
            EnderWorldSavedData.unbindTank(handler);
            EnderWorldSavedData.getEnderLiquidTankLink().remove(tank);
            EnderWorldSavedData.getEnderLiquidTankLink().put(tank, tag);
        }
    }

    public static void unbindTank(IFluidHandler handler) {
        boolean isReferenced;
        EnderLinkTank tank = new EnderLinkTank(handler);
        EnderLinkTag oldTag = EnderWorldSavedData.getEnderLiquidTankLink().remove(tank);
        if (oldTag != null && !(isReferenced = EnderWorldSavedData.getEnderLiquidTankLink().values().contains(oldTag))) {
            EnderWorldSavedData.getEnderLiquidLink().remove(oldTag);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            INSTANCE = null;
        }
    }

    private static class MigratingObjectInputStream
    extends ObjectInputStream {
        public MigratingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            String className = resultClassDescriptor.getName();
            if (className.startsWith("com.github.technus.")) {
                resultClassDescriptor = ObjectStreamClass.lookup(Class.forName(className.replace("com.github.technus.", "")));
            }
            return resultClassDescriptor;
        }
    }
}

