/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity.recipe.beamline;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.MaterialsElements;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.item.MaskList;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import gtnhlanth.common.tileentity.recipe.beamline.BeamlineRecipeAdder2;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BeamlineRecipeLoader {
    public static final HashMap<String, Fluid> coolantMap = new HashMap();
    private static final ItemList[] VIABLE_WAFERS = new ItemList[]{ItemList.Circuit_Silicon_Wafer, ItemList.Circuit_Silicon_Wafer2, ItemList.Circuit_Silicon_Wafer3, ItemList.Circuit_Silicon_Wafer4, ItemList.Circuit_Silicon_Wafer5, ItemList.Circuit_Silicon_Wafer6, ItemList.Circuit_Silicon_Wafer7};

    public static void load() {
        coolantMap.put(Materials.LiquidNitrogen.getGas(1L).getFluid().getName(), Materials.Nitrogen.getGas(1L).getFluid());
        coolantMap.put(Materials.LiquidOxygen.getGas(1L).getFluid().getName(), Materials.Oxygen.getGas(1L).getFluid());
        coolantMap.put("ic2coolant", FluidRegistry.getFluid((String)"ic2hotcoolant"));
        coolantMap.put(Materials.SuperCoolant.getFluid(1L).getFluid().getName(), Materials.Water.getFluid(1L).getFluid());
        BeamlineRecipeAdder2.instance.addSourceChamberRecipe(new ItemStack[]{GTOreDictUnificator.get(OrePrefixes.stick, Materials.Tungsten, 1L)}, null, Particle.ELECTRON.ordinal(), 20, 1000.0f, 98.0f, 0.1f, 7680);
        BeamlineRecipeAdder2.instance.addSourceChamberRecipe(new ItemStack[]{WerkstoffMaterialPool.LanthanumHexaboride.get(OrePrefixes.stickLong, 1)}, null, Particle.ELECTRON.ordinal(), 60, 5000.0f, 99.0f, 0.3f, 7680);
        BeamlineRecipeAdder2.instance.addSourceChamberRecipe(new ItemStack[]{MaterialsElements.getInstance().CALIFORNIUM.getDust(1)}, null, Particle.NEUTRON.ordinal(), 10, 9000.0f, 95.0f, 999.0f, 1920);
        BeamlineRecipeAdder2.instance.addSourceChamberRecipe(new ItemStack[]{Materials.Uranium.getDust(1)}, new ItemStack[]{WerkstoffMaterialPool.Thorium234.get(OrePrefixes.dust, 1)}, Particle.ALPHA.ordinal(), 1, 4270.0f, 90.0f, 999.0f, 480);
        for (MaskList mask : MaskList.values()) {
            if (mask.getProducedItem() == null) continue;
            int index = 0;
            for (ItemList wafer : VIABLE_WAFERS) {
                ++index;
                if (Arrays.asList(mask.getForbiddenWafers()).contains(wafer)) continue;
                BeamlineRecipeAdder2.instance.addTargetChamberRecipe(wafer.get(1L, new Object[0]), GTUtility.copyAmountUnsafe((int)Math.pow(2.0, index + 2), mask.getProducedItem()), new ItemStack(LanthItemList.maskMap.get((Object)mask), 0), 1, mask.getBaselineAmount() * (int)Math.pow(Math.sqrt(3.0), index - 1), mask.getMinEnergy(), mask.getMaxEnergy(), mask.getMinFocus(), 1.0f, 1920);
            }
        }
        BeamlineRecipeAdder2.instance.addTargetChamberRecipe(new ItemStack(Items.field_151076_bf, 1), new ItemStack(Items.field_151077_bg), null, Particle.PHOTON.ordinal(), 400, 5.0f, 20.0f, 80.0f, 1.0f, 0x780000);
        BeamlineRecipeAdder2.instance.addTargetChamberRecipe(new ItemStack(Items.field_151076_bf, 1), new ItemStack(Items.field_151110_aK), null, Particle.PHOTON.ordinal(), 400, 21.0f, 600.0f, 80.0f, 1.0f, 0x780000);
    }
}

