/*
 * Decompiled with CFR 0.152.
 */
package gtneioreplugin.util;

import gtneioreplugin.Config;
import gtneioreplugin.util.GT5OreLayerHelper;
import gtneioreplugin.util.GT5OreSmallHelper;
import gtneioreplugin.util.StringPaddingHack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StatCollector;

public class DimensionHelper {
    public static final String[] DimName = new String[]{"Overworld", "Nether", "Twilight", "TheEnd", "EndAsteroid", "GalacticraftCore_Moon", "GalaxySpace_Deimos", "GalacticraftMars_Mars", "GalaxySpace_Phobos", "GalacticraftMars_Asteroids", "GalaxySpace_Callisto", "GalaxySpace_Ceres", "GalaxySpace_Europa", "GalaxySpace_Ganymede", "Ross128b", "GalaxySpace_Io", "GalaxySpace_Mercury", "GalaxySpace_Venus", "GalaxySpace_Enceladus", "GalaxySpace_Miranda", "GalaxySpace_Oberon", "GalaxySpace_Titan", "Ross128ba", "GalaxySpace_Proteus", "GalaxySpace_Triton", "GalaxySpace_Haumea", "GalaxySpace_Kuiperbelt", "GalaxySpace_MakeMake", "GalaxySpace_Pluto", "GalaxySpace_BarnardC", "GalaxySpace_BarnardE", "GalaxySpace_BarnardF", "GalaxySpace_CentauriA", "GalaxySpace_TcetiE", "GalaxySpace_VegaB", "GalacticraftAmunRa_Anubis", "GalacticraftAmunRa_Horus", "GalacticraftAmunRa_Maahes", "GalacticraftAmunRa_MehenBelt", "GalacticraftAmunRa_Neper", "GalacticraftAmunRa_Seth", "Underdark"};
    public static final String[] DimNameTrimmed = (String[])Arrays.stream(DimName).map(n -> n.replaceAll("GalacticraftCore_", "").replaceAll("GalacticraftMars_", "").replaceAll("GalaxySpace_", "").replaceAll("GalacticraftAmunRa_", "")).toArray(String[]::new);
    public static final String[] DimNameDisplayed = new String[]{"Ow", "Ne", "TF", "ED", "EA", "Mo", "De", "Ma", "Ph", "As", "Ca", "Ce", "Eu", "Ga", "Rb", "Io", "Me", "Ve", "En", "Mi", "Ob", "Ti", "Ra", "Pr", "Tr", "Ha", "KB", "MM", "Pl", "BC", "BE", "BF", "CB", "TE", "VB", "An", "Ho", "Mh", "MB", "Np", "Se", "DD"};
    private static final HashMap<String, List<String>> tooltipBuffer = new HashMap();

    private static List<String> computeString(String line) {
        String[] dims = DimensionHelper.parseDimNames(line);
        for (int j = 0; j < dims.length; ++j) {
            String s = dims[j];
            for (int i = 0; i < DimNameDisplayed.length; ++i) {
                String string;
                if (!s.equals(DimNameDisplayed[i])) continue;
                String k = DimNameTrimmed[i];
                s = StatCollector.func_74838_a((String)("gtnop.world." + k));
                switch (k) {
                    case "Moon": {
                        string = "T1: " + s;
                        break;
                    }
                    case "Deimos": 
                    case "Mars": 
                    case "Phobos": {
                        string = "T2: " + s;
                        break;
                    }
                    case "Asteroids": 
                    case "Callisto": 
                    case "Ceres": 
                    case "Europa": 
                    case "Ganymede": 
                    case "Ross128b": {
                        string = "T3: " + s;
                        break;
                    }
                    case "Io": 
                    case "Mercury": 
                    case "Venus": {
                        string = "T4: " + s;
                        break;
                    }
                    case "Enceladus": 
                    case "Miranda": 
                    case "Oberon": 
                    case "Titan": 
                    case "Ross128ba": {
                        string = "T5: " + s;
                        break;
                    }
                    case "Proteus": 
                    case "Triton": {
                        string = "T6: " + s;
                        break;
                    }
                    case "Haumea": 
                    case "Kuiperbelt": 
                    case "MakeMake": 
                    case "Pluto": {
                        string = "T7: " + s;
                        break;
                    }
                    case "BarnardC": 
                    case "BarnardE": 
                    case "BarnardF": 
                    case "CentauriA": 
                    case "TcetiE": 
                    case "VegaB": {
                        string = "T8: " + s;
                        break;
                    }
                    case "Anubis": 
                    case "Horus": 
                    case "Maahes": 
                    case "MehenBelt": 
                    case "Neper": 
                    case "Seth": {
                        string = "T9: " + s;
                        break;
                    }
                    case "Underdark": {
                        string = "T10: " + s;
                        break;
                    }
                    default: {
                        string = s;
                    }
                }
                dims[j] = s = string;
            }
        }
        if (dims.length > Config.maxTooltipLines) {
            dims = StringPaddingHack.stringsToSpacedColumns(dims, dims.length / Config.maxTooltipLines + (dims.length % Config.maxTooltipLines == 0 ? 0 : 1), 2);
        }
        return Arrays.asList(dims);
    }

    public static String[] parseDimNames(String line) {
        String[] dims = line.split(",");
        for (int j = 0; j < dims.length; ++j) {
            String s = dims[j];
            s = s.replaceAll(",", "");
            dims[j] = s = s.trim();
        }
        return dims;
    }

    public static Map<String, Boolean> getDims(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        HashMap<String, Boolean> enabledDims = new HashMap<String, Boolean>();
        Map<String, Boolean> origNames = oreLayer.allowedDimWithOrigNames;
        for (String dimName : origNames.keySet()) {
            String abbr = DimensionHelper.getDimAbbreviatedName(dimName);
            if (!origNames.getOrDefault(dimName, false).booleanValue()) continue;
            enabledDims.put(abbr, true);
        }
        return enabledDims;
    }

    public static Map<String, Boolean> getDims(GT5OreSmallHelper.OreSmallWrapper ore) {
        HashMap<String, Boolean> enabledDims = new HashMap<String, Boolean>();
        Map<String, Boolean> origNames = ore.allowedDimWithOrigNames;
        for (String dimName : origNames.keySet()) {
            String abbr = DimensionHelper.getDimAbbreviatedName(dimName);
            if (!origNames.getOrDefault(dimName, false).booleanValue()) continue;
            enabledDims.put(abbr, true);
        }
        return enabledDims;
    }

    public static String getDimAbbreviatedName(String dimName) {
        String abbreviatedName;
        switch (dimName) {
            case "Overworld": {
                abbreviatedName = "Ow";
                break;
            }
            case "Nether": {
                abbreviatedName = "Ne";
                break;
            }
            case "Twilight Forest": {
                abbreviatedName = "TF";
                break;
            }
            case "TheEnd": {
                abbreviatedName = "ED";
                break;
            }
            case "EndAsteroids": {
                abbreviatedName = "EA";
                break;
            }
            case "Moon": {
                abbreviatedName = "Mo";
                break;
            }
            case "Deimos": {
                abbreviatedName = "De";
                break;
            }
            case "Mars": {
                abbreviatedName = "Ma";
                break;
            }
            case "Phobos": {
                abbreviatedName = "Ph";
                break;
            }
            case "Asteroids": {
                abbreviatedName = "As";
                break;
            }
            case "Callisto": {
                abbreviatedName = "Ca";
                break;
            }
            case "Ceres": {
                abbreviatedName = "Ce";
                break;
            }
            case "Europa": {
                abbreviatedName = "Eu";
                break;
            }
            case "Ganymede": {
                abbreviatedName = "Ga";
                break;
            }
            case "Ross128b": {
                abbreviatedName = "Rb";
                break;
            }
            case "Io": {
                abbreviatedName = "Io";
                break;
            }
            case "Mercury": {
                abbreviatedName = "Me";
                break;
            }
            case "Venus": {
                abbreviatedName = "Ve";
                break;
            }
            case "Enceladus": {
                abbreviatedName = "En";
                break;
            }
            case "Miranda": {
                abbreviatedName = "Mi";
                break;
            }
            case "Oberon": {
                abbreviatedName = "Ob";
                break;
            }
            case "Titan": {
                abbreviatedName = "Ti";
                break;
            }
            case "Ross128ba": {
                abbreviatedName = "Ra";
                break;
            }
            case "Proteus": {
                abbreviatedName = "Pr";
                break;
            }
            case "Triton": {
                abbreviatedName = "Tr";
                break;
            }
            case "Haumea": {
                abbreviatedName = "Ha";
                break;
            }
            case "Kuiperbelt": {
                abbreviatedName = "KB";
                break;
            }
            case "MakeMake": {
                abbreviatedName = "MM";
                break;
            }
            case "Pluto": {
                abbreviatedName = "Pl";
                break;
            }
            case "BarnardC": {
                abbreviatedName = "BC";
                break;
            }
            case "BarnardE": {
                abbreviatedName = "BE";
                break;
            }
            case "BarnardF": {
                abbreviatedName = "BF";
                break;
            }
            case "CentauriA": {
                abbreviatedName = "CB";
                break;
            }
            case "TcetiE": {
                abbreviatedName = "TE";
                break;
            }
            case "VegaB": {
                abbreviatedName = "VB";
                break;
            }
            case "Anubis": {
                abbreviatedName = "An";
                break;
            }
            case "Horus": {
                abbreviatedName = "Ho";
                break;
            }
            case "Maahes": {
                abbreviatedName = "Mh";
                break;
            }
            case "MehenBelt": {
                abbreviatedName = "MB";
                break;
            }
            case "Neper": {
                abbreviatedName = "Np";
                break;
            }
            case "Seth": {
                abbreviatedName = "Se";
                break;
            }
            case "Underdark": {
                abbreviatedName = "DD";
                break;
            }
            default: {
                throw new IllegalStateException("String: " + dimName + " has no abbredged name!");
            }
        }
        return abbreviatedName;
    }

    public static String getFullName(String dimName) {
        String string;
        switch (dimName) {
            case "Ow": {
                string = "Overworld";
                break;
            }
            case "Ne": {
                string = "Nether";
                break;
            }
            case "TF": {
                string = "Twilight Forest";
                break;
            }
            case "ED": {
                string = "TheEnd";
                break;
            }
            case "EA": {
                string = "EndAsteroids";
                break;
            }
            case "Mo": {
                string = "Moon";
                break;
            }
            case "De": {
                string = "Deimos";
                break;
            }
            case "Ma": {
                string = "Mars";
                break;
            }
            case "Ph": {
                string = "Phobos";
                break;
            }
            case "As": {
                string = "Asteroids";
                break;
            }
            case "Ca": {
                string = "Callisto";
                break;
            }
            case "Ce": {
                string = "Ceres";
                break;
            }
            case "Eu": {
                string = "Europa";
                break;
            }
            case "Ga": {
                string = "Ganymede";
                break;
            }
            case "Rb": {
                string = "Ross128b";
                break;
            }
            case "Io": {
                string = "Io";
                break;
            }
            case "Me": {
                string = "Mercury";
                break;
            }
            case "Ve": {
                string = "Venus";
                break;
            }
            case "En": {
                string = "Enceladus";
                break;
            }
            case "Mi": {
                string = "Miranda";
                break;
            }
            case "Ob": {
                string = "Oberon";
                break;
            }
            case "Ti": {
                string = "Titan";
                break;
            }
            case "Ra": {
                string = "Ross128ba";
                break;
            }
            case "Pr": {
                string = "Proteus";
                break;
            }
            case "Tr": {
                string = "Triton";
                break;
            }
            case "Ha": {
                string = "Haumea";
                break;
            }
            case "KB": {
                string = "Kuiperbelt";
                break;
            }
            case "MM": {
                string = "MakeMake";
                break;
            }
            case "Pl": {
                string = "Pluto";
                break;
            }
            case "BC": {
                string = "BarnardC";
                break;
            }
            case "BE": {
                string = "BarnardE";
                break;
            }
            case "BF": {
                string = "BarnardF";
                break;
            }
            case "CB": {
                string = "CentauriA";
                break;
            }
            case "TE": {
                string = "TcetiE";
                break;
            }
            case "VB": {
                string = "VegaB";
                break;
            }
            case "An": {
                string = "Anubis";
                break;
            }
            case "Ho": {
                string = "Horus";
                break;
            }
            case "Mh": {
                string = "Maahes";
                break;
            }
            case "MB": {
                string = "MehenBelt";
                break;
            }
            case "Np": {
                string = "Neper";
                break;
            }
            case "Se": {
                string = "Seth";
                break;
            }
            case "DD": {
                string = "Underdark";
                break;
            }
            default: {
                throw new IllegalStateException("String: " + dimName + " has no abbredged name!");
            }
        }
        return string;
    }

    public static List<String> convertCondensedStringToToolTip(String line) {
        return tooltipBuffer.computeIfAbsent(line, tmp -> DimensionHelper.computeString(line));
    }
}

