/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.nuclear.MaterialsFluorides;
import gtPlusPlus.core.material.nuclear.MaterialsNuclides;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGenBlastSmelter
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenBlastSmelter(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateARecipe(this.toGenerate);
    }

    private void generateARecipe(Material M) {
        boolean hasMoreInputThanACircuit;
        Material[] badMaterials;
        ItemStack tStack = M.getDust(1);
        if (tStack == null) {
            return;
        }
        for (Material R : badMaterials = new Material[]{MaterialsFluorides.THORIUM_HEXAFLUORIDE, MaterialsFluorides.THORIUM_TETRAFLUORIDE, MaterialsAlloy.BLOODSTEEL, MaterialsNuclides.LiFBeF2ThF4UF4, MaterialsNuclides.LiFBeF2ZrF4UF4, MaterialsNuclides.LiFBeF2ZrF4U235, MaterialsAlloy.NITINOL_60}) {
            if (M != R) continue;
            return;
        }
        ArrayList<Object> tMaterial = new ArrayList();
        int inputStackCount = 0;
        int fluidAmount = 0;
        boolean doTest = true;
        tMaterial = M.getComposites();
        int tier = Math.max(1, M.vTier);
        long aVoltage = GTValues.VP[tier];
        int duration = 120 * tier * 10;
        if (tier <= 4) {
            duration = 20 * tier * 10;
        }
        int mMaterialListSize = 0;
        int mTotalPartsCounter = M.smallestStackSizeWhenProcessing;
        if (M.getComposites() != null) {
            for (MaterialStack ternkfsdf : M.getComposites()) {
                if (ternkfsdf == null) continue;
                ++mMaterialListSize;
            }
        } else {
            mMaterialListSize = 1;
        }
        Logger.WARNING("[BAS] Size: " + mMaterialListSize);
        ItemStack circuitGT = GTUtility.getIntegratedCircuit(1);
        ItemStack[] tItemStackTest = new ItemStack[]{circuitGT, tStack};
        inputStackCount = 1;
        fluidAmount = 144 * inputStackCount;
        Logger.WARNING("[BAS] Adding an Alloy Blast Smelter Recipe for " + M.getLocalizedName() + ". Gives " + fluidAmount + "L of molten metal.");
        for (int das = 0; das < tItemStackTest.length; ++das) {
            if (tItemStackTest[das] == null) continue;
            Logger.WARNING("[BAS] tMaterial[" + das + "]: " + tItemStackTest[das].func_82833_r() + " Meta: " + tItemStackTest[das].func_77960_j() + ", Amount: " + tItemStackTest[das].field_77994_a);
        }
        boolean bl = hasMoreInputThanACircuit = tItemStackTest.length > 1;
        if (hasMoreInputThanACircuit) {
            if (M.requiresBlastFurnace()) {
                GTValues.RA.stdBuilder().itemInputs(tItemStackTest).fluidOutputs(M.getFluidStack(fluidAmount)).duration(duration / (mTotalPartsCounter > 0 ? mTotalPartsCounter : 1)).eut(aVoltage).recipeCategory(RecipeCategories.absNonAlloyRecipes).addTo(GTPPRecipeMaps.alloyBlastSmelterRecipes);
            } else {
                Logger.WARNING("[BAS] Failed.");
            }
        } else {
            GTValues.RA.stdBuilder().itemInputs(tItemStackTest).fluidOutputs(M.getFluidStack(fluidAmount)).eut(aVoltage).duration(duration / (mTotalPartsCounter > 0 ? mTotalPartsCounter : 1) / 2).addTo(GTPPRecipeMaps.alloyBlastSmelterRecipes);
            Logger.WARNING("[BAS] Success.");
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(M.getIngot(1)).fluidInputs(M.getFluidStack(144)).duration(duration / 2).eut(60).addTo(RecipeMaps.fluidSolidifierRecipes);
            Logger.WARNING("[BAS] Success, Also added a Fluid solidifier recipe.");
        }
        if (tMaterial == null) {
            Logger.WARNING("[BAS] doTest: true | tMaterial == null: true");
            return;
        }
        inputStackCount = 0;
        if (mMaterialListSize <= 1) {
            return;
        }
        MaterialStack[] tempStack = new MaterialStack[mMaterialListSize];
        circuitGT = GTUtility.getIntegratedCircuit(mMaterialListSize);
        int ooo = 0;
        for (MaterialStack xMaterial : M.getComposites()) {
            if (xMaterial == null) {
                ++ooo;
                continue;
            }
            if (xMaterial.getStackMaterial() == null) {
                tempStack[ooo] = xMaterial;
                ++ooo;
                continue;
            }
            Logger.WARNING("[BAS] FOUND: " + xMaterial.getStackMaterial().getLocalizedName());
            Logger.WARNING("[BAS] ADDING: " + xMaterial.getStackMaterial().getLocalizedName());
            tempStack[ooo] = xMaterial;
            ++ooo;
        }
        ItemStack[] components = new ItemStack[9];
        inputStackCount = 0;
        FluidStack componentsFluid = null;
        for (int irc = 0; irc < M.getComposites().size(); ++irc) {
            if (M.getComposites().get(irc) == null) continue;
            int r = (int)M.vSmallestRatio[irc];
            inputStackCount += r;
            if (M.getComposites().get(irc).getStackMaterial().getState() != MaterialState.SOLID || !ItemUtils.checkForInvalidItems(M.getComposites().get(irc).getDustStack(r))) {
                if (r <= 0 || r > 100) continue;
                int mathmatics = r * 1000;
                componentsFluid = FluidUtils.getFluidStack(M.getComposites().get(irc).getStackMaterial().getFluidStack(mathmatics), mathmatics);
                continue;
            }
            components[irc] = M.getComposites().get(irc).getUnificatedDustStack(r);
        }
        if (mMaterialListSize < 9 && mMaterialListSize != 0) {
            ItemStack[] components_NoCircuit = components;
            components = new ItemStack[components_NoCircuit.length + 1];
            for (int fr = 0; fr < components.length; ++fr) {
                if (fr == 0) {
                    components[0] = circuitGT;
                    continue;
                }
                components[fr] = components_NoCircuit[fr - 1];
            }
            Logger.WARNING("[BAS] Should have added a circuit. mMaterialListSize: " + mMaterialListSize + " | circuit: " + components[0].func_82833_r());
        } else {
            Logger.WARNING("[BAS] Did not add a circuit. mMaterialListSize: " + mMaterialListSize);
        }
        fluidAmount = 144 * inputStackCount;
        Logger.WARNING("[BAS] Adding an Alloy Blast Smelter Recipe for " + M.getLocalizedName() + " using it's compound dusts. This material has " + inputStackCount + " parts. Gives " + fluidAmount + "L of molten metal.");
        Logger.WARNING("[BAS] tMaterial.length: " + components.length + ".");
        for (int das = 0; das < components.length; ++das) {
            if (components[das] == null) continue;
            Logger.WARNING("[BAS] tMaterial[" + das + "]: " + components[das].func_82833_r() + " Meta: " + components[das].func_77960_j() + ", Amount: " + components[das].field_77994_a);
        }
        GTRecipeBuilder builder = GTValues.RA.stdBuilder();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(components));
        inputs.removeIf(Objects::isNull);
        components = inputs.toArray(new ItemStack[0]);
        builder = builder.itemInputs(components);
        if (componentsFluid != null) {
            builder.fluidInputs(componentsFluid);
        }
        builder.fluidOutputs(M.getFluidStack(fluidAmount));
        if (M.requiresBlastFurnace()) {
            builder.eut(aVoltage);
        } else {
            builder.eut(aVoltage / 2L);
        }
        builder.duration(duration).addTo(GTPPRecipeMaps.alloyBlastSmelterRecipes);
        Logger.WARNING("[BAS] Success.");
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

