/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.common.blocks.BlockCasings9;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTESteamWaterPump
extends MTESteamMultiBase<MTESteamWaterPump>
implements ISurvivalConstructable {
    private static IStructureDefinition<MTESteamWaterPump> STRUCTURE_DEFINITION = null;
    private static final int HORIZONTAL_OFF_SET = 1;
    private static final int VERTICAL_OFF_SET = 2;
    private static final int DEPTH_OFF_SET = 0;
    private static final String tier1 = "tier1";
    private static final String tier2 = "tier2";
    private static final int BASE_WATER_PER_SECOND = 1500;
    private static final int PROGRESSION_TIME_TICKS = 20;
    private static final int BASE_STEAM_PER_SECOND = 1500;
    private int mSetTier = 1;
    private float currentHumidity;
    private static final Fluid water = FluidRegistry.getFluid((String)"water");
    private int mCountCasing;

    public MTESteamWaterPump(String aName) {
        super(aName);
    }

    public MTESteamWaterPump(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamWaterPump(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Water Pump";
    }

    private FluidStack[] getWater() {
        return new FluidStack[]{new FluidStack(water, this.calculateFinalWaterOutput())};
    }

    private float getHumidity() {
        return this.getBaseMetaTileEntity().getWorld().func_72807_a((int)this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getZCoord()).field_76751_G;
    }

    private int calculateFinalWaterOutput() {
        return (int)(this.currentHumidity * 1500.0f * (float)this.mSetTier);
    }

    @Override
    public IStructureDefinition<MTESteamWaterPump> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(tier1, StructureUtility.transpose((String[][])new String[][]{{" A ", " A ", "AAA", " A "}, {" A ", "   ", "A A", " A "}, {"C~C", "CCC", "CCC", "CCC"}})).addShape(tier2, StructureUtility.transpose((String[][])new String[][]{{" D ", " D ", "DDD", " D "}, {" D ", "   ", "D D", " D "}, {"C~C", "CCC", "CCC", "CCC"}})).addElement('A', GTStructureUtility.ofFrame(Materials.Bronze)).addElement('D', GTStructureUtility.ofFrame(Materials.Steel)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamWaterPump.buildSteamInput(MTESteamWaterPump.class).casingIndex(((BlockCasings9)GregTechAPI.sBlockCasings9).getTextureIndex(2)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamWaterPump.class).atLeast(HatchElement.OutputHatch).casingIndex(((BlockCasings9)GregTechAPI.sBlockCasings9).getTextureIndex(2)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCountCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)2)))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        if (stackSize.field_77994_a == 1) {
            this.buildPiece(tier1, stackSize, hintsOnly, 1, 2, 0);
        } else {
            this.buildPiece(tier2, stackSize, hintsOnly, 1, 2, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = 0;
        if (stackSize.field_77994_a == 1) {
            this.mSetTier = 1;
            built += this.survivialBuildPiece(tier1, stackSize, 1, 2, 0, elementBudget, env, false, true);
        } else {
            this.mSetTier = 2;
            built += this.survivialBuildPiece(tier2, stackSize, 1, 2, 0, elementBudget, env, false, true);
        }
        return built;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCountCasing = 0;
        this.mSetTier = 1;
        if (!this.checkPiece(tier1, 1, 2, 0)) {
            if (!this.checkPiece(tier2, 1, 2, 0)) {
                return false;
            }
            this.mSetTier = 2;
        }
        if (this.mOutputHatches.size() != 1 || this.mSteamInputFluids.size() != 1) {
            return false;
        }
        this.currentHumidity = this.getHumidity();
        return this.mCountCasing >= 9;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 2)), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 2))};
    }

    @Override
    protected GTRenderedTexture getFrontOverlay() {
        return new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_WATER_PUMP);
    }

    @Override
    protected GTRenderedTexture getFrontOverlayActive() {
        return new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_WATER_PUMP_ACTIVE);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Pumps Water based on humidity").addInfo("Has 2 tiers: Bronze and Steel").addInfo("Steel tier extracts 2x Water").addInfo(EnumChatFormatting.AQUA + "Generates: " + EnumChatFormatting.WHITE + " humidity * tier * " + 1500 + " L/s" + EnumChatFormatting.AQUA + " of Water." + EnumChatFormatting.RESET).addInfo(EnumChatFormatting.RED + "Consumes: " + EnumChatFormatting.WHITE + 1500 + " L/s" + EnumChatFormatting.RED + " of Steam." + EnumChatFormatting.RESET).beginStructureBlock(3, 3, 5, false).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addStructureInfo(EnumChatFormatting.WHITE + "Steam Input Hatch " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 1).addStructureInfo(EnumChatFormatting.GOLD + "10" + EnumChatFormatting.GRAY + " Bronze Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "9" + EnumChatFormatting.GRAY + " Wooden Casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 2).addStructureInfo(EnumChatFormatting.GOLD + "10" + EnumChatFormatting.GRAY + " Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "9 " + EnumChatFormatting.GRAY + " Wooden Casing").toolTipFinisher(GTValues.AuthorEvgenWarGold);
        return tt;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        VoidProtectionHelper voidProtection = new VoidProtectionHelper().setMachine(this).setFluidOutputs(this.getWater()).build();
        if (voidProtection.isFluidFull()) {
            this.mOutputFluids = null;
            this.mMaxProgresstime = 0;
            return CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
        }
        if (this.getTotalSteamStored() >= 1500) {
            this.mMaxProgresstime = 20;
            this.tryConsumeSteam(1500);
            this.mOutputFluids = this.getWater();
            this.updateSlots();
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    @Override
    public int getTierRecipes() {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 1200L == 0L) {
            this.currentHumidity = this.getHumidity();
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        int tierMachine = tag.func_74762_e("mSetTier");
        String tierMachineText = tierMachine == 1 ? "Bronze" : (tierMachine == 2 ? "Steel" : String.valueOf(tierMachine));
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.BLUE + tierMachineText + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.biomes.humidity") + " " + EnumChatFormatting.BLUE + tag.func_74760_g("humidity") + " %" + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74776_a("humidity", this.currentHumidity * 100.0f);
        tag.func_74768_a("mSetTier", this.mSetTier);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSetTier", this.mSetTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSetTier = aNBT.func_74762_e("mSetTier");
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_WATER_PUMP_LOOP;
    }
}

