/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.custom;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.recipe.RecipeMaps;
import gregtech.common.items.CombType;
import gregtech.loaders.misc.GTBees;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.base.ingots.BaseItemIngotOld;
import gtPlusPlus.core.item.base.misc.BaseItemMisc;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.forestry.bees.custom.GTPPBeeDefinition;
import gtPlusPlus.xmod.forestry.bees.custom.ItemCustomComb;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTPPBees {
    public static Item dropForceGem;
    public static Item dropBiomassBlob;
    public static Item dropEthanolBlob;
    public static Item dropNikoliteDust;
    public static Item dropFluorineBlob;
    public static ItemCustomComb combs;
    public static ItemStack Comb_Slag;
    public static ItemStack Comb_Stone;
    public static Materials PTFE;
    public static Materials PBS;

    public GTPPBees() {
        if (Mods.Forestry.isModLoaded()) {
            this.setMaterials();
            this.setCustomItems();
            try {
                combs = new ItemCustomComb();
                combs.initCombsRecipes();
                GTPPBeeDefinition.initBees();
            }
            catch (Throwable t) {
                Logger.BEES("Failed to load bees, probably due to an ancient forestry version");
                t.printStackTrace();
            }
        }
    }

    private void setCustomItems() {
        dropForceGem = new BaseItemMisc("Force", new short[]{250, 250, 20}, 64, BaseItemMisc.MiscTypes.GEM, null);
        dropBiomassBlob = new BaseItemMisc("Biomass", new short[]{33, 225, 24}, 64, BaseItemMisc.MiscTypes.DROP, null);
        dropEthanolBlob = new BaseItemMisc("Ethanol", new short[]{255, 128, 0}, 64, BaseItemMisc.MiscTypes.DROP, null);
        dropNikoliteDust = ItemUtils.generateSpecialUseDusts("Nikolite", "Nikolite", Utils.rgbtoHexValue(60, 180, 200))[2];
        if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ingotNikolite", 1) == null) {
            new BaseItemIngotOld("itemIngotNikolite", "Nikolite", Utils.rgbtoHexValue(60, 180, 200), 0);
        }
        dropFluorineBlob = new BaseItemMisc("Fluorine", new short[]{30, 230, 230}, 64, BaseItemMisc.MiscTypes.DROP, null);
        this.addRecipes();
    }

    private void addRecipes() {
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropBiomassBlob), FluidUtils.getFluidStack("biomass", 30));
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropEthanolBlob), FluidUtils.getFluidStack("ethanol", 6));
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropFluorineBlob), FluidUtils.getFluidStack("fluorine", 4));
    }

    private void addExtractorRecipe(ItemStack input, FluidStack output) {
        GTValues.RA.stdBuilder().itemInputs(input).fluidOutputs(output).duration(30).eut(8).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    private void setMaterials() {
        if (Comb_Slag == null) {
            Comb_Slag = GTBees.combs.getStackForType(CombType.SLAG);
        }
        if (Comb_Stone == null) {
            Comb_Stone = GTBees.combs.getStackForType(CombType.STONE);
        }
        if (PTFE == null) {
            PTFE = this.trySetValue("Polytetrafluoroethylene");
        }
        if (PBS == null) {
            PBS = this.trySetValue("StyreneButadieneRubber");
        }
    }

    private Materials trySetValue(String material) {
        Materials mTemp = Materials.get(material);
        if (mTemp != Materials._NULL) {
            return mTemp;
        }
        return Materials._NULL;
    }
}

