/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.machines;

import gtPlusPlus.api.objects.minecraft.BTF_FluidTank;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBaseFluidCollector
extends TileEntityBase
implements IFluidHandler {
    public final FluidTank tank;
    private boolean needsUpdate = false;
    private int updateTimer = 0;
    private long internalTickCounter = 0L;
    private BlockPos internalBlockLocation;

    public TileEntityBaseFluidCollector(int aInvSlotCount, int aTankCapcity) {
        super(aInvSlotCount);
        this.tank = new BTF_FluidTank(aTankCapcity);
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        this.needsUpdate = true;
        return this.tank.fill(resource, doFill);
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        this.needsUpdate = true;
        return this.tank.drain(resource.amount, doDrain);
    }

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.needsUpdate = true;
        FluidStack fluid = this.tank.getFluid();
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
            }
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.tank, 0));
        }
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public final void func_145845_h() {
        super.func_145845_h();
        this.onPreLogicTick();
        this.logicTick();
        if (this.needsUpdate) {
            if (this.updateTimer == 0) {
                this.updateTimer = 10;
            } else {
                --this.updateTimer;
                if (this.updateTimer == 0) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.needsUpdate = false;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        super.func_145841_b(tag);
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public int getBaseTickRate() {
        return MathUtils.randInt(200, 300);
    }

    public abstract ArrayList<Class> aThingsToLookFor();

    public abstract void onPreLogicTick();

    public final void logicTick() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.internalTickCounter % (long)this.getBaseTickRate() == 0L) {
            BlockPos p;
            if (this.internalBlockLocation == null) {
                this.internalBlockLocation = new BlockPos(this);
            }
            if ((p = this.internalBlockLocation) != null && p.world != null) {
                World w = this.field_145850_b;
                if (w == null) {
                    return;
                }
                Chunk c = w.func_72938_d(p.xPos, p.zPos);
                if (c != null && c.field_76636_d) {
                    int startX = p.xPos - 2;
                    int startY = p.yPos;
                    int startZ = p.zPos - 2;
                    int endX = p.xPos + 3;
                    int endY = p.yPos + 5;
                    int endZ = p.zPos + 3;
                    AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
                    if (box != null) {
                        for (Class c2 : this.aThingsToLookFor()) {
                            this.tickEntityType(w, box, c2);
                        }
                    } else {
                        return;
                    }
                }
            }
        }
        ++this.internalTickCounter;
    }

    public final void tickEntityType(World w, AxisAlignedBB box, Class aClassToFind) {
        List entities = w.func_72872_a(aClassToFind, box);
        if (entities != null && !entities.isEmpty()) {
            this.interactWithEntities(entities);
        }
    }

    public final <V> void interactWithEntities(List<V> entities) {
        for (V aEntity : entities) {
            this.addDrop(aEntity);
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
                int aFluidAmount = this.onPostTick(aEntity);
                aFluidAmount = Math.max(Math.min(this.tank.getCapacity() - this.tank.getFluidAmount(), aFluidAmount), 1);
                this.tank.fill(FluidUtils.getFluidStack(this.fluidToProvide(), aFluidAmount), true);
                continue;
            }
            ItemStack aDirtStack = ItemUtils.getSimpleStack(this.itemToSpawnInWorldIfTankIsFull(), 1);
            if (!ItemUtils.checkForInvalidItems(aDirtStack)) {
                return;
            }
            if (this.mInventory.addItemStack(aDirtStack)) continue;
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d + 1.5, (double)this.field_145849_e, aDirtStack);
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public abstract <V> int onPostTick(V var1);

    public abstract <V> boolean addDrop(V var1);

    public abstract Fluid fluidToProvide();

    public abstract ItemStack itemToSpawnInWorldIfTankIsFull();
}

