/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.events;

import gtPlusPlus.api.objects.Logger;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;

public class SneakManager {
    public static ConcurrentHashMap<String, SneakManager> mPlayerCache = new ConcurrentHashMap();
    public SneakManager instance;
    public EntityPlayer owner;
    public boolean canSprint = true;
    public boolean isSneaking = true;
    public boolean optionDoubleTap = true;
    public boolean wasSprintDisabled = false;
    public boolean mIsWearingRing = false;
    private State Sprinting = State.ON;
    private State Crouching = State.OFF;

    private static void addPlayer(EntityPlayer aPlayer) {
        String aKey = SneakManager.getKey(aPlayer);
        if (!mPlayerCache.containsKey(aKey)) {
            mPlayerCache.put(aKey, new SneakManager(aPlayer));
        }
    }

    public static SneakManager get(EntityPlayer aPlayer) {
        String aKey = SneakManager.getKey(aPlayer);
        if (!mPlayerCache.containsKey(aKey)) {
            SneakManager.addPlayer(aPlayer);
        }
        return mPlayerCache.get(aKey);
    }

    private static String getKey(EntityPlayer aPlayer) {
        return aPlayer.func_146103_bH().getId().toString();
    }

    public SneakManager(EntityPlayer aPlayer) {
        this.owner = aPlayer;
    }

    public boolean Sneaking() {
        return this.Crouching.getState();
    }

    public boolean Sprinting() {
        return this.Sprinting.getState();
    }

    public State getSneakingState() {
        return this.Crouching;
    }

    public State getSprintingDisabledState() {
        return this.Sprinting;
    }

    public void toggleSneaking() {
        this.toggleState(this.Crouching);
    }

    public void toggleSprinting() {
        this.toggleState(this.Sprinting);
    }

    private State toggleState(State state) {
        Logger.INFO("State Toggle");
        if (state == State.ON) {
            return State.OFF;
        }
        return State.ON;
    }

    private State setCrouchingStateON() {
        this.Crouching = State.ON;
        return this.Crouching;
    }

    private State setCrouchingStateOFF() {
        this.Crouching = State.OFF;
        return this.Crouching;
    }

    private State setSprintingStateON() {
        this.Sprinting = State.ON;
        return this.Sprinting;
    }

    private State setSprintingStateOFF() {
        this.Sprinting = State.OFF;
        return this.Sprinting;
    }

    public void putRingOn() {
        this.mIsWearingRing = true;
        this.setSprintingStateOFF();
        this.setCrouchingStateON();
    }

    public void takeRingOff() {
        this.mIsWearingRing = false;
        this.setSprintingStateON();
        this.setCrouchingStateOFF();
    }

    public boolean isWearingRing() {
        return this.mIsWearingRing;
    }

    public static enum State {
        ON(true),
        OFF(false);

        private final boolean STATE;

        private State(boolean State2) {
            this.STATE = State2;
        }

        public boolean getState() {
            return this.STATE;
        }
    }
}

