/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockPos
implements Serializable {
    private static final long serialVersionUID = -7271947491316682006L;
    public final int xPos;
    public final int yPos;
    public final int zPos;
    public final int dim;
    public final transient World world;

    public static BlockPos generateBlockPos(String sUUID) {
        String[] s2 = sUUID.split("@");
        return new BlockPos(s2);
    }

    public BlockPos(String[] s) {
        this(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[0]));
    }

    public BlockPos(int x, int y, int z) {
        this(x, y, z, 0);
    }

    public BlockPos(int x, int y, int z, int dim) {
        this(x, y, z, (World)DimensionManager.getWorld((int)dim));
    }

    public BlockPos(int x, int y, int z, World dim) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        if (dim != null) {
            this.dim = dim.field_73011_w.field_76574_g;
            this.world = dim;
        } else {
            this.dim = 0;
            this.world = null;
        }
    }

    public BlockPos(IGregTechTileEntity b) {
        this(b.getXCoord(), (int)b.getYCoord(), b.getZCoord(), b.getWorld());
    }

    public BlockPos(TileEntity b) {
        this(b.field_145851_c, b.field_145848_d, b.field_145849_e, b.func_145831_w());
    }

    public String getLocationString() {
        return "[X: " + this.xPos + "][Y: " + this.yPos + "][Z: " + this.zPos + "][Dim: " + this.dim + "]";
    }

    public String getUniqueIdentifier() {
        return this.dim + "@" + this.xPos + "@" + this.yPos + "@" + this.zPos;
    }

    public int hashCode() {
        int hash = 5;
        hash += 13 * this.xPos;
        hash += 19 * this.yPos;
        hash += 31 * this.zPos;
        return hash += 17 * this.dim;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof BlockPos)) {
            return false;
        }
        BlockPos otherPoint = (BlockPos)other;
        return this.xPos == otherPoint.xPos && this.yPos == otherPoint.yPos && this.zPos == otherPoint.zPos && this.dim == otherPoint.dim;
    }

    public int distanceFrom(BlockPos target) {
        if (target.dim != this.dim) {
            return Short.MIN_VALUE;
        }
        return this.distanceFrom(target.xPos, target.yPos, target.zPos);
    }

    public int distanceFrom(int x, int y, int z) {
        int distanceX = this.xPos - x;
        int distanceY = this.yPos - y;
        int distanceZ = this.zPos - z;
        return distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
    }

    public boolean isWithinRange(BlockPos target, int range) {
        if (target.dim != this.dim) {
            return false;
        }
        return this.isWithinRange(target.xPos, target.yPos, target.zPos, range);
    }

    public boolean isWithinRange(int x, int y, int z, int range) {
        return this.distanceFrom(x, y, z) <= range * range;
    }

    public BlockPos getUp() {
        return new BlockPos(this.xPos, this.yPos + 1, this.zPos, this.dim);
    }

    public BlockPos getDown() {
        return new BlockPos(this.xPos, this.yPos - 1, this.zPos, this.dim);
    }

    public BlockPos getXPos() {
        return new BlockPos(this.xPos + 1, this.yPos, this.zPos, this.dim);
    }

    public BlockPos getXNeg() {
        return new BlockPos(this.xPos - 1, this.yPos, this.zPos, this.dim);
    }

    public BlockPos getZPos() {
        return new BlockPos(this.xPos, this.yPos, this.zPos + 1, this.dim);
    }

    public BlockPos getZNeg() {
        return new BlockPos(this.xPos, this.yPos, this.zPos - 1, this.dim);
    }

    public ArrayList<BlockPos> getSurroundingBlocks() {
        ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
        sides.add(this.getUp());
        sides.add(this.getDown());
        sides.add(this.getXPos());
        sides.add(this.getXNeg());
        sides.add(this.getZPos());
        sides.add(this.getZNeg());
        return sides;
    }

    public Block getBlockAtPos() {
        return this.getBlockAtPos(this);
    }

    public Block getBlockAtPos(BlockPos pos) {
        return this.getBlockAtPos(this.world, pos);
    }

    public Block getBlockAtPos(World world, BlockPos pos) {
        return world.func_147439_a(pos.xPos, pos.yPos, pos.zPos);
    }

    public int getMetaAtPos() {
        return this.getMetaAtPos(this);
    }

    public int getMetaAtPos(BlockPos pos) {
        return this.getMetaAtPos(this.world, pos);
    }

    public int getMetaAtPos(World world, BlockPos pos) {
        return world.func_72805_g(pos.xPos, pos.yPos, pos.zPos);
    }

    public boolean hasSimilarNeighbour() {
        return this.hasSimilarNeighbour(false);
    }

    public boolean hasSimilarNeighbour(boolean strict) {
        for (BlockPos g : this.getSurroundingBlocks()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                return true;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<BlockPos> getSimilarNeighbour() {
        return this.getSimilarNeighbour(false);
    }

    public ArrayList<BlockPos> getSimilarNeighbour(boolean strict) {
        ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
        for (BlockPos g : this.getSurroundingBlocks()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                sides.add(g);
                continue;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            sides.add(g);
        }
        return sides;
    }

    public Set<BlockPos> getValidNeighboursAndSelf() {
        ArrayList<BlockPos> h = this.getSimilarNeighbour(true);
        h.add(this);
        return new HashSet<BlockPos>(h);
    }
}

