/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.registerPackages;

import gregtech.shadow.com.github.technus.avrClone.registerPackages.IInterrupt;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IRegister;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IRegisterBit;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IRegisterPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RegisterPackage<T extends RegisterPackage<T>>
implements IRegisterPackage<T> {
    protected final Map<String, IRegisterBit<T>> bits = new HashMap<String, IRegisterBit<T>>();
    protected final Map<String, IRegister<T>> registers = new HashMap<String, IRegister<T>>();
    protected final Map<Integer, List<IRegister<T>>> addresses = new HashMap<Integer, List<IRegister<T>>>();
    protected final Map<Integer, IInterrupt<T>> interrupts = new HashMap<Integer, IInterrupt<T>>();
    private final int offset;
    private final int size;

    protected RegisterPackage(int offset, int size) {
        RegisterPackage checkCast = this;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Map<String, IRegister<T>> registersMap() {
        return this.registers;
    }

    @Override
    public Map<Integer, List<IRegister<T>>> addressesMap() {
        return this.addresses;
    }

    @Override
    public Map<String, IRegisterBit<T>> bitsMap() {
        return this.bits;
    }

    @Override
    public int[] getDataDefault() {
        return new int[this.getSize()];
    }

    @Override
    public Map<Integer, IInterrupt<T>> interruptsMap() {
        return this.interrupts;
    }

    protected void addRegisters(IRegister<T> ... registers) {
        for (IRegister<RegisterPackage> iRegister : registers) {
            this.registers.put(iRegister.name(), iRegister);
            this.addresses.computeIfAbsent(iRegister.getAddress(this), ArrayList::new).add(iRegister);
        }
    }

    protected void addBits(IRegisterBit<T> ... bits) {
        for (IRegisterBit<T> bit : bits) {
            this.bits.put(bit.name(), bit);
        }
    }

    protected void addInterrupts(IInterrupt<T> ... interrupts) {
        for (IInterrupt<T> interrupt : interrupts) {
            this.interrupts.put(interrupt.getVector(), interrupt);
        }
    }
}

