/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.memory.program;

import gregtech.shadow.com.github.technus.avrClone.compiler.Line;
import gregtech.shadow.com.github.technus.avrClone.instructions.IInstruction;
import gregtech.shadow.com.github.technus.avrClone.instructions.InstructionRegistry;
import gregtech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidDirective;
import gregtech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidMnemonic;
import gregtech.shadow.com.github.technus.avrClone.memory.program.exceptions.ProgramException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ProgramMemory
implements Cloneable {
    public final int[] instructions;
    public final int[] param0;
    public final int[] param1;
    public final InstructionRegistry registry;
    public final boolean immersiveOperands;

    public ProgramMemory(InstructionRegistry registry, boolean immersiveOperands, List<String> stringsList) throws Exception {
        this.registry = registry;
        this.immersiveOperands = immersiveOperands;
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < stringsList.size(); ++i) {
            lines.add(new Line(null, null, i, stringsList.get(i), false));
        }
        int size = ProgramMemory.countPC(lines);
        this.instructions = new int[size];
        this.param0 = new int[size];
        this.param1 = new int[size];
        this.compile(immersiveOperands, lines);
    }

    public ProgramMemory(InstructionRegistry registry, boolean immersiveOperands, String ... strings) throws Exception {
        this.registry = registry;
        this.immersiveOperands = immersiveOperands;
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < strings.length; ++i) {
            lines.add(new Line(null, null, i, strings[i], false));
        }
        int size = ProgramMemory.countPC(lines);
        this.instructions = new int[size];
        this.param0 = new int[size];
        this.param1 = new int[size];
        this.compile(immersiveOperands, lines);
    }

    public ProgramMemory(InstructionRegistry registry, boolean immersiveOperands, int size) {
        this.registry = registry;
        this.immersiveOperands = immersiveOperands;
        this.instructions = new int[size];
        this.param0 = new int[size];
        this.param1 = new int[size];
    }

    public ProgramMemory(InstructionRegistry registry, boolean immersiveOperands, int[] instructions, int[] param0, int[] param1) {
        this.instructions = instructions;
        this.param0 = param0;
        this.param1 = param1;
        this.registry = registry;
        this.immersiveOperands = immersiveOperands;
    }

    public static int countPC(ArrayList<Line> lines) {
        int pc = 0;
        for (Line l : lines) {
            if (l.getMnemonic() == null) continue;
            ++pc;
        }
        return pc;
    }

    public void print(PrintStream printStream) {
        block5: for (int i = 0; i < this.instructions.length; ++i) {
            IInstruction instruction = this.registry.getInstruction(this.instructions[i]);
            switch (instruction.getOperandCount()) {
                case 0: {
                    printStream.println(i + " : " + instruction.name());
                    continue block5;
                }
                case 1: {
                    printStream.println(i + " : " + instruction.name() + " " + this.param0[i]);
                    continue block5;
                }
                case 2: {
                    printStream.println(i + " : " + instruction.name() + " " + this.param0[i] + "," + this.param1[i]);
                }
            }
        }
    }

    public String getProgram(int radix) {
        String prefix = "";
        switch (radix) {
            case 2: {
                prefix = "0b";
                break;
            }
            case 8: {
                prefix = "0";
                break;
            }
            case 16: {
                prefix = "0x";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.instructions.length; ++i) {
            IInstruction instruction = this.registry.getInstruction(this.instructions[i]);
            switch (instruction.getOperandCount()) {
                case 0: {
                    stringBuilder.append(instruction.name());
                    break;
                }
                case 1: {
                    stringBuilder.append(instruction.name()).append(' ');
                    stringBuilder.append(prefix).append(Integer.toString(this.param0[i], radix));
                    break;
                }
                case 2: {
                    stringBuilder.append(instruction.name()).append(' ');
                    stringBuilder.append(prefix).append(Integer.toString(this.param0[i], radix)).append(',');
                    stringBuilder.append(prefix).append(Integer.toString(this.param1[i], radix));
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String getProgramWithLineNumbers(int radix, int radixLines) {
        String prefix = "";
        switch (radix) {
            case 2: {
                prefix = "0b";
                break;
            }
            case 8: {
                prefix = "0";
                break;
            }
            case 16: {
                prefix = "0x";
            }
        }
        String prefixLines = "";
        switch (radixLines) {
            case 2: {
                prefixLines = "0b";
                break;
            }
            case 8: {
                prefixLines = "0";
                break;
            }
            case 16: {
                prefixLines = "0x";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        int lenOfLineNumbers = Integer.toString(this.instructions.length - 1, radixLines).length();
        for (int i = 0; i < this.instructions.length; ++i) {
            IInstruction instruction = this.registry.getInstruction(this.instructions[i]);
            stringBuilder.append(prefixLines).append(String.format("%1$-" + lenOfLineNumbers + "s", Integer.toString(i, radixLines))).append(" : ");
            switch (instruction.getOperandCount()) {
                case 0: {
                    stringBuilder.append(instruction.name());
                    break;
                }
                case 1: {
                    stringBuilder.append(instruction.name()).append(' ');
                    stringBuilder.append(prefix).append(Integer.toString(this.param0[i], radix));
                    break;
                }
                case 2: {
                    stringBuilder.append(instruction.name()).append(' ');
                    stringBuilder.append(prefix).append(Integer.toString(this.param0[i], radix)).append(',');
                    stringBuilder.append(prefix).append(Integer.toString(this.param1[i], radix));
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void compile(boolean immersiveOperands, ArrayList<Line> lines) throws Exception {
        Line line = null;
        int[] operandsReturn = new int[2];
        try {
            int pc = 0;
            for (int i = 0; i < lines.size(); ++i) {
                line = lines.get(i);
                if (line.getMnemonic() == null) continue;
                if (line.getDirectiveName() != null) {
                    throw new InvalidDirective("Unknown directive " + line.getDirectiveName() + " At line " + line.getLineNumber());
                }
                String[] values = line.getLatestArgumentArray();
                Integer id = this.registry.getId(line.getMnemonic());
                if (id == null) {
                    id = this.registry.getId(line.getMnemonic().toUpperCase());
                }
                if (id == null) {
                    throw new InvalidMnemonic("Instruction " + line.getMnemonic() + " At line " + line.getLineNumber() + " Mnemonic does not exist");
                }
                this.instructions[pc] = id;
                operandsReturn[1] = 0;
                operandsReturn[0] = 0;
                this.registry.getInstruction(this.instructions[pc]).compileInstruction(this, pc, immersiveOperands, operandsReturn, values);
                this.param0[pc] = operandsReturn[0];
                this.param1[pc] = operandsReturn[1];
                ++pc;
            }
        }
        catch (ProgramException e) {
            throw e;
        }
        catch (Exception e) {
            if (line == null) {
                throw new ProgramException("Program compilation failed!", e);
            }
            throw new ProgramException("Program compilation failed! At line " + line.getLineNumber() + " : " + line.getLine(), e);
        }
    }

    public ProgramMemory clone() {
        ProgramMemory programMemory = new ProgramMemory(this.registry, this.immersiveOperands, this.instructions.length);
        System.arraycopy(this.instructions, 0, programMemory.instructions, 0, this.instructions.length);
        System.arraycopy(this.param0, 0, programMemory.param0, 0, this.param0.length);
        System.arraycopy(this.param1, 0, programMemory.param1, 0, this.param1.length);
        return programMemory;
    }
}

