/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.compiler;

import gregtech.shadow.com.github.technus.avrClone.compiler.Binding;
import gregtech.shadow.com.github.technus.avrClone.compiler.ConditionalState;
import gregtech.shadow.com.github.technus.avrClone.compiler.Line;
import gregtech.shadow.com.github.technus.avrClone.compiler.ListingMode;
import gregtech.shadow.com.github.technus.avrClone.compiler.Segment;
import gregtech.shadow.com.github.technus.avrClone.compiler.SourceCollection;
import gregtech.shadow.com.github.technus.avrClone.compiler.directives.Directive;
import gregtech.shadow.com.github.technus.avrClone.compiler.directives.IDirective;
import gregtech.shadow.com.github.technus.avrClone.compiler.directives.exceptions.InvalidDirective;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.CompilerException;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidBinding;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidConditionalAssembly;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidConstant;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidInclude;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidListingMode;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidMacroStatement;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidMemoryAccess;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidMemoryAllocation;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidMemorySegment;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidOrigin;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidStartOffset;
import gregtech.shadow.com.github.technus.avrClone.compiler.js.CompilerBindings;
import gregtech.shadow.com.github.technus.avrClone.compiler.js.CompilerContext;
import gregtech.shadow.com.github.technus.avrClone.compiler.js.exceptions.EvaluationException;
import gregtech.shadow.com.github.technus.avrClone.compiler.js.exceptions.InvalidConditionalEvaluation;
import gregtech.shadow.com.github.technus.avrClone.compiler.js.exceptions.PrintingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class ProgramCompiler {
    private static final String SANDBOX = "var eval=function(){};var uneval=function(){};var decodeURI=function(){};var decodeURIComponent=function(){};var encodeURI=function(){};var encodeURIComponent=function(){};var escape=function(){};var unescape=function(){};var quit=function(){};var exit=function(){};var print=function(){};var echo = function(){};var readFully=function(){};var readLine=function(){};var load=function(){};var loadWithNewGlobal=function(){};\n";
    private HashMap<String, IDirective> instanceDirectives = new HashMap();
    public final SourceCollection sources = new SourceCollection();
    private int currentLine;
    private ArrayList<Line> lines;
    private Segment currentSegment;
    private ListingMode currentListing;
    private int[] startOffset;
    private int[] origins;
    private boolean[] overlap;
    private HashMap<Integer, Integer>[] constants;
    private BitSet[] constantRanges;
    private CompilerBindings compilerBindings = new CompilerBindings(64);
    private CompilerContext scriptContext;
    private NashornScriptEngine scriptEngine;
    private ArrayList<ConditionalState> compilationEnabled = new ArrayList();
    private HashMap<String, ArrayList<Line>> macros;
    private LinkedHashSet<String> editingMacros;
    private TreeMap<Integer, String> madeFile;

    public ProgramCompiler() {
        this.reset();
    }

    private void reset() {
        int i;
        this.lines = null;
        this.sources.clear();
        this.currentLine = 0;
        this.currentSegment = Segment.CSEG;
        this.currentListing = ListingMode.LIST;
        this.startOffset = new int[Segment.count()];
        this.origins = new int[Segment.count()];
        this.overlap = new boolean[Segment.count()];
        this.constants = new HashMap[Segment.count()];
        for (i = 0; i < this.constants.length; ++i) {
            this.constants[i] = new HashMap();
        }
        this.constantRanges = new BitSet[Segment.count()];
        for (i = 0; i < this.constantRanges.length; ++i) {
            this.constantRanges[i] = new BitSet(4096);
        }
        SimpleBindings globalBindings = new SimpleBindings();
        this.scriptContext = new CompilerContext(this.compilerBindings, globalBindings);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ccl = ccl == null ? NashornScriptEngineFactory.class.getClassLoader() : ccl;
        this.scriptEngine = (NashornScriptEngine)new NashornScriptEngineFactory().getScriptEngine(new String[]{"--no-java"}, ccl, s -> false);
        this.scriptEngine.setContext((ScriptContext)this.scriptContext);
        this.resetConditionalState();
        this.macros = new HashMap();
        this.editingMacros = new LinkedHashSet();
        this.madeFile = null;
    }

    public CompilerBindings getCompilerBindings() {
        return this.compilerBindings;
    }

    public void setCompilerBindings(CompilerBindings compilerBindings) {
        if (compilerBindings == null) {
            this.compilerBindings = new CompilerBindings(64);
            return;
        }
        this.compilerBindings = compilerBindings;
    }

    private void softReset() throws CompilerException {
        Segment[] segments;
        this.resetConditionalState();
        this.setCurrentListing(ListingMode.LIST);
        this.setCurrentSegment(Segment.CSEG);
        for (Segment segment : segments = Segment.values()) {
            this.setOrigin(0, segment);
            this.setOverlap(false, segment);
        }
        this.compilerBindings.removeAllBindings(Binding.NameType.DEF);
    }

    /*
     * Unable to fully structure code
     */
    public void compile(String includeName) throws Exception {
        this.reset();
        this.lines = this.sources.projectRootInclude(includeName, this.isListing());
        if (this.lines == null) {
            throw new CompilerException("Cannot compile null program!");
        }
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("INTERUPTED!");
            }
            didSomething = false;
            this.softReset();
            this.currentLine = 0;
            while (this.currentLine < this.lines.size()) {
                lineObj = this.lines.get(this.currentLine);
                if (!lineObj.isProcessed()) {
                    lineObj.setEnabled(this.isCompilationEnabled());
                    if (lineObj.getDirectiveName() != null) {
                        directive = this.getDirective(lineObj);
                        didSomething = this.processDirectiveInternal(didSomething, lineObj, directive);
                    } else if (lineObj.getMnemonic() != null) {
                        if (this.currentSegment != Segment.CSEG) {
                            throw new CompilerException("Invalid mnemonic use! " + lineObj.getLine());
                        }
                        if (lineObj.isEnabled() && this.isEditingMacros()) {
                            this.addToMacros(lineObj);
                            lineObj.setEnabled(false);
                        }
                        lineObj.setProcessed(true);
                        didSomething = true;
                    } else {
                        lineObj.setProcessed(true);
                        didSomething = true;
                    }
                } else if (lineObj.getDirectiveName() != null && (directive = this.getDirective(lineObj)) != null) {
                    directive.offsetOriginIfProcessed(this, lineObj);
                }
                ++this.currentLine;
            }
        } while (didSomething);
        if (this.isEditingMacros()) {
            throw new CompilerException("Is still trying to edit macros! " + Arrays.toString(this.editingMacros.toArray(new String[0])));
        }
        this.compilerBindings.removeAllBindings(new Binding.NameType[]{Binding.NameType.SET});
        this.softReset();
        this.currentLine = 0;
        while (this.currentLine < this.lines.size()) {
            block46: {
                block44: {
                    block47: {
                        block45: {
                            lineObj = this.lines.get(this.currentLine);
                            if (lineObj.getDirectiveName() == null) break block44;
                            directive = this.getDirective(lineObj);
                            if (directive != null) break block45;
                            lineObj.setProcessed(true);
                            break block46;
                        }
                        if (!lineObj.isProcessed()) break block47;
                        directive.offsetOriginIfProcessed(this, lineObj);
                        break block46;
                    }
                    if (!directive.onlyFirstPass()) ** GOTO lbl60
                    if (directive.isRepeatable()) {
                        lineObj.setProcessed(true);
                        directive.offsetOriginIfProcessed(this, lineObj);
                    } else {
                        throw new CompilerException("Cannot process in first pass! " + lineObj.getLine());
lbl60:
                        // 1 sources

                        try {
                            if (lineObj.getEvaluatedArguments() == null) {
                                lineObj.setArguments(lineObj.getLatestArguments().replaceAll("\\$", "(" + (this.getOrigin(Segment.CSEG) + this.getSegmentOffset(Segment.CSEG)) + ')').replaceAll("([a-zA-Z][0-9a-zA-Z_]*)#", "($1-" + (this.getOrigin(Segment.CSEG) + this.getSegmentOffset(Segment.CSEG)) + ')'));
                            }
                            if (lineObj.getLatestArguments().contains("#")) {
                                throw new CompilerException("Unable to replace with PC difference! " + lineObj.getLine());
                            }
                            directive.process(this, lineObj);
                            if (directive.isRepeatable()) ** GOTO lbl89
                            lineObj.setProcessed(true);
                        }
                        catch (EvaluationException e) {
                            if (!directive.cannotFail()) ** GOTO lbl89
                            throw new EvaluationException("Directive failed! " + lineObj.getLine(), e);
                        }
                    }
                }
                if (lineObj.isEnabled() && lineObj.getMnemonic() != null) {
                    if (this.currentSegment != Segment.CSEG) {
                        throw new CompilerException("Invalid mnemonic use! " + lineObj.getLine());
                    }
                    lineObj.setProcessed(false);
                    lineObj.setArguments(lineObj.getLatestArguments().replaceAll("\\$", "(" + (this.getOrigin(Segment.CSEG) + this.getSegmentOffset(Segment.CSEG)) + ')').replaceAll("([a-zA-Z][0-9a-zA-Z_]*)#", "($1-" + (this.getOrigin(Segment.CSEG) + this.getSegmentOffset(Segment.CSEG)) + ')'));
                    if (lineObj.getLatestArguments().contains("#")) {
                        throw new CompilerException("Unable to replace with PC difference! " + lineObj.getLine());
                    }
                    this.putProgramLabels();
                    if (this.isMacroDefined(lineObj.getMnemonic())) {
                        lineObj.setListing(this.isMacroListing() == false && this.isListing() != false);
                        this.injectMacro(lineObj.getMnemonic(), lineObj.getLatestArgumentArray());
                        lineObj.setProcessed(true);
                        lineObj.setEnabled(false);
                    } else {
                        lineObj.setListing(this.isListing());
                        this.offsetCurrentOrigin(1);
                    }
                }
            }
            ++this.currentLine;
        }
        made = new HashMap<Integer, String>();
        this.compilerBindings.removeAllBindings(new Binding.NameType[]{Binding.NameType.SET});
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("INTERUPTED!");
            }
            didSomething = false;
            this.softReset();
            this.currentLine = 0;
            while (this.currentLine < this.lines.size()) {
                lineObj = this.lines.get(this.currentLine);
                if (!lineObj.isProcessed()) {
                    if (lineObj.getDirectiveName() != null) {
                        directive = this.getDirective(lineObj);
                        didSomething = this.processDirectiveInternal(didSomething, lineObj, directive);
                    } else if (lineObj.getMnemonic() != null && lineObj.isEnabled()) {
                        if (this.currentSegment != Segment.CSEG) {
                            throw new CompilerException("Invalid mnemonic use! " + lineObj.getLine());
                        }
                        expressions = lineObj.getLatestArgumentArray();
                        sb = new StringBuilder(lineObj.getMnemonic()).append(' ');
                        try {
                            for (String expression : expressions) {
                                sb.append(this.computeString(expression)).append('`');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        catch (EvaluationException e) {
                            throw new EvaluationException("Mnemonic failed! " + lineObj.getLine(), e);
                        }
                        made.put(this.getCurrentOrigin(), sb.toString());
                        this.putCodeLine();
                        lineObj.setProcessed(true);
                        didSomething = true;
                    }
                } else if (lineObj.getDirectiveName() != null) {
                    directive = this.getDirective(lineObj);
                    if (directive != null) {
                        directive.offsetOriginIfProcessed(this, lineObj);
                    }
                } else if (lineObj.getMnemonic() != null && lineObj.isEnabled()) {
                    if (this.currentSegment != Segment.CSEG) {
                        throw new CompilerException("Invalid mnemonic use! " + lineObj.getLine());
                    }
                    this.offsetCurrentOrigin(1);
                }
                ++this.currentLine;
            }
        } while (didSomething);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("INTERUPTED!");
        }
        this.madeFile = new TreeMap<K, V>(made);
    }

    private boolean processDirectiveInternal(boolean didSomething, Line lineObj, IDirective directive) throws CompilerException {
        block5: {
            if (directive == null) {
                lineObj.setProcessed(true);
                didSomething = true;
            } else {
                try {
                    directive.process(this, lineObj);
                    if (!directive.isRepeatable()) {
                        lineObj.setProcessed(true);
                        didSomething = true;
                    }
                }
                catch (EvaluationException e) {
                    if (!directive.cannotFail()) break block5;
                    throw new EvaluationException("Directive failed! " + lineObj.getLine(), e);
                }
            }
        }
        return didSomething;
    }

    public TreeMap<Integer, String> getMadeFile() {
        return this.madeFile;
    }

    public ArrayList<String> getProgram() {
        ArrayList<String> cseg = new ArrayList<String>(this.madeFile.size());
        int len = this.madeFile.size();
        for (int i = 0; i < len; ++i) {
            cseg.add("");
        }
        for (Map.Entry<Integer, String> entry : this.madeFile.entrySet()) {
            cseg.set(entry.getKey(), entry.getValue());
        }
        return cseg;
    }

    public ArrayList<String> getDataCSEG() {
        ArrayList<String> cseg = new ArrayList<String>(this.getMemorySize(Segment.CSEG));
        int len = this.getMemorySize(Segment.CSEG);
        for (int i = 0; i < len; ++i) {
            cseg.add("");
        }
        for (Map.Entry<Integer, Integer> entry : this.constants[Segment.CSEG.ordinal()].entrySet()) {
            cseg.set(entry.getKey(), entry.getValue().toString());
        }
        return cseg;
    }

    public ArrayList<String> getDataDSEG() {
        ArrayList<String> dseg = new ArrayList<String>(this.getMemorySize(Segment.DSEG));
        int len = this.getMemorySize(Segment.DSEG);
        for (int i = 0; i < len; ++i) {
            dseg.add("");
        }
        for (Map.Entry<Integer, Integer> entry : this.constants[Segment.ESEG.ordinal()].entrySet()) {
            dseg.set(entry.getKey(), entry.getValue().toString());
        }
        return dseg;
    }

    public ArrayList<String> getDataESEG() {
        ArrayList<String> eseg = new ArrayList<String>(this.getMemorySize(Segment.ESEG));
        int len = this.getMemorySize(Segment.ESEG);
        for (int i = 0; i < len; ++i) {
            eseg.add("");
        }
        for (Map.Entry<Integer, Integer> entry : this.constants[Segment.ESEG.ordinal()].entrySet()) {
            eseg.set(entry.getKey(), entry.getValue().toString());
        }
        return eseg;
    }

    public void include(String includeName) throws CompilerException {
        if (includeName == null) {
            throw new InvalidInclude("Cannot include null!");
        }
        Line line = this.lines.get(this.currentLine);
        this.lines.addAll(this.currentLine + 1, this.sources.getInclude(line.getIncludePath(), line.getIncludeName(), includeName, this.currentLine, this.isListing()));
    }

    public void exitCurrentFile() {
        Line l = this.lines.get(this.currentLine);
        String file = l.getIncludePath();
        int size = this.lines.size();
        for (int i = this.currentLine + 1; i < size && (l = this.lines.get(this.currentLine)).getIncludePath().startsWith(file); ++i) {
            l.setProcessed(true);
        }
    }

    public void setCurrentSegment(Segment currentSegment) throws InvalidMemorySegment {
        if (currentSegment == null) {
            throw new InvalidMemorySegment("Segment cannot be null!");
        }
        this.currentSegment = currentSegment;
    }

    public Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public int getCurrentSegmentOffset() {
        return this.startOffset[this.currentSegment.ordinal()];
    }

    public int getSegmentOffset(Segment segment) {
        return this.startOffset[segment.ordinal()];
    }

    public void setSegmentOffset(Segment segment, int offset) throws InvalidStartOffset {
        if (offset < 0) {
            throw new InvalidStartOffset("Start offset must be not negative! " + offset);
        }
        this.startOffset[segment.ordinal()] = offset;
    }

    public void setCurrentOverlap(boolean value) {
        this.overlap[this.currentSegment.ordinal()] = value;
    }

    public void setOverlap(boolean value, Segment segment) {
        this.overlap[segment.ordinal()] = value;
    }

    public boolean getCurrentOverlap() {
        return this.overlap[this.currentSegment.ordinal()];
    }

    public boolean getOverlap(Segment segment) {
        return this.overlap[segment.ordinal()];
    }

    public void offsetCurrentOrigin(int value) throws InvalidOrigin {
        if (this.origins[this.currentSegment.ordinal()] + value < 0) {
            throw new InvalidOrigin("Origin must be not negative! " + this.origins[this.currentSegment.ordinal()] + "+" + value);
        }
        int n = this.currentSegment.ordinal();
        this.origins[n] = this.origins[n] + value;
    }

    public void setCurrentOrigin(int value) throws InvalidOrigin {
        if (value < 0) {
            throw new InvalidOrigin("Origin must be not negative! " + value);
        }
        this.origins[this.currentSegment.ordinal()] = value;
    }

    public void setOrigin(int value, Segment segment) throws InvalidOrigin {
        if (value < 0) {
            throw new InvalidOrigin("Origin must be not negative! " + value);
        }
        this.origins[segment.ordinal()] = value;
    }

    public int getCurrentOrigin() {
        return this.origins[this.currentSegment.ordinal()];
    }

    public int getOrigin(Segment segment) {
        return this.origins[segment.ordinal()];
    }

    public int getCurrentMemorySize() {
        return this.constantRanges[this.currentSegment.ordinal()].length();
    }

    public int getMemorySize(Segment segment) {
        return this.constantRanges[segment.ordinal()].length();
    }

    public boolean isCurrentMemoryCellFree() {
        return !this.constantRanges[this.currentSegment.ordinal()].get(this.getCurrentOrigin());
    }

    public boolean isCurrentMemoryCellFree(int address) throws InvalidMemoryAccess {
        if (address < 0) {
            throw new InvalidMemoryAccess("Memory address must be not negative! " + address);
        }
        return !this.constantRanges[this.currentSegment.ordinal()].get(address);
    }

    public boolean isMemoryCellFree(Segment segment, int address) throws InvalidMemoryAccess {
        if (address < 0) {
            throw new InvalidMemoryAccess("Memory address must be not negative! " + address);
        }
        return !this.constantRanges[segment.ordinal()].get(address);
    }

    public boolean isCurrentMemoryRangeFree(int toExclusive) throws InvalidMemoryAccess {
        if (this.getCurrentOrigin() >= toExclusive) {
            throw new InvalidMemoryAccess("Range end must be greater than origin! " + this.getCurrentOrigin() + " !< " + toExclusive);
        }
        return this.constantRanges[this.currentSegment.ordinal()].nextClearBit(this.getCurrentOrigin()) >= toExclusive;
    }

    public boolean isCurrentMemoryRangeFree(int fromInclusive, int toExclusive) throws InvalidMemoryAccess {
        if (fromInclusive < 0) {
            throw new InvalidMemoryAccess("Range start must be not negative! " + fromInclusive);
        }
        if (fromInclusive >= toExclusive) {
            throw new InvalidMemoryAccess("Range end must be greater than range start! " + fromInclusive + " !< " + toExclusive);
        }
        return this.constantRanges[this.currentSegment.ordinal()].nextClearBit(fromInclusive) >= toExclusive;
    }

    public boolean isMemoryRangeFree(Segment segment, int fromInclusive, int toExclusive) throws InvalidMemoryAccess {
        if (fromInclusive < 0) {
            throw new InvalidMemoryAccess("Range start must be not negative! " + fromInclusive);
        }
        if (fromInclusive >= toExclusive) {
            throw new InvalidMemoryAccess("Range end must be greater than range start! " + fromInclusive + " !< " + toExclusive);
        }
        return this.constantRanges[segment.ordinal()].nextClearBit(fromInclusive) >= toExclusive;
    }

    public boolean isCurrentMemoryBlockFree(int size) throws InvalidMemoryAccess {
        if (size <= 0) {
            throw new InvalidMemoryAccess("Block size must be positive! " + size);
        }
        int offset = this.getCurrentOrigin();
        return this.constantRanges[this.currentSegment.ordinal()].nextClearBit(offset) >= offset + size;
    }

    public boolean isCurrentMemoryBlockFree(int start, int size) throws InvalidMemoryAccess {
        if (start < 0) {
            throw new InvalidMemoryAccess("Block start must be not negative! " + start);
        }
        if (size <= 0) {
            throw new InvalidMemoryAccess("Block size must be positive! " + size);
        }
        return this.constantRanges[this.currentSegment.ordinal()].nextClearBit(start) >= start + size;
    }

    public boolean isMemoryBlockFree(Segment segment, int start, int size) throws InvalidMemoryAccess {
        if (start < 0) {
            throw new InvalidMemoryAccess("Block start must be not negative! " + start);
        }
        if (size <= 0) {
            throw new InvalidMemoryAccess("Block size must be positive! " + size);
        }
        return this.constantRanges[segment.ordinal()].nextClearBit(start) >= start + size;
    }

    public void putConstant(int constant) throws InvalidOrigin, InvalidMemoryAllocation, InvalidBinding {
        int origin;
        int segment;
        if (!this.currentSegment.isAllowingConstants()) {
            throw new InvalidMemoryAllocation("Cannot store constants in volatile memory! " + constant);
        }
        if (this.getCurrentOverlap() || this.isCurrentMemoryCellFree()) {
            segment = this.currentSegment.ordinal();
            origin = this.getCurrentOrigin();
            int offset = this.getCurrentSegmentOffset();
            for (String s : this.getLabelsOrPointersNames()) {
                this.putBinding(s, new Binding(Binding.NameType.POINTER, offset + origin));
            }
        } else {
            throw new InvalidMemoryAllocation("Memory overlaps! " + this.currentSegment.name() + " " + this.getCurrentOrigin());
        }
        this.constantRanges[segment].set(origin);
        this.constants[segment].put(origin, constant);
        this.offsetCurrentOrigin(1);
    }

    public void putConstant(float constant) throws InvalidOrigin, InvalidMemoryAllocation, InvalidBinding {
        int origin;
        if (!this.currentSegment.isAllowingConstants()) {
            throw new InvalidMemoryAllocation("Cannot store constants in volatile memory! " + constant);
        }
        int segment = this.currentSegment.ordinal();
        if (this.getCurrentOverlap() || this.isCurrentMemoryCellFree()) {
            origin = this.getCurrentOrigin();
            int offset = this.getCurrentSegmentOffset();
            for (String s : this.getLabelsOrPointersNames()) {
                this.putBinding(s, new Binding(Binding.NameType.POINTER, offset + origin));
            }
        } else {
            throw new InvalidMemoryAllocation("Memory overlaps! " + this.currentSegment.name() + " " + this.getCurrentOrigin());
        }
        this.constantRanges[segment].set(origin);
        this.constants[segment].put(origin, Float.floatToIntBits(constant));
        this.offsetCurrentOrigin(1);
    }

    public void putConstant(long constant) throws InvalidOrigin, InvalidMemoryAccess, InvalidMemoryAllocation, InvalidBinding {
        int origin;
        int segment;
        if (!this.currentSegment.isAllowingConstants()) {
            throw new InvalidMemoryAllocation("Cannot store constants in volatile memory! " + constant);
        }
        if (this.getCurrentOverlap() || this.isCurrentMemoryBlockFree(2)) {
            segment = this.currentSegment.ordinal();
            origin = this.getCurrentOrigin();
            int offset = this.getCurrentSegmentOffset();
            for (String s : this.getLabelsOrPointersNames()) {
                this.putBinding(s, new Binding(Binding.NameType.POINTER, offset + origin));
            }
        } else {
            throw new InvalidMemoryAllocation("Memory overlaps! " + this.currentSegment.name() + " " + this.getCurrentOrigin());
        }
        this.constantRanges[segment].set(origin, origin + 2);
        this.constants[segment].put(origin, (int)constant);
        this.constants[segment].put(origin + 1, (int)(constant >> 32));
        this.offsetCurrentOrigin(2);
    }

    public void putConstant(String constant) throws InvalidOrigin, InvalidMemoryAccess, InvalidMemoryAllocation, InvalidConstant, InvalidBinding {
        if (!this.currentSegment.isAllowingConstants()) {
            throw new InvalidMemoryAllocation("Cannot store constants in volatile memory! " + constant);
        }
        if (constant == null) {
            throw new InvalidConstant("String constant cannot be null!");
        }
        if (constant.length() == 0) {
            throw new InvalidConstant("String constant must not be empty!");
        }
        int length = constant.length();
        if (this.getCurrentOverlap() || this.isCurrentMemoryBlockFree(length)) {
            int segment = this.currentSegment.ordinal();
            int origin = this.getCurrentOrigin();
            int offset = this.getCurrentSegmentOffset();
            for (String s : this.getLabelsOrPointersNames()) {
                this.putBinding(s, new Binding(Binding.NameType.POINTER, offset + origin));
            }
            this.constantRanges[segment].set(origin, origin + length);
            for (int i = 0; i < constant.length(); ++i) {
                this.constants[segment].put(origin + i, Integer.valueOf(constant.charAt(i)));
            }
        } else {
            throw new InvalidMemoryAllocation("Memory overlaps! " + this.currentSegment.name() + " " + this.getCurrentOrigin());
        }
        this.offsetCurrentOrigin(length);
    }

    public void reserveMemory(int cellCount) throws InvalidOrigin, InvalidMemoryAccess, InvalidMemoryAllocation, InvalidBinding {
        if (!this.currentSegment.isAllowingVariables()) {
            throw new InvalidMemoryAllocation("Cannot store variables in program memory! " + cellCount);
        }
        if (cellCount <= 0) {
            throw new InvalidMemoryAllocation("Memory block size must have positive size! " + cellCount);
        }
        if (this.getCurrentOverlap() || this.isCurrentMemoryBlockFree(cellCount)) {
            int segment = this.currentSegment.ordinal();
            int origin = this.getCurrentOrigin();
            int offset = this.getCurrentSegmentOffset();
            for (String s : this.getLabelsOrPointersNames()) {
                this.putBinding(s, new Binding(Binding.NameType.POINTER, offset + origin));
            }
            this.constantRanges[segment].set(origin, origin + cellCount);
            for (int i = 0; i < cellCount; ++i) {
                this.constants[segment].put(origin + i, 0);
            }
            this.offsetCurrentOrigin(cellCount);
        }
        throw new InvalidMemoryAllocation("Cannot store variables in program memory! " + cellCount);
    }

    public void putBinding(String name, Binding binding) throws InvalidBinding {
        if (binding == null) {
            throw new InvalidBinding("Invalid binding specified! " + name);
        }
        if (name == null || name.length() == 0 || !name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) {
            throw new InvalidBinding("Invalid binding name specified! " + name);
        }
        Binding old = this.compilerBindings.getBinding(name);
        if (old != null) {
            switch (old.type) {
                case SET: 
                case DEF: {
                    break;
                }
                default: {
                    throw new InvalidBinding("Cannot rewrite that binding! " + old.type.name() + " " + name);
                }
            }
        }
        this.compilerBindings.putBinding(name, binding);
    }

    public void putCodeLine() throws InvalidMemoryAllocation, InvalidOrigin {
        if (this.currentSegment != Segment.CSEG) {
            throw new InvalidMemoryAllocation("Cannot store program outside program memory!");
        }
        if (!this.getCurrentOverlap() && !this.isCurrentMemoryCellFree()) {
            throw new InvalidMemoryAllocation("Memory overlaps! " + this.currentSegment.name() + " " + this.getCurrentOrigin());
        }
        int segment = this.currentSegment.ordinal();
        int origin = this.getCurrentOrigin();
        this.constantRanges[segment].set(origin);
        this.offsetCurrentOrigin(1);
    }

    public void putProgramLabels() throws InvalidMemoryAllocation, InvalidBinding {
        if (this.currentSegment != Segment.CSEG) {
            throw new InvalidMemoryAllocation("Cannot define program labels outside program memory!");
        }
        for (String name : this.getLabelsOrPointersNames()) {
            this.putBinding(name, new Binding(Binding.NameType.LABEL, this.getCurrentOrigin() + this.getCurrentSegmentOffset()));
        }
    }

    public ArrayList<String> getLabelsOrPointersNames() {
        ArrayList<String> names = new ArrayList<String>();
        Line line = this.lines.get(this.currentLine);
        if (line.getLabelOrPointerName() != null) {
            names.add(line.getLabelOrPointerName());
        }
        for (int i = this.currentLine - 1; i >= 0; ++i) {
            line = this.lines.get(i);
            if (!line.isEnabled()) continue;
            if (line.getMnemonic() != null || line.getDirectiveName() != null) break;
            if (line.getLabelOrPointerName() == null) continue;
            names.add(line.getLabelOrPointerName());
        }
        return names;
    }

    public String computeString(String script) throws EvaluationException {
        try {
            Object value = this.scriptEngine.eval(SANDBOX + script);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Number || value instanceof Boolean) {
                return value.toString();
            }
            if (value == null) {
                this.writeError("Returned type: <NULL>");
                return "";
            }
            this.writeError("Returned type: " + value.getClass().getCanonicalName());
            return value.toString();
        }
        catch (ScriptException e) {
            throw new EvaluationException("Cannot evaluate! " + script, e);
        }
    }

    public Number computeNumber(String script) throws EvaluationException {
        try {
            Object value = this.scriptEngine.eval(SANDBOX + script);
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            if (value == null) {
                this.writeError("Returned type: <NULL>");
            } else {
                this.writeError("Returned type: " + value.getClass().getCanonicalName());
            }
            return 0;
        }
        catch (ScriptException e) {
            throw new EvaluationException("Cannot evaluate! " + script, e);
        }
    }

    public Boolean computeBoolean(String script) throws EvaluationException {
        try {
            Object value = this.scriptEngine.eval(SANDBOX + script);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            if (value == null) {
                this.writeError("Returned type: <NULL>");
            } else {
                this.writeError("Returned type: " + value.getClass().getCanonicalName());
            }
            return false;
        }
        catch (ScriptException e) {
            throw new EvaluationException("Cannot evaluate! " + script, e);
        }
    }

    public Object computeObject(String script) throws EvaluationException {
        try {
            Object value = this.scriptEngine.eval(SANDBOX + script);
            if (value instanceof Number || value instanceof Boolean || value instanceof String) {
                return value;
            }
            if (value == null) {
                this.writeError("Returned type: <NULL>");
            } else {
                this.writeError("Returned type: " + value.getClass().getCanonicalName());
            }
            return null;
        }
        catch (ScriptException e) {
            throw new EvaluationException("Cannot evaluate! " + script, e);
        }
    }

    public void writeError(String s) throws PrintingException {
        try {
            this.scriptContext.getErrorWriter().write(s + "\n");
        }
        catch (IOException e) {
            throw new PrintingException("Cannot print error! " + s, e);
        }
    }

    public void write(String s) throws PrintingException {
        try {
            this.scriptContext.getWriter().write(s + "\n");
        }
        catch (IOException e) {
            throw new PrintingException("Cannot print! " + s, e);
        }
    }

    public void removeBinding(String name) throws InvalidBinding {
        Binding old = this.compilerBindings.getBinding(name);
        if (old == null) {
            throw new InvalidBinding("Cannot remove binding name is unused! " + name);
        }
        switch (old.type) {
            case SET: 
            case DEF: {
                break;
            }
            default: {
                throw new InvalidBinding("Cannot remove that binding! " + old.type.name() + " " + name);
            }
        }
        this.compilerBindings.removeBinding(name);
    }

    public boolean containsNotDefs(String ... keys) throws InvalidBinding {
        for (String name : keys) {
            if (name != null && name.length() != 0 && name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) continue;
            throw new InvalidBinding("Invalid binding name specified! " + name);
        }
        return this.compilerBindings.containsNotDefinitions(keys);
    }

    public boolean lacksNotDefs(String ... keys) throws InvalidBinding {
        for (String name : keys) {
            if (name != null && name.length() != 0 && name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) continue;
            throw new InvalidBinding("Invalid binding name specified! " + name);
        }
        return this.compilerBindings.lacksNotDefinitions(keys);
    }

    public static Number parseNumberAdvanced(String str) {
        if ((str = str.replaceAll("_", "")).contains(".")) {
            return Double.parseDouble(str);
        }
        if (str.contains("0x") | str.contains("0X")) {
            str = str.replaceAll("0[xX]", "");
            return Integer.parseInt(str, 16);
        }
        if (str.contains("0b") | str.contains("0B")) {
            str = str.replaceAll("0[bB]", "");
            return Integer.parseInt(str, 2);
        }
        if (str.startsWith("-0") | str.startsWith("0")) {
            return Integer.parseInt(str, 8);
        }
        return Integer.parseInt(str, 10);
    }

    public void openIf(boolean compilationEnable) {
        if (this.compilationEnabled.size() > 1 && this.compilationEnabled.get(this.compilationEnabled.size() - 1) != ConditionalState.ASSEMBLING) {
            this.compilationEnabled.add(ConditionalState.DISABLED);
            return;
        }
        this.compilationEnabled.add(compilationEnable ? ConditionalState.ASSEMBLING : ConditionalState.CHECKING);
    }

    public void elseIf(boolean compilationEnable) throws InvalidConditionalAssembly, InvalidConditionalEvaluation {
        if (this.compilationEnabled.size() <= 1) {
            throw new InvalidConditionalAssembly("Missing if opening statement!");
        }
        ConditionalState b = this.compilationEnabled.get(this.compilationEnabled.size() - 1);
        if (b == ConditionalState.CHECKING) {
            this.compilationEnabled.set(this.compilationEnabled.size() - 1, compilationEnable ? ConditionalState.ASSEMBLING : ConditionalState.CHECKING);
        } else if (b == ConditionalState.ASSEMBLING) {
            this.compilationEnabled.set(this.compilationEnabled.size() - 1, ConditionalState.DISABLED);
        } else {
            throw new InvalidConditionalEvaluation("Not ready to evaluate!");
        }
    }

    public void endIf() throws InvalidConditionalAssembly {
        if (this.compilationEnabled.size() <= 1) {
            throw new InvalidConditionalAssembly("Missing if opening statement!");
        }
        this.compilationEnabled.remove(this.compilationEnabled.size() - 1);
    }

    public boolean isCompilationEnabled() {
        return this.compilationEnabled.get(this.compilationEnabled.size() - 1) == ConditionalState.ASSEMBLING;
    }

    public void setConditionalState(ConditionalState state) {
        this.compilationEnabled.set(this.compilationEnabled.size() - 1, state);
    }

    public int getDepth() {
        return this.compilationEnabled.size();
    }

    public void resetConditionalState() {
        this.compilationEnabled.clear();
        this.compilationEnabled.add(ConditionalState.ASSEMBLING);
    }

    public void addMacro(String name) throws InvalidMacroStatement {
        if (name == null || name.length() == 0 || !name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) {
            throw new InvalidMacroStatement("Invalid macro name specified! " + name);
        }
        this.macros.put(name, new ArrayList());
        this.editingMacros.add(name);
    }

    private void addToMacros(Line line) throws InvalidMacroStatement {
        if (line == null) {
            throw new InvalidMacroStatement("Invalid macro line specified!");
        }
        if (this.editingMacros.isEmpty()) {
            throw new InvalidMacroStatement("Is not editing any macros!");
        }
        this.editingMacros.forEach(s -> this.macros.get(s).add(line));
    }

    public void finishMacro(String name) throws InvalidMacroStatement {
        if (name == null || name.length() == 0) {
            if (this.editingMacros.isEmpty()) {
                throw new InvalidMacroStatement("Is not editing any macros!");
            }
            String[] list = this.editingMacros.toArray(new String[0]);
            this.editingMacros.remove(list[list.length - 1]);
        }
        if (!this.editingMacros.remove(name)) {
            throw new InvalidMacroStatement("Macro is not being edited! " + name);
        }
    }

    public boolean isEditingMacros() {
        return this.editingMacros.size() > 0;
    }

    private void injectMacro(String macroName, String[] lastestArguments) throws CompilerException {
        ArrayList<Line> macro = this.macros.get(macroName);
        if (macro == null) {
            throw new InvalidMacroStatement("Macro was never defined! " + macroName);
        }
        for (int i = 0; i < lastestArguments.length; ++i) {
            lastestArguments[i] = '(' + lastestArguments[i] + ')';
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Line s : macro) {
            String label = s.getLabelOrPointerName();
            if (label == null) continue;
            labels.add(label);
        }
        ArrayList<Line> newLines = new ArrayList<Line>(macro.size());
        for (Line s : macro) {
            String temp = s.getLine();
            for (int i = lastestArguments.length - 1; i >= 0; --i) {
                temp = temp.replaceAll("@" + i + "(?:[^0-9].*)?", lastestArguments[i]);
            }
            if (temp.contains("@")) {
                throw new InvalidMacroStatement("Cannot resolve all parameters! " + s + " " + this.currentLine);
            }
            for (String l : labels) {
                temp = temp.replaceAll("(?:.*[^0-9a-zA-Z_])?" + l + "(?:" + "[^0-9a-zA-Z_]" + ".*)?", l + "___MACRO___" + this.currentLine);
            }
            newLines.add(new Line(s.getIncludePath(), s.getIncludeName() + macroName + '\u001e' + this.currentLine + '\u001d', s.getLineNumber(), temp, this.isMacroListing()));
        }
        this.lines.addAll(this.currentLine + 1, newLines);
        this.offsetCurrentOrigin(newLines.size());
    }

    public boolean isMacroDefined(String name) {
        return this.macros.containsKey(name) && !this.editingMacros.contains(name);
    }

    public void setCurrentListing(ListingMode mode) throws InvalidListingMode {
        if (mode == null) {
            throw new InvalidListingMode("Listing mode cannot be null!");
        }
        this.currentListing = mode;
    }

    public ListingMode getCurrentListingMode() {
        return this.currentListing;
    }

    public boolean isListing() {
        return this.currentListing != ListingMode.NO_LIST;
    }

    public boolean isMacroListing() {
        return this.currentListing == ListingMode.LIST_MACRO;
    }

    public IDirective putDirective(String name, IDirective directive) throws InvalidDirective {
        if (name == null || name.length() == 0 || !name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) {
            throw new InvalidDirective("Invalid directive name specified! " + name);
        }
        return this.instanceDirectives.put(name, directive);
    }

    public IDirective getDirective(Line line) throws InvalidDirective {
        String name = line.getDirectiveName();
        if (name == null || name.length() == 0 || !name.matches("([a-zA-Z][0-9a-zA-Z_]*)")) {
            throw new InvalidDirective("Invalid directive name specified! " + name);
        }
        IDirective directive = this.instanceDirectives.get(name);
        if (directive != null) {
            if (line.isEnabled() || directive.isUnskippable()) {
                return directive;
            }
            return null;
        }
        directive = (IDirective)Directive.GLOBAL_DIRECTIVES.get(name);
        if (directive != null) {
            if (line.isEnabled() || directive.isUnskippable()) {
                return directive;
            }
            return null;
        }
        directive = (IDirective)Directive.GLOBAL_DIRECTIVES.get(name.toUpperCase());
        if (directive != null) {
            if (line.isEnabled() || directive.isUnskippable()) {
                return directive;
            }
            return null;
        }
        if (line.isEnabled()) {
            throw new InvalidDirective("Directive is not defined! " + name);
        }
        return null;
    }

    static {
        Directive.makeDirectives();
    }
}

