/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.render;

import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;

public class TileEntityLaser
extends TileEntity {
    public boolean shouldRender = false;
    public float red = 0.0f;
    public float green = 0.0f;
    public float blue = 0.0f;
    public float counter = 0.0f;
    public boolean realism = false;
    public double rotAxisX = 0.0;
    public double rotAxisY = 0.0;
    public double rotAxisZ = 0.0;
    public double rotationAngle = 0.0;

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a("rgb_red", this.red);
        compound.func_74776_a("rgb_green", this.green);
        compound.func_74776_a("rgb_blue", this.blue);
        compound.func_74757_a("shouldRender", this.shouldRender);
        compound.func_74780_a("rotAxisX", this.rotAxisX);
        compound.func_74780_a("rotAxisY", this.rotAxisY);
        compound.func_74780_a("rotAxisZ", this.rotAxisZ);
        compound.func_74780_a("rotationAngle", this.rotationAngle);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.red = compound.func_74760_g("rgb_red");
        this.blue = compound.func_74760_g("rgb_blue");
        this.green = compound.func_74760_g("rgb_green");
        this.shouldRender = compound.func_74767_n("shouldRender");
        this.rotAxisX = compound.func_74769_h("rotAxisX");
        this.rotAxisY = compound.func_74769_h("rotAxisY");
        this.rotAxisZ = compound.func_74769_h("rotAxisZ");
        this.rotationAngle = compound.func_74769_h("rotationAngle");
    }

    public void setColors(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setRotationFields(ForgeDirection direction, Rotation rotation, Flip flip) {
        float f;
        float f2;
        Matrix4f rotationMatrix = new Matrix4f().identity();
        switch (rotation) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NORMAL: {
                f2 = 0.0f;
                break;
            }
            case CLOCKWISE: {
                f2 = 90.0f;
                break;
            }
            case COUNTER_CLOCKWISE: {
                f2 = -90.0f;
                break;
            }
            case UPSIDE_DOWN: {
                f2 = 180.0f;
            }
        }
        float localAngle = f2;
        localAngle *= flip == Flip.HORIZONTAL || flip == Flip.VERTICAL ? 1.0f : -1.0f;
        localAngle = (float)Math.toRadians(localAngle);
        rotationMatrix.rotate(localAngle, (float)direction.offsetX, (float)direction.offsetY, (float)direction.offsetZ);
        float x = 0.0f;
        float y = 0.0f;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                x = 1.0f;
                f = -90.0f;
                break;
            }
            case UP: {
                x = 1.0f;
                f = -90.0f;
                break;
            }
            case EAST: 
            case SOUTH: {
                y = 1.0f;
                f = 90.0f;
                break;
            }
            case WEST: 
            case NORTH: {
                y = 1.0f;
                f = -90.0f;
                break;
            }
            case UNKNOWN: {
                f = 0.0f;
            }
        }
        float angle = f;
        angle = (float)Math.toRadians(angle);
        rotationMatrix.rotate(angle, x, y, 0.0f);
        AxisAngle4f rotationVector = new AxisAngle4f();
        rotationMatrix.getRotation(rotationVector);
        this.rotationAngle = rotationVector.angle / (float)Math.PI * 180.0f;
        this.rotAxisX = rotationVector.x;
        this.rotAxisY = rotationVector.y;
        this.rotAxisZ = rotationVector.z;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Boolean getShouldRender() {
        return this.shouldRender;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public double func_145833_n() {
        return 4096.0;
    }
}

