/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.purification.MTEHatchLensHousing;
import gregtech.common.tileentities.machines.multi.purification.MTEHatchLensIndicator;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import gregtech.common.tileentities.machines.multi.purification.UVTreatmentLensCycle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEPurificationUnitUVTreatment
extends MTEPurificationUnitBase<MTEPurificationUnitUVTreatment>
implements ISurvivalConstructable {
    private static final int CASING_INDEX_MAIN = MTEPurificationUnitUVTreatment.getTextureIndex(GregTechAPI.sBlockCasings9, 12);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int STRUCTURE_X_OFFSET = 6;
    private static final int STRUCTURE_Y_OFFSET = 8;
    private static final int STRUCTURE_Z_OFFSET = 0;
    private MTEHatchLensHousing lensInputBus;
    private MTEHatchLensIndicator lensIndicator;
    private UVTreatmentLensCycle lensCycle = null;
    public static final float SUCCESS_PER_LENS = 10.0f;
    public static final int MAX_TIME_BETWEEN_SWAPS = 300;
    public static final int MIN_TIME_BETWEEN_SWAPS = 75;
    public static final ArrayList<ItemStack> LENS_ITEMS = new ArrayList();
    private int numSwapsPerformed = 0;
    private int timeUntilNextSwap = 0;
    private boolean removedTooEarly = false;
    private static final String[][] structure = new String[][]{{"             ", "     DDD     ", "             ", "             ", "             ", "             ", "             ", "     DDD     ", "     H~H     "}, {"     AAA     ", "   DDAAADD   ", "     BBB     ", "     BBB     ", "     BBB     ", "     BBB     ", "     BBB     ", "   DDBBBDD   ", "   AAAAAAA   "}, {"   AAAAAAA   ", " DDAACCCAADD ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", " DDBB   BBDD ", " AAAAAAAAAAA "}, {" AAAAAAAAAAA ", "DAACCCCCCCAAD", " BB       BB ", " BB       BB ", " BB       BB ", " BB       BB ", " BB       BB ", "DBB       BBD", "HAAAAAAAAAAAH"}, {" AAAAALAAAAA ", "DACCCCCCCCCAD", " B         B ", " B         B ", " B         B ", " B         B ", " B         B ", "DB         BD", "HAAAAAAAAAAAH"}, {" AAAAAAAAAAA ", "DAACCCCCCCAAD", " BB       BB ", " BB       BB ", " BB       BB ", " BB       BB ", " BB       BB ", "DBB       BBD", "HAAAAAAAAAAAH"}, {"   AAAAAAA   ", " DDAACCCAADD ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", "   BB   BB   ", " DDBB   BBDD ", " AAAAAAAAAAA "}, {"     AIA     ", "   DDAAADD   ", "     BBB     ", "     BBB     ", "     BBB     ", "     BBB     ", "     BBB     ", "   DDBBBDD   ", "   AAAAAAA   "}, {"             ", "     DDD     ", "             ", "             ", "             ", "             ", "             ", "     DDD     ", "     HHH     "}};
    private static final IStructureDefinition<MTEPurificationUnitUVTreatment> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)12)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)1)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)13)).addElement('D', GTStructureUtility.ofFrame(Materials.StellarAlloy)).addElement('L', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(SpecialHatchElement.LensHousing).dot(2).cacheHint(() -> "Lens Housing").casingIndex(CASING_INDEX_MAIN).build())).addElement('I', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(SpecialHatchElement.LensIndicator).dot(3).cacheHint(() -> "Lens Indicator").casingIndex(CASING_INDEX_MAIN).build())).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(Arrays.asList(HatchElement.InputHatch, HatchElement.OutputHatch)).dot(1).cacheHint(() -> "Input Hatch, Output Hatch").casingIndex(CASING_INDEX_MAIN).build()), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)12)})).build();

    public MTEPurificationUnitUVTreatment(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitUVTreatment(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitUVTreatment(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 6, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 8, 0, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitUVTreatment> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit");
        tt.addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("During operation, swap the lens in the " + EnumChatFormatting.WHITE + "Lens Housing" + EnumChatFormatting.GRAY + ".").addInfo("The multiblock will output a signal through the " + EnumChatFormatting.WHITE + "Lens Indicator Hatch").addInfo("when the current lens must be swapped.").addInfo("Lens swaps will be requested in random intervals of " + EnumChatFormatting.RED + 3 + " to " + 15 + "s" + EnumChatFormatting.GRAY + ".").addSeparator().addInfo("Success chance is boosted by " + EnumChatFormatting.RED + 10.0f + "% " + EnumChatFormatting.GRAY + "for each successful swap performed.").addInfo("Removing a lens too early will fail the recipe.").addInfo("Find the order of lenses in the recipe in NEI,").addInfo("or use a portable scanner to view the currently requested lens.").addInfo("The recipe always starts at the Orundum Lens").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The sixth step of water purification involves identifying any remaining negatively charged ions within").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "the water which may cause electrical faults in future wafer manufacturing. Bombarding the water with varying").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "wavelengths of photon beams will impart energy into outer-shell electrons, causing them to detach from the").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "atoms themselves and pass through the walls of the tank, ensuring the water is perfectly electrically polar.").beginStructureBlock(13, 9, 9, true).addCasingInfoRangeColored("Naquadria-Reinforced Water Plant Casing", EnumChatFormatting.GRAY, 147, 155, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Electron-Permeable Neutronium Coated Glass", EnumChatFormatting.GRAY, 144, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("High Energy Ultraviolet Emitter Casing", EnumChatFormatting.GRAY, 24, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Stellar Alloy Frame Box", EnumChatFormatting.GRAY, 56, EnumChatFormatting.GOLD, false).addController("Front center").addOtherStructurePart("Input Hatch, Output Hatch", EnumChatFormatting.GOLD + "1+", 1).addOtherStructurePart("Lens Housing", EnumChatFormatting.GOLD + "1", 2).addOtherStructurePart("Lens Indicator", EnumChatFormatting.GOLD + "1", 3).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationUVTreatmentRecipes;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        CheckRecipeResult result = super.checkProcessing();
        if (result.wasSuccessful()) {
            this.lensCycle = new UVTreatmentLensCycle(LENS_ITEMS);
        }
        return result;
    }

    private int generateNextSwapTime() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return random.nextInt(75, 300);
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        this.timeUntilNextSwap = 0;
        this.numSwapsPerformed = 0;
        this.lensCycle.reset();
        this.removedTooEarly = false;
    }

    private ItemStack getCurrentlyInsertedLens() {
        return this.lensInputBus.func_70301_a(0);
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime <= 0) {
            return;
        }
        if (this.lensCycle == null) {
            return;
        }
        ItemStack currentLens = this.getCurrentlyInsertedLens();
        if (this.timeUntilNextSwap > 0) {
            boolean advanced;
            --this.timeUntilNextSwap;
            this.lensIndicator.updateRedstoneOutput(false);
            if (currentLens == null || !currentLens.func_77969_a(this.lensCycle.current())) {
                this.removedTooEarly = true;
            }
            if (this.timeUntilNextSwap == 0 && !(advanced = this.lensCycle.advance())) {
                this.timeUntilNextSwap = this.mMaxProgresstime + 1;
            }
        } else if (this.timeUntilNextSwap == 0) {
            this.lensIndicator.updateRedstoneOutput(true);
            if (currentLens != null && currentLens.func_77969_a(this.lensCycle.current())) {
                ++this.numSwapsPerformed;
                this.timeUntilNextSwap = this.generateNextSwapTime();
            }
        }
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getWaterTier() {
        return 6;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_UV;
    }

    @Override
    public float calculateFinalSuccessChance() {
        if (this.removedTooEarly) {
            return 0.0f;
        }
        return (float)this.numSwapsPerformed * 10.0f + this.currentRecipeChance;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> infoData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        if (this.lensCycle != null) {
            infoData.add("Lens swaps performed this run: " + EnumChatFormatting.YELLOW + this.numSwapsPerformed);
            infoData.add("Current lens requested: " + EnumChatFormatting.GREEN + this.lensCycle.current().func_82833_r());
            if (this.removedTooEarly) {
                infoData.add("Removed lens too early. Failing this recipe.");
            }
        }
        return infoData.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("numSwapsPerformed", this.numSwapsPerformed);
        aNBT.func_74768_a("timeUntilNextSwap", this.timeUntilNextSwap);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.numSwapsPerformed = aNBT.func_74762_e("numSwapsPerformed");
        this.timeUntilNextSwap = aNBT.func_74762_e("timeUntilNextSwap");
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 8, 0)) {
            return false;
        }
        if (this.lensInputBus == null) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    public boolean addLensHousingToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchLensHousing) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.lensInputBus = (MTEHatchLensHousing)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addLensIndicatorToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchLensIndicator) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.lensIndicator = (MTEHatchLensIndicator)aMetaTileEntity;
            this.lensIndicator.updateRedstoneOutput(false);
            return true;
        }
        return false;
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MAGNETIZER_LOOP;
    }

    private static enum SpecialHatchElement implements IHatchElement<MTEPurificationUnitUVTreatment>
    {
        LensHousing(MTEPurificationUnitUVTreatment::addLensHousingToMachineList, new Class[]{MTEHatchLensHousing.class}){

            @Override
            public long count(MTEPurificationUnitUVTreatment gtMetaTileEntityPurificationUnitUVTreatment) {
                if (gtMetaTileEntityPurificationUnitUVTreatment.lensInputBus == null) {
                    return 0L;
                }
                return 1L;
            }
        }
        ,
        LensIndicator(MTEPurificationUnitUVTreatment::addLensIndicatorToMachineList, new Class[]{MTEHatchLensHousing.class}){

            @Override
            public long count(MTEPurificationUnitUVTreatment gtMetaTileEntityPurificationUnitUVTreatment) {
                if (gtMetaTileEntityPurificationUnitUVTreatment.lensIndicator == null) {
                    return 0L;
                }
                return 1L;
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEPurificationUnitUVTreatment> adder;

        @SafeVarargs
        private SpecialHatchElement(IGTHatchAdder<MTEPurificationUnitUVTreatment> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEPurificationUnitUVTreatment> adder() {
            return this.adder;
        }
    }
}

