/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.tileentities.machines.multi.MTELargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTELargeTurbineGas
extends MTELargeTurbine {
    public MTELargeTurbineGas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineGas(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][58];
        return iTextureArray;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Gas Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Warning: Will be capped at 8192 EU/t in a future update").addInfo("See the Advanced Large Gas Turbine as the next, uncapped, option").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Stainless Steel Turbine Casing", 8, 30, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addMufflerHatch("Side centered", 2).addInputHatch("Gas Fuel, Side centered", 2).addOtherStructurePart("Air", "3x3 area in front of controller").toolTipFinisher(new String[0]);
        return tt;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GTRecipe tFuel = RecipeMaps.gasTurbineFuels.getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineGas(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.gasTurbineFuels;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -1;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 10;
    }

    @Override
    public int getCasingTextureIndex() {
        return 58;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.gregtechproxy.mPollutionLargeGasTurbinePerSecond;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        if (!aFluids.isEmpty()) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (turbine.getOptimalGasEUt() < (float)fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GTUtility.safeInt((long)turbine.getOptimalGasEUt());
            }
            actualOptimalFlow = GTUtility.safeInt((long)((this.looseFit ? turbine.getOptimalLooseGasFlow() : turbine.getOptimalGasFlow()) / (float)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GTUtility.safeInt((long)((float)actualOptimalFlow * (1.5f * (float)turbine.getOverflowEfficiency())));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GTUtility.safeInt((long)totalFlow * (long)fuelValue);
            if (totalFlow != actualOptimalFlow) {
                float efficiency = this.getOverflowEfficiency(totalFlow, actualOptimalFlow, turbine.getOverflowEfficiency());
                tEU = (int)((float)tEU * efficiency);
            }
            if ((long)(tEU = GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseGasEfficiency() : turbine.getGasEfficiency())))) > this.getMaximumOutput()) {
                tEU = GTUtility.safeInt(this.getMaximumOutput());
            }
            return tEU;
        }
        return 0;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier * 3 - 1)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }
}

