/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.MTEEssentiaOutputHatch;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class MTELargeEssentiaSmeltery
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("icons/LargeEssentiaSmeltery_On");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("icons/LargeEssentiaSmeltery_On_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("icons/LargeEssentiaSmeltery_Off");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("icons/LargeEssentiaSmeltery_Off_GLOW");
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final int CASING_INDEX = 1536;
    private static final int MAX_STRUCTURE_LENGTH = 8;
    private static final int DEFAULT_STRUCTURE_LENGTH = 3;
    private static final int MAX_CONFIGURABLE_LENGTH = 5;
    private static final int RECIPE_DURATION = 32;
    private static final int RECIPE_EUT = 480;
    private static final float NODE_COST_MULTIPLIER = 1.15f;
    public AspectList mOutputAspects = new AspectList();
    protected int mCasing = 0;
    protected double mParallel = 0.0;
    protected int nodePower = 0;
    protected int nodePurificationEfficiency = 0;
    protected int nodeIncrease = 0;
    private IStructureDefinition<MTELargeEssentiaSmeltery> multiDefinition = null;
    private final ArrayList<MTEEssentiaOutputHatch> mEssentiaOutputHatches = new ArrayList();
    private int pTier = 0;
    private final XSTR xstr = new XSTR();

    public MTELargeEssentiaSmeltery(String name) {
        super(name);
    }

    public MTELargeEssentiaSmeltery(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_FIRST, 2, 2, 0, itemStack, hintsOnly);
        this.structureBuild_EM(STRUCTURE_PIECE_LATER, 2, 2, -1, itemStack, hintsOnly);
        this.structureBuild_EM(STRUCTURE_PIECE_LATER, 2, 2, -2, itemStack, hintsOnly);
        int len = itemStack.field_77994_a;
        if (len > 5) {
            len = 5;
        }
        this.structureBuild_EM(STRUCTURE_PIECE_LAST, 2, 2, -len - 3, itemStack, hintsOnly);
        while (len > 0) {
            this.structureBuild_EM(STRUCTURE_PIECE_LATER, 2, 2, -len - 2, itemStack, hintsOnly);
            --len;
        }
    }

    @Override
    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mEssentiaOutputHatches.clear();
    }

    @Override
    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mCasing = 0;
        this.mParallel = 0.0;
        this.pTier = 0;
        this.nodePower = 0;
        this.nodePurificationEfficiency = 0;
        this.nodeIncrease = 0;
        if (!this.structureCheck_EM(STRUCTURE_PIECE_FIRST, 2, 2, 0)) {
            return false;
        }
        if (!this.structureCheck_EM(STRUCTURE_PIECE_LATER, 2, 2, -1)) {
            return false;
        }
        if (!this.structureCheck_EM(STRUCTURE_PIECE_LATER, 2, 2, -2)) {
            return false;
        }
        int len = 2;
        while (this.structureCheck_EM(STRUCTURE_PIECE_LATER, 2, 2, -len - 1)) {
            ++len;
        }
        if (len > 7 || len < 3) {
            return false;
        }
        if (!this.structureCheck_EM(STRUCTURE_PIECE_LAST, 2, 2, -len - 1)) {
            return false;
        }
        if (this.mCasing >= 24 && this.mMaintenanceHatches.size() == 1 && !this.mInputBusses.isEmpty() && !this.mEssentiaOutputHatches.isEmpty()) {
            this.mParallel = Math.floor(this.mParallel += (double)(1 << this.pTier));
            return true;
        }
        return false;
    }

    @Override
    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(STRUCTURE_PIECE_FIRST, StructureUtility.transpose((String[][])new String[][]{{"  A  "}, {" AAA "}, {"AA~AA"}, {" AAA "}, {"  A  "}})).addShape(STRUCTURE_PIECE_LATER, StructureUtility.transpose((String[][])new String[][]{{" ABA "}, {"AECEA"}, {"D---D"}, {"AEFEA"}, {" AAA "}})).addShape(STRUCTURE_PIECE_LAST, StructureUtility.transpose((String[][])new String[][]{{"  A  "}, {" AAA "}, {"AAAAA"}, {" AAA "}, {"  A  "}})).addElement('C', StructureUtility.ofBlock((Block)Loaders.essentiaFilterCasing, (int)0)).addElement('D', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticOpaque, (int)2)).addElement('F', Mods.ThaumicBases.isModLoaded() ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"thaumicbases:advAlchFurnace"), (int)0) : StructureUtility.ofBlock((Block)ConfigBlocks.blockStoneDevice, (int)0)).addElement('E', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> x.onEssentiaCellFound(0), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)0)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(1), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)1)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(2), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)2)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(3), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)3))})).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTELargeEssentiaSmeltery.class).atLeast(HatchElement.Maintenance, HatchElement.Energy, HatchElement.InputBus, HatchElement.InputHatch).casingIndex(1536).dot(1).build(), StructureUtility.ofSpecificTileAdder(MTELargeEssentiaSmeltery::addEssentiaOutputHatchToMachineList, MTEEssentiaOutputHatch.class, (Block)Loaders.essentiaOutputHatch, (int)0), StructureUtility.onElementPass(MTELargeEssentiaSmeltery::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.magicCasing, (int)0))})).addElement('B', HatchElement.Muffler.newAny(1536, 2)).build();
        }
        return this.multiDefinition;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Essentia Smeltery").addInfo("Necessary evil.").addInfo("Advanced Essentia smelting technology.").addInfo("Max parallel dictated by structure size and Essentia Diffusion Cell tier").addInfo("Energy Hatch tier: HV+").addInfo("You can find more information about this machine in the Thaumonomicon.").addPollutionAmount(this.getPollutionPerSecond(null)).addController("Front center").addCasingInfoMin("Magic Casing", 24, false).addMaintenanceHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addInputHatch("Hint block with dot 1").addEnergyHatch("Hint block with dot 1").addOtherStructurePart("Essentia Output Hatch", "Hint block with dot 1").addMufflerHatch("Hint block with dot 2").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("LargeEssentiaSmeltery.hint", 8);
    }

    @Override
    public String[] getInfoData() {
        String[] info = super.getInfoData();
        info[8] = "Node Power: " + EnumChatFormatting.RED + this.nodePower + EnumChatFormatting.RESET + " Purification Efficiency: " + EnumChatFormatting.AQUA + this.nodePurificationEfficiency + "%" + EnumChatFormatting.RESET + " Speed Up: " + EnumChatFormatting.GRAY + this.nodeIncrease + "%" + EnumChatFormatting.RESET;
        return info;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1536), TextureFactory.of(textureFontOn), TextureFactory.builder().addIcon(textureFontOn_Glow).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1536), TextureFactory.of(textureFontOff), TextureFactory.builder().addIcon(textureFontOff_Glow).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1536)};
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onEssentiaCellFound(int tier) {
        this.mParallel += (double)((float)(1 << tier) * 0.25f);
        this.pTier = Math.max(this.pTier, tier);
    }

    private boolean addEnergyHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            if (((MTEHatchEnergy)aMetaTileEntity).mTier < 3) {
                return false;
            }
            ((MTEHatchEnergy)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((MTEHatchEnergy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            ((MTEHatchEnergyMulti)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add((MTEHatchEnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    private boolean addEssentiaOutputHatchToMachineList(MTEEssentiaOutputHatch aTileEntity) {
        if (aTileEntity instanceof MTEEssentiaOutputHatch) {
            return this.mEssentiaOutputHatches.add(aTileEntity);
        }
        return false;
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!this.isFullPower()) {
            return;
        }
        super.runMachine(aBaseMetaTileEntity, aTick);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        int sur;
        int stackSize;
        int i;
        if (!this.isFullPower()) {
            return SimpleCheckRecipeResult.ofFailure("node_too_small");
        }
        ArrayList<ItemStack> tItemsList = this.getStoredInputs();
        ArrayList<FluidStack> tFluidsList = this.getStoredFluids();
        if (tItemsList.isEmpty() && tFluidsList.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int p = (int)this.mParallel;
        for (i = tItemsList.size() - 1; i >= 0; --i) {
            ItemStack itemStack = tItemsList.get(i);
            stackSize = itemStack.field_77994_a;
            sur = p - stackSize;
            if (sur > 0) {
                p -= stackSize;
                this.mOutputAspects.add(this.getEssentia(itemStack, stackSize));
                if (this.depleteInput(itemStack)) continue;
                itemStack.field_77994_a = 0;
                continue;
            }
            if (sur == 0) {
                this.mOutputAspects.add(this.getEssentia(itemStack, stackSize));
                if (this.depleteInput(itemStack)) break;
                itemStack.field_77994_a = 0;
                break;
            }
            this.mOutputAspects.add(this.getEssentia(itemStack, p));
            itemStack.field_77994_a -= p;
            break;
        }
        for (i = tFluidsList.size() - 1; i >= 0; --i) {
            FluidStack fluidStack = tFluidsList.get(i);
            stackSize = fluidStack.amount / 1000;
            sur = p - stackSize;
            if (sur > 0) {
                p -= stackSize;
                this.mOutputAspects.add(this.getEssentia(fluidStack, stackSize));
                if (this.depleteInput(fluidStack)) continue;
                fluidStack.amount = 0;
                continue;
            }
            if (sur == 0) {
                this.mOutputAspects.add(this.getEssentia(fluidStack, stackSize));
                if (this.depleteInput(fluidStack)) break;
                fluidStack.amount = 0;
                break;
            }
            this.mOutputAspects.add(this.getEssentia(fluidStack, p));
            fluidStack.amount -= p;
            break;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        World WORLD = this.getBaseMetaTileEntity().getWorld();
        int x = this.getBaseMetaTileEntity().getXCoord();
        short y = this.getBaseMetaTileEntity().getYCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        this.drainNodePower(WORLD, x, y, z);
        this.nodePower -= this.expectedPower();
        OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(480L).setEUt(this.getMaxInputEu()).setDuration((int)Math.ceil((double)(this.mOutputAspects.visSize() * 32) * (1.0 - (double)this.nodeIncrease * 0.005))).setDurationDecreasePerOC(4.0).calculate();
        this.useLongPower = true;
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private AspectList getEssentia(ItemStack itemStack, int amount) {
        AspectList aspectList = new AspectList();
        if (amount == 0) {
            return aspectList;
        }
        AspectList aspects = ThaumcraftCraftingManager.getObjectTags((ItemStack)itemStack);
        if ((aspects = ThaumcraftCraftingManager.getBonusTags((ItemStack)itemStack, (AspectList)aspects)) != null && aspects.size() != 0 && aspects.getAspects()[0] != null) {
            for (int i = 0; i < amount; ++i) {
                aspectList.add(aspects);
            }
        } else {
            aspectList.add(Aspect.ENTROPY, amount);
        }
        return aspectList;
    }

    private AspectList getEssentia(FluidStack fluidStack, int amountBuckets) {
        Block fluidBlock = fluidStack.getFluid().getBlock();
        if (fluidBlock == null) {
            return new AspectList();
        }
        ItemStack block = new ItemStack(fluidBlock);
        return this.getEssentia(block, amountBuckets);
    }

    private void fillEssentiaOutputHatch() {
        for (MTEEssentiaOutputHatch outputHatch : this.mEssentiaOutputHatches) {
            for (Map.Entry entry : this.mOutputAspects.copy().aspects.entrySet()) {
                Aspect aspect = (Aspect)entry.getKey();
                int amount = (Integer)entry.getValue();
                this.mOutputAspects.remove(aspect, outputHatch.addEssentia(aspect, amount, null));
            }
        }
        this.mOutputAspects.aspects.clear();
    }

    private int expectedPower() {
        return (int)(Math.pow(this.getMaxEnergyInputTier_EM(), 2.0) * (double)1.15f);
    }

    private boolean isFullPower() {
        return this.nodePower > this.expectedPower();
    }

    private void generateFluxGas(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, ConfigBlocks.blockFluxGas, 8, 3);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74780_a("mParallel", this.mParallel);
        aNBT.func_74780_a("nodePower", (double)this.nodePower);
        aNBT.func_74780_a("nodePurificationEfficiency", (double)this.nodePurificationEfficiency);
        aNBT.func_74780_a("nodeIncrease", (double)this.nodeIncrease);
        Aspect[] aspectA = this.mOutputAspects.getAspects();
        NBTTagList nbtTagList = new NBTTagList();
        for (Aspect aspect : aspectA) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.mOutputAspects.getAmount(aspect));
            nbtTagList.func_74742_a((NBTBase)f);
        }
        aNBT.func_74782_a("Aspects", (NBTBase)nbtTagList);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mParallel = aNBT.func_74769_h("mParallel");
        this.nodePower = aNBT.func_74762_e("nodePower");
        this.nodePurificationEfficiency = aNBT.func_74762_e("nodePurificationEfficiency");
        this.nodeIncrease = aNBT.func_74762_e("nodeIncrease");
        this.mOutputAspects.aspects.clear();
        NBTTagList tlist = aNBT.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.mOutputAspects.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
        super.loadNBTData(aNBT);
    }

    @Override
    protected void addClassicOutputs_EM() {
        super.addClassicOutputs_EM();
        this.fillEssentiaOutputHatch();
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.mOutputAspects.aspects.clear();
    }

    private void drainNodePower(World world, int x, int y, int z) {
        int power = this.expectedPower();
        if (this.nodePower < power * 10) {
            this.nodePower += VisNetHandler.drainVis((World)world, (int)x, (int)y, (int)z, (Aspect)Aspect.WATER, (int)power);
            this.nodePower += VisNetHandler.drainVis((World)world, (int)x, (int)y, (int)z, (Aspect)Aspect.FIRE, (int)power);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 5L == 0L && this.mMachine) {
            World WORLD = this.getBaseMetaTileEntity().getWorld();
            int x = this.getBaseMetaTileEntity().getXCoord();
            short y = this.getBaseMetaTileEntity().getYCoord();
            int z = this.getBaseMetaTileEntity().getZCoord();
            this.drainNodePower(WORLD, x, y, z);
            this.nodePurificationEfficiency = Math.max(0, this.nodePurificationEfficiency - 1);
            if (this.nodePurificationEfficiency < 100) {
                this.nodePurificationEfficiency = (int)Math.min(100.0, (double)this.nodePurificationEfficiency + Math.ceil((double)VisNetHandler.drainVis((World)WORLD, (int)x, (int)y, (int)z, (Aspect)Aspect.ORDER, (int)200) * 0.05));
            }
            this.nodeIncrease = Math.min(100, VisNetHandler.drainVis((World)WORLD, (int)x, (int)y, (int)z, (Aspect)Aspect.ENTROPY, (int)125));
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        this.nodePurificationEfficiency = Math.max(0, this.nodePurificationEfficiency - 1);
        if (this.xstr.nextInt(20) == 0 && this.xstr.nextInt(100) < Math.max(100 - this.nodePurificationEfficiency, 0)) {
            World WORLD = this.getBaseMetaTileEntity().getWorld();
            MTEHatchMuffler mufflerHatch = (MTEHatchMuffler)this.mMufflerHatches.get(this.xstr.nextInt(this.mMufflerHatches.size()));
            int x = mufflerHatch.getBaseMetaTileEntity().getXCoord();
            int y = mufflerHatch.getBaseMetaTileEntity().getYCoord();
            int z = mufflerHatch.getBaseMetaTileEntity().getZCoord();
            ForgeDirection facing = mufflerHatch.getBaseMetaTileEntity().getFrontFacing();
            switch (facing) {
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case EAST: {
                    ++x;
                    break;
                }
                default: {
                    ++y;
                }
            }
            this.generateFluxGas(WORLD, x, y, z);
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 22 * (100 - this.nodePurificationEfficiency);
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTELargeEssentiaSmeltery(this.mName);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 2, 2, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int length = stackSize.field_77994_a + 2;
        if (length > 5) {
            length = 7;
        }
        for (int i = 1; i <= length; ++i) {
            built = this.survivialBuildPiece(STRUCTURE_PIECE_LATER, stackSize, 2, 2, -i, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 2, 2, -length - 1, elementBudget, env, false, true);
    }
}

