/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.gtenhancement;

import bartworks.system.material.gtenhancement.BWGTMetaItems;
import codechicken.nei.api.API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GTMetaItemEnhancer {
    static List<Materials> NoMetaValue;

    private GTMetaItemEnhancer() {
    }

    public static void init() {
        Materials m2;
        int i;
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        NoMetaValue = Materials.getMaterialsMap().values().stream().filter(m -> m.mMetaItemSubID == -1).collect(Collectors.toList());
        BWGTMetaItems moltenCapsuls = new BWGTMetaItems(OrePrefixes.capsuleMolten, null);
        BWGTMetaItems capsuls = new BWGTMetaItems(OrePrefixes.capsule, NoMetaValue);
        Materials[] values = Materials.values();
        int valuesLength = values.length;
        for (i = 0; i < valuesLength; ++i) {
            m2 = values[i];
            if (m2.mStandardMoltenFluid != null && GTOreDictUnificator.get(OrePrefixes.cellMolten, m2, 1L) != null) {
                FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(m2.getMolten(144L), new ItemStack((Item)moltenCapsuls, 1, i), GTModHandler.getModItem(Mods.Forestry.ID, "refractoryEmpty", 1L));
                FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
                GTUtility.addFluidContainerData(emptyData);
            }
            if (m2.getFluid(1L) == null && m2.getGas(1L) == null || OreDictionary.doesOreNameExist((String)("capsule" + m2.mName))) continue;
            GTMetaItemEnhancer.addFluidData(m2, GTModHandler.getModItem(Mods.Forestry.ID, "waxCapsule", 1L), capsuls, 1000, i, true);
        }
        valuesLength = NoMetaValue.size();
        for (i = 0; i < valuesLength; ++i) {
            m2 = NoMetaValue.get(i);
            if (m2.getFluid(1L) == null && m2.getGas(1L) == null || OreDictionary.doesOreNameExist((String)("capsule" + m2.mName))) continue;
            GTMetaItemEnhancer.addFluidData(m2, GTModHandler.getModItem(Mods.Forestry.ID, "waxCapsule", 1L), capsuls, 1000, i + 1001, true);
        }
        API.hideItem((ItemStack)new ItemStack((Item)capsuls, 1, Short.MAX_VALUE));
        API.hideItem((ItemStack)new ItemStack((Item)moltenCapsuls, 1, Short.MAX_VALUE));
    }

    private static void addFluidData(Materials m, ItemStack container, Item filled, int amount, int it, boolean empty) {
        Fluid f = m.getFluid(1L) != null ? m.getFluid(1L).getFluid() : m.getGas(1L).getFluid();
        FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(f, amount), new ItemStack(filled, 1, it), container);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
        GTUtility.addFluidContainerData(emptyData);
    }

    public static void addAdditionalOreDictToForestry() {
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        OreDictionary.registerOre((String)"capsuleWater", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleWater"));
        OreDictionary.registerOre((String)"capsuleIce", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleIce"));
        OreDictionary.registerOre((String)"capsuleHoney", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleHoney"));
        OreDictionary.registerOre((String)"capsuleJuice", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleJuice"));
        OreDictionary.registerOre((String)"capsuleSeedOil", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleSeedOil"));
        OreDictionary.registerOre((String)"capsuleEthanol", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleEthanol"));
        OreDictionary.registerOre((String)"capsuleBiomass", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleBiomass"));
        OreDictionary.registerOre((String)"capsuleShortMead", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleShortMead"));
        OreDictionary.registerOre((String)"capsuleMead", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleMead"));
        OreDictionary.registerOre((String)"capsuleFuel", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleFuel"));
        OreDictionary.registerOre((String)"capsuleOil", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleOil"));
        OreDictionary.registerOre((String)"capsuleLava", (ItemStack)GTMetaItemEnhancer.getForestryItem("refractoryLava"));
    }

    private static ItemStack getForestryItem(String itemName) {
        return GTModHandler.getModItem(Mods.Forestry.ID, itemName, 1L);
    }
}

