/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis.mega;

import bartworks.API.BorosilicateGlass;
import bartworks.common.configs.Configuration;
import bartworks.common.tileentities.multis.mega.MegaMultiBlockBase;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.maps.OilCrackerBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEMegaOilCracker
extends MegaMultiBlockBase<MTEMegaOilCracker>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEMegaOilCracker> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{" p         p ", "ppgggggggggpp", " pgggggggggp ", " pgggMMMgggp ", " pgggMMMgggp ", " pgggMMMgggp ", " pgggggggggp ", "ppgggggggggpp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " l   c   c r ", " l c c c c r ", " l   c   c r ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " l c c c c r ", " l c c c c r ", " l c c c c r ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " l   c   c r ", " l c c c c r ", " l   c   c r ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", "pgggggggggggp", " p         p "}, {"ppmmmm~mmmmpp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppmmmmmmmmmpp"}})).addElement('c', StructureUtility.withChannel((String)"coil", GTStructureUtility.ofCoil(MTEMegaOilCracker::setCoilLevel, MTEMegaOilCracker::getCoilLevel))).addElement('p', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('l', GTStructureUtility.buildHatchAdder(MTEMegaOilCracker.class).atLeast(HatchElement.InputHatch.withAdder(MTEMegaOilCracker::addLeftHatchToMachineList)).dot(2).casingIndex(49).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('r', GTStructureUtility.buildHatchAdder(MTEMegaOilCracker.class).atLeast(HatchElement.OutputHatch.withAdder(MTEMegaOilCracker::addRightHatchToMachineList)).dot(3).casingIndex(49).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('m', GTStructureUtility.buildHatchAdder(MTEMegaOilCracker.class).atLeast(HatchElement.Energy.or(HatchElement.ExoticEnergy), HatchElement.Maintenance, HatchElement.InputBus).casingIndex(49).dot(1).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('M', GTStructureUtility.buildHatchAdder(MTEMegaOilCracker.class).atLeast(HatchElement.InputHatch.withAdder(MTEMegaOilCracker::addMiddleInputToMachineList)).dot(4).casingIndex(49).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('g', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).build();
    private byte glassTier;
    private HeatingCoilLevel heatLevel;
    protected final List<MTEHatchInput> mMiddleInputHatches = new ArrayList<MTEHatchInput>();
    protected int mInputOnSide = -1;
    protected int mOutputOnSide = -1;

    public MTEMegaOilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMegaOilCracker(String aName) {
        super(aName);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Cracker").addInfo("Thermally cracks heavy hydrocarbons into lighter fractions").addInfo("More efficient than the Chemical Reactor").addInfo("Gives different benefits whether it hydro or steam-cracks:").addInfo("Hydro - Consumes 20% less Hydrogen and outputs 25% more cracked fluid").addInfo("Steam - Outputs 50% more cracked fluid").addInfo("(Values compared to cracking in the Chemical Reactor)").addInfo("Place the appropriate circuit in the controller or an input bus").addInfo(GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "-tier glass required for " + EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Laser Hatches.").beginStructureBlock(13, 7, 9, true).addController("Front bottom").addStructureInfo("The glass tier limits the Energy Input tier").addInfo("Gets 10% EU/t reduction per coil tier, up to a maximum of 50%").addEnergyHatch("Hint block", 1).addMaintenanceHatch("Hint block", 1).addInputHatch("Hint block", 2, 3).addOutputHatch("Hint block", 2, 3).addInputHatch("Steam/Hydrogen ONLY, Hint block", 4).addInputBus("Optional, for programmed circuit automation. Hint block", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMegaOilCracker(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    public RecipeMap<OilCrackerBackend> getRecipeMap() {
        return RecipeMaps.crackingRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                this.setEuModifier(1.0f - Math.min(0.1f * (float)(MTEMegaOilCracker.this.heatLevel.getTier() + 1), 0.5f));
                return super.process();
            }
        }.setMaxParallel(Configuration.Multiblocks.megaMachinesMax);
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 6, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 6, 0, realBudget, source, actor, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glassTier = 0;
        this.mInputOnSide = -1;
        this.mOutputOnSide = -1;
        this.mMiddleInputHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 6, 0) || this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (this.glassTier < 8) {
            for (MTEHatch hatch : this.mExoticEnergyHatches) {
                if (hatch.getConnectionType() == MTEHatch.ConnectionType.LASER) {
                    return false;
                }
                if (this.glassTier >= hatch.mTier) continue;
                return false;
            }
            for (MTEHatchEnergy mEnergyHatch : this.mEnergyHatches) {
                if (this.glassTier >= mEnergyHatch.mTier) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addLeftHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            if (this.mInputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tHatch = (MTEHatchOutput)aMetaTileEntity;
            if (this.mOutputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addRightHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            if (this.mInputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tHatch = (MTEHatchOutput)aMetaTileEntity;
            if (this.mOutputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addMiddleInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mMiddleInputHatches.add(tHatch);
        }
        return false;
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        MTEHatchInputME meHatch;
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        HashMap<Fluid, FluidStack> inputsFromME = new HashMap<Fluid, FluidStack>();
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof MTEHatchInputME) {
                meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack tFluid : meHatch.getStoredFluids()) {
                    if (tFluid == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    inputsFromME.put(tFluid.getFluid(), tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchMultiInput) {
                for (FluidStack tFluid : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tHatch.getFillableStack())) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof MTEHatchInputME) {
                meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack tFluid : meHatch.getStoredFluids()) {
                    if (tFluid == null || !this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    inputsFromME.put(tFluid.getFluid(), tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchMultiInput) {
                for (FluidStack tFluid : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || !this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null) continue;
            FluidStack tStack = tHatch.getFillableStack();
            if (!this.getRecipeMap().getBackend().isValidCatalystFluid(tStack)) continue;
            rList.add(tStack);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    @Override
    public IStructureDefinition<MTEMegaOilCracker> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    protected void startRecipeProcessing() {
        for (MTEHatchInput hatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            aware.startRecipeProcessing();
        }
        super.startRecipeProcessing();
    }

    @Override
    protected void endRecipeProcessing() {
        super.endRecipeProcessing();
        for (MTEHatchInput hatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            this.setResultIfFailure(aware.endRecipeProcessing(this));
        }
    }
}

