/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.items.SimpleSubItemClass;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTEHighTempGasCooledReactor
extends MTEEnhancedMultiBlockBase<MTEHighTempGasCooledReactor> {
    private static final int BASECASINGINDEX = 181;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEHighTempGasCooledReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  BBBBBBB  ", " BBBBBBBBB ", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", " BBBBBBBBB ", "  BBBBBBB  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  bbb~bbb  ", " bbbbbbbbb ", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", " bbbbbbbbb ", "  bbbbbbb  "}})).addElement('c', StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5))).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 181, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 181, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, 181, 1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5))})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, 181, 2), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5))})).build();
    private static final int HELIUM_NEEDED = 730000;
    public static final int powerUsage = (int)TierEU.RECIPE_LuV;
    private static final int maxcapacity = 720000;
    private static final int mincapacity = 72000;
    private int HeliumSupply;
    private int fueltype = -1;
    private int fuelsupply = 0;
    private boolean empty;
    private int emptyticksnodiff = 0;
    private int coolanttaking = 0;
    private int mCasing = 0;
    private int runningtick = 0;

    public MTEHighTempGasCooledReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private MTEHighTempGasCooledReactor(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public IStructureDefinition<MTEHighTempGasCooledReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Breeder Reactor").addInfo("You can clear internal buffer by changing the mode with a screwdriver").addInfo("Needs a constant supply of coolant while running").addInfo("Needs at least 72k Fuel pebbles to start operation (can hold up to 720k pebbles)").addInfo("Consumes up to 2.5% of total Fuel Pellets per Operation depending on efficiency").addInfo("Efficiency is calculated exponentially depending on the amount of pebbles in the internal buffer").addInfo("and affects total recipe time (at 100% eff, -50% total recipe time").addInfo("Reactor will take 4 000L/s of coolant multiplied by efficiency and by fuel coolant value (check tooltips)").addInfo("Uses " + GTUtility.formatNumbers(powerUsage) + " EU/t").addInfo("One Operation takes 1 hour").beginStructureBlock(11, 12, 11, true).addController("Front bottom center").addCasingInfoMin("Europium Reinforced Radiation Proof Casings", 500, false).addStructureInfo("Corners and the 2 touching blocks are air (cylindric)").addInputBus("Any top layer casing", 2).addInputHatch("Any top layer casing", 2).addOutputBus("Any bottom layer casing", 1).addOutputHatch("Any bottom layer casing", 1).addEnergyHatch("Any bottom layer casing", 1).addMaintenanceHatch("Any bottom layer casing", 1).toolTipFinisher(GTValues.AuthorKuba);
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 11, 0);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mCasing = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 11, 0) && this.mCasing >= 500 && this.mMaintenanceHatches.size() == 1 && !this.mInputHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mInputBusses.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.HeliumSupply = aNBT.func_74762_e("HeliumSupply");
        this.fueltype = aNBT.func_74762_e("fueltype");
        this.fuelsupply = aNBT.func_74762_e("fuelsupply");
        this.empty = aNBT.func_74767_n("EmptyMode");
        this.coolanttaking = aNBT.func_74762_e("coolanttaking");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("HeliumSupply", this.HeliumSupply);
        aNBT.func_74768_a("fueltype", this.fueltype);
        aNBT.func_74768_a("fuelsupply", this.fuelsupply);
        aNBT.func_74757_a("EmptyMode", this.empty);
        aNBT.func_74768_a("coolanttaking", this.coolanttaking);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && !this.empty) {
            boolean updateneeded = false;
            if (this.HeliumSupply < 730000) {
                for (FluidStack fluidStack : this.getStoredFluids()) {
                    if (!fluidStack.isFluidEqual(Materials.Helium.getGas(1L))) continue;
                    int toget = Math.min(730000 - this.HeliumSupply, fluidStack.amount);
                    fluidStack.amount -= toget;
                    this.HeliumSupply += toget;
                    updateneeded = true;
                }
            }
            if (this.fuelsupply < 720000) {
                this.startRecipeProcessing();
                for (ItemStack itemStack : this.getStoredInputs()) {
                    int damage;
                    int type = -1;
                    if (itemStack == null || itemStack.func_77973_b() != HTGRMaterials.aHTGR_Materials || ((damage = HTGRMaterials.aHTGR_Materials.getDamage(itemStack)) + 1) % HTGRMaterials.MATERIALS_PER_FUEL != 5) continue;
                    type = damage / HTGRMaterials.MATERIALS_PER_FUEL;
                    if (this.fueltype == -1) {
                        this.fueltype = type;
                    }
                    if (this.fueltype != type) continue;
                    int toget = Math.min(720000 - this.fuelsupply, itemStack.field_77994_a);
                    this.fuelsupply += toget;
                    itemStack.field_77994_a -= toget;
                    updateneeded = true;
                }
                this.endRecipeProcessing();
            }
            if (updateneeded) {
                this.updateSlots();
            }
        }
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.htgrFakeRecipes;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public boolean checkRecipe(ItemStack controllerStack) {
        int meta;
        ItemStack[] toOutput;
        int toReduce;
        if (this.empty) {
            if (this.HeliumSupply > 0 || this.fuelsupply > 0) {
                this.mEfficiency = 10000;
                this.mMaxProgresstime = 100;
                return true;
            }
            return false;
        }
        if (this.HeliumSupply < 730000 || this.fuelsupply < 72000) {
            return false;
        }
        double eff = Math.min(Math.pow((double)this.fuelsupply / 72000.0, 2.0), 100.0) / 100.0 - (double)(this.getIdealStatus() - this.getRepairStatus()) / 10.0;
        if (eff <= 0.0) {
            return false;
        }
        int originalToReduce = toReduce = MathUtils.floorInt((double)this.fuelsupply * 0.025 * eff);
        int burnedballs = toReduce / 64;
        if (burnedballs > 0) {
            toReduce -= burnedballs * 64;
        }
        if (!this.canOutputAll(toOutput = new ItemStack[]{new ItemStack((Item)HTGRMaterials.aHTGR_Materials, burnedballs, meta = this.fueltype * HTGRMaterials.MATERIALS_PER_FUEL + 5), new ItemStack((Item)HTGRMaterials.aHTGR_Materials, toReduce, meta + 1)})) {
            return false;
        }
        this.fuelsupply -= originalToReduce;
        this.mOutputItems = toOutput;
        this.coolanttaking = (int)(4000.0 * ((double)this.fueltype * 0.5 + 1.0) * eff);
        this.mEfficiency = (int)(eff * 10000.0);
        this.mEfficiencyIncrease = 0;
        this.mEUt = -powerUsage;
        this.mMaxProgresstime = (int)(72000.0 * (1.0 - eff / 2.0));
        return true;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        ++this.runningtick;
        if (this.empty) {
            if (this.emptyticksnodiff > 20 && this.emptyticksnodiff % 20 != 0) {
                ++this.emptyticksnodiff;
                return true;
            }
            if (this.HeliumSupply > 0) {
                this.addOutput(Materials.Helium.getGas(this.HeliumSupply));
                this.HeliumSupply = 0;
            }
            if (this.fuelsupply > 0) {
                ItemStack iStack = new ItemStack((Item)HTGRMaterials.aHTGR_Materials, this.fuelsupply, HTGRMaterials.MATERIALS_PER_FUEL * this.fueltype + 4);
                boolean storedAll = false;
                for (MTEHatchOutputBus tHatch : GTUtility.validMTEList(this.mOutputBusses)) {
                    if (!tHatch.storeAll(iStack)) continue;
                    storedAll = true;
                    break;
                }
                if (!storedAll) {
                    if (this.fuelsupply == iStack.field_77994_a) {
                        ++this.emptyticksnodiff;
                    } else {
                        this.fuelsupply = iStack.field_77994_a;
                        this.emptyticksnodiff = 0;
                    }
                } else {
                    this.fuelsupply = 0;
                    this.fueltype = -1;
                    this.coolanttaking = 0;
                }
            }
            return true;
        }
        if (!this.drainEnergyInput(-this.mEUt)) {
            this.criticalStopMachine();
            return false;
        }
        if (this.runningtick % 20 == 0) {
            int takecoolant = this.coolanttaking;
            int drainedamount = 0;
            for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
                FluidStack tLiquid = tHatch.getFluid();
                if (tLiquid == null || !tLiquid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2coolant", (int)1))) continue;
                FluidStack drained = tHatch.drain(takecoolant, true);
                drainedamount += drained.amount;
                if ((takecoolant -= drained.amount) > 0) continue;
                break;
            }
            if (drainedamount > 0) {
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)drainedamount));
            }
            this.updateSlots();
            if (takecoolant > 0) {
                this.stopMachine();
            }
        }
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEHighTempGasCooledReactor(this.mName);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Mode:", this.empty ? "Emptying" : "Normal", "Progress:", GTUtility.formatNumbers(this.mProgresstime / 20) + "s / " + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + "s", "Fuel type:", this.fueltype == -1 ? "NONE" : "TRISO (" + HTGRMaterials.sHTGR_Fuel[this.fueltype].sEnglish + ")", "Fuel amount:", GTUtility.formatNumbers(this.fuelsupply) + " pcs.", "Helium-Level:", GTUtility.formatNumbers(this.HeliumSupply) + "L / " + GTUtility.formatNumbers(730000L) + "L", "Coolant:", GTUtility.formatNumbers(this.coolanttaking) + "L/s", "Problems:", String.valueOf(this.getIdealStatus() - this.getRepairStatus())};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection forgeDirection, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == forgeDirection) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(181), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(181), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(181)};
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "HTGR mode cannot be changed while the machine is running.");
            return;
        }
        this.empty = !this.empty;
        GTUtility.sendChatToPlayer(aPlayer, "HTGR is now running in " + (this.empty ? "emptying mode." : "normal Operation"));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    public static class HTGRMaterials {
        public static final Base_[] sHTGR_Bases = new Base_[]{new Base_("HTGRFuelMixture", "HTGR fuel mixture"), new Base_("BISOPebbleCompound", "BISO pebble compound"), new Base_("TRISOPebbleCompound", "TRISO pebble compound"), new Base_("TRISOBall", "TRISO ball"), new Base_("TRISOPebble", "TRISO pebble"), new Base_("BurnedOutTRISOBall", "Burned out TRISO Ball"), new Base_("BurnedOutTRISOPebble", "Burned out TRISO Pebble")};
        public static final int MATERIALS_PER_FUEL = sHTGR_Bases.length;
        static final int USABLE_FUEL_INDEX = 4;
        static final int BURNED_OUT_FUEL_INDEX = 5;
        public static final Fuel_[] sHTGR_Fuel = new Fuel_[]{new Fuel_("Thorium", "Thorium", WerkstoffLoader.Thorium232.get(OrePrefixes.dust, 64), Materials.Uranium235.getDust(4), GTValues.NF, new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lutetium.getDust(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dust, 1)}, new int[]{2475, 2475, 2475, 2475, 40}, "Multiplies coolant by 1"), new Fuel_("Uranium", "Uranium", Materials.Uranium.getDust(64), Materials.Uranium235.getDust(8), FluidRegistry.getFluidStack((String)"krypton", (int)4), new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lead.getDust(1), Materials.Uranium.getDust(1)}, new int[]{2475, 2475, 2475, 1250, 1250}, "Multiplies coolant by 1.5"), new Fuel_("Plutonium", "Plutonium", Materials.Plutonium.getDust(64), Materials.Plutonium241.getDust(4), FluidRegistry.getFluidStack((String)"xenon", (int)4), new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lead.getDust(1), Materials.Plutonium.getDust(1)}, new int[]{2475, 2475, 2475, 1250, 1250}, "Multiplies coolant by 2")};
        public static final CustomHTGRSimpleSubItemClass aHTGR_Materials;
        static final ArrayList<LangEntry_> aHTGR_Localizations;

        public static void registeraTHR_Materials() {
            for (LangEntry_ iName : aHTGR_Localizations) {
                GTLanguageManager.addStringLocalization(iName.sName, iName.sEnglish);
            }
            GameRegistry.registerItem((Item)aHTGR_Materials, (String)"bw.HTGRMaterials");
        }

        public static void register_fake_THR_Recipes() {
            int i = 0;
            for (Fuel_ fuel : sHTGR_Fuel) {
                GTValues.RA.stdBuilder().itemInputs(new ItemStack((Item)aHTGR_Materials, 64, i + 4)).itemOutputs(new ItemStack((Item)aHTGR_Materials, 1, i + 5)).duration(72000).eut(powerUsage).ignoreCollision().noOptimize().fake().addTo(BartWorksRecipeMaps.htgrFakeRecipes);
                i += MATERIALS_PER_FUEL;
            }
        }

        static {
            aHTGR_Localizations = new ArrayList();
            String[] sHTGR_Materials = new String[sHTGR_Bases.length * sHTGR_Fuel.length];
            HashMap<Integer, String> tooltip = new HashMap<Integer, String>();
            int i = 0;
            for (Fuel_ fuel : sHTGR_Fuel) {
                for (Base_ base : sHTGR_Bases) {
                    sHTGR_Materials[i] = "HTGR" + base.sName + fuel.sName;
                    aHTGR_Localizations.add(new LangEntry_("item." + sHTGR_Materials[i] + ".name", base.sEnglish + " (" + fuel.sEnglish + ")"));
                    if ((i + 1) % MATERIALS_PER_FUEL == 5 && fuel.tooltip != null && !fuel.tooltip.isEmpty()) {
                        tooltip.put(i, fuel.tooltip);
                    }
                    ++i;
                }
            }
            aHTGR_Materials = new CustomHTGRSimpleSubItemClass(tooltip, sHTGR_Materials);
        }

        private static class LangEntry_ {
            public String sName;
            public String sEnglish;

            public LangEntry_(String a, String b) {
                this.sName = a;
                this.sEnglish = b;
            }
        }

        private static class CustomHTGRSimpleSubItemClass
        extends SimpleSubItemClass {
            HashMap<Integer, String> tooltip = null;

            public CustomHTGRSimpleSubItemClass(HashMap<Integer, String> tooltip, String ... tex) {
                super(tex);
                this.tooltip = tooltip;
            }

            public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
                if (this.tooltip.containsKey(this.getDamage(p_77624_1_))) {
                    aList.add(this.tooltip.get(this.getDamage(p_77624_1_)));
                }
                aList.add("Material for High Temperature Gas-cooled Reactor");
                super.func_77624_a(p_77624_1_, p_77624_2_, aList, p_77624_4_);
            }
        }

        public static class Fuel_ {
            public String sName;
            public String sEnglish;
            public ItemStack mainItem;
            public ItemStack secondaryItem;
            public ItemStack[] recycledItems = new ItemStack[]{GTValues.NI, GTValues.NI, GTValues.NI, GTValues.NI, GTValues.NI, GTValues.NI};
            public FluidStack recycledFluid;
            public int[] recycleChances;
            public String tooltip;

            public Fuel_(String sName, String sEnglish, ItemStack mainItem, ItemStack secondaryItem, FluidStack recycledFluid, ItemStack[] recycledItems, int[] recycleChances, String tooltip) {
                this.sName = sName;
                this.sEnglish = sEnglish;
                this.mainItem = mainItem;
                this.secondaryItem = secondaryItem;
                this.recycledFluid = recycledFluid;
                System.arraycopy(recycledItems, 0, this.recycledItems, 0, recycledItems.length);
                this.recycleChances = recycleChances;
                this.tooltip = tooltip;
            }
        }

        private static class Base_ {
            public String sName;
            public String sEnglish;

            public Base_(String a, String b) {
                this.sName = a;
                this.sEnglish = b;
            }
        }
    }
}

