/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.util.BWTooltipReference;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MTEDeepEarthHeatingPump
extends MTEDrillerBase {
    private static float nulearHeatMod = 2.0f;
    private byte mMode;
    private byte mTier;

    public MTEDeepEarthHeatingPump(int aID, int tier, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.mTier = (byte)tier;
    }

    public MTEDeepEarthHeatingPump(String aName, byte mTier) {
        super(aName);
        this.mTier = mTier;
    }

    @Override
    public void onConfigLoad() {
        try {
            Class<TileEntityNuclearReactorElectric> c = TileEntityNuclearReactorElectric.class;
            Field f = c.getDeclaredField("huOutputModifier");
            f.setAccessible(true);
            nulearHeatMod = f.getFloat(f);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException e) {
            e.printStackTrace();
        }
        super.onConfigLoad();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mTier", this.mTier);
        aNBT.func_74774_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mTier = aNBT.func_74771_c("mTier");
        this.mMode = aNBT.func_74771_c("mMode");
        super.loadNBTData(aNBT);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEDeepEarthHeatingPump(this.mName, this.mTier);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        tt.addMachineType("Geothermal Heat Pump").addInfo("Consumes " + GTValues.V[this.mTier + 2] + "EU/t").addInfo("Has 3 Modes, use the Screwdriver to change them:");
        tt.addInfo("Direct Steam, Coolant Heating, Retract").addInfo("Direct Steam Mode: Consumes Distilled Water to produce " + (long)(this.mTier * 25600 * 20) + "L/s of Superheated Steam").addInfo("Coolant Heating Mode: Converts " + (long)(this.mTier * 96 * 2 * 20) + "L/s Coolant to Hot Coolant").addInfo("Each maintenance issue lowers output efficiency by 10%").addInfo("Explodes when it runs out of Distilled Water/Coolant");
        tt.addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GTValues.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes, optional, any base casing").addInputHatch("Any base casing").addOutputHatch("Any base casing").toolTipFinisher(BWTooltipReference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    @Override
    protected ItemList getCasingBlockItem() {
        return ItemList.Casing_HeatProof;
    }

    @Override
    protected Materials getFrameMaterial() {
        return Materials.Tungsten;
    }

    @Override
    protected int getCasingTextureIndex() {
        return 11;
    }

    @Override
    protected int getMinTier() {
        return 2 + this.mTier;
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mInputHatches.isEmpty();
    }

    private long getFluidFromHatches(Fluid f) {
        long ret = 0L;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(f)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    private long getWaterFromHatches(boolean onlyDistilled) {
        Fluid toConsume1 = FluidRegistry.WATER;
        Fluid toConsume2 = GTModHandler.getDistilledWater(1L).getFluid();
        if (onlyDistilled) {
            toConsume1 = toConsume2;
        }
        long ret = 0L;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(toConsume1) && !ih.getFluid().getFluid().equals(toConsume2)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.mMode != 3) {
            this.isPickingPipes = false;
            this.workState = 0;
            return true;
        }
        return super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        this.mMode = (byte)(this.mMode + 1);
        if (this.mMode >= 3) {
            this.mMode = 0;
        }
        if (this.mMode == 0) {
            GTUtility.sendChatToPlayer(aPlayer, "Mode: Direct Steam");
        } else if (this.mMode == 1) {
            GTUtility.sendChatToPlayer(aPlayer, "Mode: Coolant Heating");
        } else if (this.mMode == 2) {
            GTUtility.sendChatToPlayer(aPlayer, "Mode: Retract");
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.mMode == 2) {
            this.isPickingPipes = true;
            this.workState = 2;
            return true;
        }
        if (this.tryLowerPipeState(false) == 0) {
            return true;
        }
        if (this.waitForPipes()) {
            return false;
        }
        if (this.mMode == 0) {
            long steamProduced = (long)this.mTier * 25600L * (long)this.mEfficiency / 10000L;
            long waterConsume = (steamProduced + 160L) / 160L;
            if (this.getWaterFromHatches(true) - waterConsume > 0L) {
                this.consumeFluid(GTModHandler.getDistilledWater(1L).getFluid(), waterConsume);
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)((int)steamProduced)));
                return true;
            }
            this.explodeMultiblock();
            return false;
        }
        if (this.mMode != 1) return true;
        long coolantConverted = (long)((double)((long)this.mTier * 96L) * (double)nulearHeatMod * (double)this.mEfficiency / 10000.0);
        if (this.getFluidFromHatches(FluidRegistry.getFluid((String)"ic2coolant")) - coolantConverted > 0L) {
            this.consumeFluid(FluidRegistry.getFluid((String)"ic2coolant"), coolantConverted);
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)((int)coolantConverted)));
            return true;
        }
        this.explodeMultiblock();
        return false;
    }

    private boolean consumeFluid(Fluid fluid, long ammount) {
        if (ammount > Integer.MAX_VALUE) {
            int[] tmp = new int[(int)(ammount / Integer.MAX_VALUE)];
            Arrays.fill(tmp, (int)(ammount / Integer.MAX_VALUE));
            block0: for (int i = 0; i < tmp.length; ++i) {
                for (MTEHatchInput ih : this.mInputHatches) {
                    if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GTModHandler.getDistilledWater(1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                        int n = i;
                        tmp[n] = tmp[n] - ih.drain((int)((int)ammount), (boolean)true).amount;
                    }
                    if (tmp[i] > 0) continue;
                    continue block0;
                }
            }
            return tmp[tmp.length - 1] <= 0;
        }
        long tmp = ammount;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GTModHandler.getDistilledWater(1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                tmp -= (long)ih.drain((int)((int)ammount), (boolean)true).amount;
            }
            if (tmp > 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? -60 : -1 * Math.toIntExact(GTValues.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
    }
}

