/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.base.Supplier;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.calc.Calculator;
import openmods.calc.Environment;
import openmods.calc.ExprType;
import openmods.calc.SingleExprEvaluator;
import openmods.calc.types.fp.DoubleCalculatorFactory;
import openmods.config.properties.ConfigurationChange;
import openmods.entity.PlayerDamageEvent;
import openmods.utils.EnchantmentUtils;

public class LastStandEnchantmentsHandler {
    private static final String VAR_ENCH_LEVEL = "ench";
    private static final String VAR_PLAYER_XP = "xp";
    private static final String VAR_PLAYER_HP = "hp";
    private static final String VAR_DAMAGE = "dmg";
    private final SingleExprEvaluator<Double, ExprType> reductionCalculator = SingleExprEvaluator.create((Calculator)DoubleCalculatorFactory.createDefault());

    public LastStandEnchantmentsHandler() {
        this.updateReductionFormula();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigurationChange.Post evt) {
        if (evt.check("features", "lastStandFormula")) {
            this.updateReductionFormula();
        }
    }

    private void updateReductionFormula() {
        this.reductionCalculator.setExpr((Object)ExprType.INFIX, Config.lastStandEnchantmentFormula);
    }

    @SubscribeEvent
    public void onHurt(final PlayerDamageEvent e) {
        float xpRequired;
        int xpAvailable;
        float playerHealth;
        float healthAvailable;
        final int enchantmentLevels = LastStandEnchantmentsHandler.countLastStandEnchantmentLevels(e.player);
        if (enchantmentLevels > 0 && (healthAvailable = (playerHealth = e.player.func_110143_aJ()) - e.amount) < 1.0f && (float)(xpAvailable = EnchantmentUtils.getPlayerXP((EntityPlayer)e.player)) >= (xpRequired = ((Double)this.reductionCalculator.evaluate((SingleExprEvaluator.EnvironmentConfigurator)new SingleExprEvaluator.EnvironmentConfigurator<Double>(){

            public void accept(Environment<Double> env) {
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_ENCH_LEVEL, (Object)enchantmentLevels);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_PLAYER_XP, (Object)xpAvailable);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_PLAYER_HP, (Object)playerHealth);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_DAMAGE, (Object)e.amount);
            }
        }, (Supplier)new Supplier<Double>(){

            public Double get() {
                float xpRequired = 1.0f - healthAvailable;
                xpRequired *= 50.0f;
                xpRequired /= (float)enchantmentLevels;
                xpRequired = Math.max(1.0f, xpRequired);
                return xpRequired;
            }
        })).floatValue())) {
            e.player.func_70606_j(1.0f);
            EnchantmentUtils.addPlayerXP((EntityPlayer)e.player, (int)(-((int)xpRequired)));
            e.amount = 0.0f;
            e.setCanceled(true);
        }
    }

    public static int countLastStandEnchantmentLevels(EntityPlayer player) {
        if (player != null) {
            int count = 0;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                Map enchantments;
                Integer ench;
                if (stack == null || (ench = (Integer)(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).get(OpenBlocks.Enchantments.lastStand.field_77352_x)) == null) continue;
                count += ench.intValue();
            }
            return count;
        }
        return 0;
    }
}

