/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import stevesaddons.helpers.AEHelper;
import stevesaddons.reference.Null;
import stevesaddons.tileentities.TileEntityAENode;
import vswe.stevesfactory.components.SlotStackInventoryHolder;

public class AEItemBufferElement
extends SlotStackInventoryHolder {
    private IAEItemStack item;
    private TileEntityAENode inventory;
    private int sizeLeft;

    public AEItemBufferElement(IAEItemStack item, TileEntityAENode node) {
        super(Null.NULL_STACK, null, 0);
        this.item = item;
        this.inventory = node;
        this.sizeLeft = (int)item.getStackSize();
    }

    public ItemStack getItemStack() {
        return this.item.getItemStack();
    }

    public IInventory getInventory() {
        return Null.NULL_INVENTORY;
    }

    public int getSlot() {
        return 0;
    }

    public void remove() {
    }

    public void onUpdate() {
    }

    public int getSizeLeft() {
        return (int)Math.min(this.item.getStackSize(), (long)this.sizeLeft);
    }

    public void reduceAmount(int val) {
        AEHelper.extract(this.inventory.getNode(), (IAEItemStack)this.item.copy().setStackSize((long)val), (IActionHost)this.inventory);
    }

    public SlotStackInventoryHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        AEItemBufferElement element = new AEItemBufferElement(this.item, this.inventory);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }
}

