/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.handler;

import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.gtnh.findit.IStackFilter;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ThaumcraftProvider
implements IStackFilter.IStackFilterProvider {
    @Override
    public IStackFilter getFilter(EntityPlayer player, TileEntity tileEntity) {
        if (!(tileEntity instanceof IAspectContainer)) {
            return null;
        }
        IAspectContainer aspectContainer = (IAspectContainer)tileEntity;
        return new AspectStackFilter(aspectContainer.getAspects());
    }

    @Override
    public IStackFilter getFilter(EntityPlayer player, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IEssentiaContainerItem)) {
            return null;
        }
        IEssentiaContainerItem containerItem = (IEssentiaContainerItem)item;
        return new AspectStackFilter(containerItem.getAspects(stack));
    }

    static class AspectStackFilter
    implements IStackFilter {
        AspectList filterAspects;

        AspectStackFilter(AspectList filterAspects) {
            this.filterAspects = filterAspects;
        }

        @Override
        public boolean matches(FindItemRequest request) {
            ItemStack stack = request.getStackToFind();
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemAspect) && !(item instanceof IEssentiaContainerItem)) {
                return false;
            }
            AspectList stackAspects = ItemAspect.getAspects((ItemStack)stack);
            if (stackAspects.size() != 1) {
                return false;
            }
            Aspect stackAspect = stackAspects.getAspects()[0];
            return this.filterAspects.getAmount(stackAspect) > 0;
        }
    }
}

