/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test;

import chylex.hee.system.logging.Log;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import chylex.hee.system.util.DragonUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraftforge.common.ForgeVersion;

public final class UnitTester {
    private static final String prefix = "[HEE-UNIT] ";
    private static final Multimap<RunTime, Method> registryPrep = HashMultimap.create();
    private static final Multimap<RunTime, Method> registryTests = HashMultimap.create();
    private static boolean isLoaded;
    private static boolean ingameTestsOnly;
    private static int menuDisplayOk;
    private static int menuDisplayFailed;

    public static void load() {
        if (!DragonUtil.checkSystemProperty("unit") && !(ingameTestsOnly = DragonUtil.checkSystemProperty("unitgame"))) {
            return;
        }
        Log.debug("[HEE-UNIT] Loading unit tests!", new Object[0]);
        try {
            String basePackage = "chylex.hee.system.test.list";
            for (ClassPath.ClassInfo clsInfo : ClassPath.from((ClassLoader)UnitTester.class.getClassLoader()).getTopLevelClassesRecursive(basePackage)) {
                Class cls = clsInfo.load();
                Constructor constr = null;
                String clsName = clsInfo.getName().substring(basePackage.length() + 1).replace('.', '/');
                try {
                    constr = cls.getConstructor(new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (constr == null) {
                    Log.error("[HEE-UNIT] Error registering unit test class $0, a no-arg constructor is required!", clsName);
                    continue;
                }
                for (Method method : cls.getMethods()) {
                    UnitTest test = method.getAnnotation(UnitTest.class);
                    if (test == null) continue;
                    if ((method.getModifiers() & 8) == 8) {
                        Log.error("[HEE-UNIT] Error registering unit test method $0.$1, the test methods cannot be static!", clsName, method.getName());
                        continue;
                    }
                    if (test.runTime() != RunTime.INGAME && !test.trigger().isEmpty()) {
                        Log.error("[HEE-UNIT] Error registering unit test method $0.$1, cannot use $2 run time with a trigger!", new Object[]{clsName, method.getName(), test.runTime()});
                        continue;
                    }
                    if (test.type() == MethodType.PREPARATION) {
                        registryPrep.put((Object)test.runTime(), (Object)method);
                    } else {
                        registryTests.put((Object)test.runTime(), (Object)method);
                    }
                    Log.debug("[HEE-UNIT] Registered a $2 method: $0.$1", clsName, method.getName(), test.type() == MethodType.PREPARATION ? "prep" : "test");
                }
            }
            isLoaded = true;
        }
        catch (IOException e) {
            Log.throwable(e, "[HEE-UNIT] Error loading unit tests!", new Object[0]);
        }
    }

    public static void trigger(RunTime time) {
        UnitTester.trigger(time, "");
    }

    public static void trigger(RunTime time, String trigger) {
        if (!isLoaded || ingameTestsOnly && time != RunTime.INGAME) {
            return;
        }
        HashSet<Method> prepList = new HashSet<Method>();
        HashSet<Method> testList = new HashSet<Method>();
        for (Method prep : registryPrep.get((Object)time)) {
            if (!trigger.equals(prep.getAnnotation(UnitTest.class).trigger())) continue;
            prepList.add(prep);
        }
        for (Method test : registryTests.get((Object)time)) {
            if (!trigger.equals(test.getAnnotation(UnitTest.class).trigger())) continue;
            testList.add(test);
        }
        if (prepList.isEmpty() && testList.isEmpty()) {
            return;
        }
        Log.debug("[HEE-UNIT] Running $0 prep method(s) and $1 unit test(s)...", prepList.size(), testList.size());
        HashMap objects = new HashMap();
        int succeeded = 0;
        int failed = 0;
        for (Method method : Iterables.concat(prepList, testList)) {
            try {
                Class<?> cls = method.getDeclaringClass();
                Object obj = objects.get(cls);
                if (obj == null) {
                    obj = cls.newInstance();
                    objects.put(cls, obj);
                }
                boolean isTest = testList.contains(method);
                try {
                    method.invoke(obj, new Object[0]);
                    if (!isTest) continue;
                    ++succeeded;
                    ++menuDisplayOk;
                }
                catch (InvocationTargetException e) {
                    if (!isTest) {
                        Log.throwable(e.getCause(), "[HEE-UNIT] Failed preparing a test!", new Object[0]);
                        continue;
                    }
                    Throwable cause = e.getCause();
                    Log.error("[HEE-UNIT] Unit test ($0.java:$2)~$1 failed: $3", cls.getSimpleName(), method.getName(), cause.getStackTrace()[1].getLineNumber(), cause.getMessage());
                    ++failed;
                    ++menuDisplayFailed;
                }
            }
            catch (Exception e) {
                Log.throwable(e, "[HEE-UNIT] Error running a unit test!", new Object[0]);
            }
        }
        if (time == RunTime.INGAME) {
            Log.reportedDebug("[HEE-UNIT] Finished unit tests: $0 succeeded, $1 failed.", succeeded, failed);
        } else {
            Log.debug("[HEE-UNIT] Finished unit tests: $0 succeeded, $1 failed.", succeeded, failed);
        }
    }

    public static void finalizeEventTests() throws Throwable {
        if (!isLoaded) {
            return;
        }
        ImmutableList.Builder unitDataList = ImmutableList.builder();
        unitDataList.add((Object)"[Hardcore Ender Expansion - test mode]");
        if (ingameTestsOnly) {
            unitDataList.add((Object)"Event tests: none");
        } else {
            unitDataList.add((Object)("Event tests: " + menuDisplayOk + " succeeded, " + menuDisplayFailed + " failed"));
        }
        Field field = FMLCommonHandler.class.getDeclaredField("brandings");
        field.setAccessible(true);
        field.set(FMLCommonHandler.instance(), unitDataList.build());
        field = FMLCommonHandler.class.getDeclaredField("brandingsNoMC");
        field.setAccessible(true);
        field.set(FMLCommonHandler.instance(), unitDataList.build());
        field = ForgeVersion.class.getDeclaredField("status");
        field.setAccessible(true);
        field.set(null, ForgeVersion.Status.UP_TO_DATE);
    }

    private UnitTester() {
    }
}

