/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFileHandler {
    protected final Logger logger = LogManager.getLogger();
    protected File worldDir = null;
    protected File backpackDir = null;
    protected File playerDir = null;
    private final HashMap<File, NBTTagCompound> cachedFiles = new HashMap();

    public void init() {
        this.worldDir = DimensionManager.getCurrentSaveRootDirectory();
        this.backpackDir = new File(this.worldDir, "backpacks/backpacks");
        if (!this.backpackDir.exists()) {
            this.backpackDir.mkdirs();
        }
        this.playerDir = new File(this.worldDir, "backpacks/player");
        if (!this.playerDir.exists()) {
            this.playerDir.mkdirs();
        }
    }

    public NBTTagCompound loadBackpack(String UUID2) {
        if (!this.backpackSaveExists(UUID2)) {
            return new NBTTagCompound();
        }
        return this.load(this.backpackDir, UUID2);
    }

    public void saveBackpack(NBTTagCompound data, String UUID2) {
        this.save(data, this.backpackDir, UUID2);
    }

    public void deleteBackpack(String UUID2) {
        this.delete(this.backpackDir, UUID2);
    }

    public NBTTagCompound loadPlayer(String UUID2) {
        if (!this.playerSaveExists(UUID2)) {
            return new NBTTagCompound();
        }
        return this.load(this.playerDir, UUID2);
    }

    public void savePlayer(NBTTagCompound data, String UUID2) {
        this.save(data, this.playerDir, UUID2);
    }

    public boolean backpackSaveExists(String UUID2) {
        File f = new File(this.backpackDir, UUID2 + ".dat");
        if (this.cachedFiles.containsKey(f)) {
            return true;
        }
        return f.exists();
    }

    public boolean playerSaveExists(String UUID2) {
        File f = new File(this.playerDir, UUID2 + ".dat");
        if (this.cachedFiles.containsKey(f)) {
            return true;
        }
        return f.exists();
    }

    public NBTTagCompound load(File directory, String fileName) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        File file = new File(directory, fileName + ".dat");
        if (this.cachedFiles.containsKey(file)) {
            return (NBTTagCompound)this.cachedFiles.get(file).func_74737_b();
        }
        if (file.exists()) {
            try {
                nbtTagCompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                this.cachedFiles.put(file, (NBTTagCompound)nbtTagCompound.func_74737_b());
                return nbtTagCompound;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        this.logger.info("[Backpack] Couldn't load data. Using fallback file.");
        file = new File(directory, fileName + ".dat_old");
        if (file.exists()) {
            try {
                nbtTagCompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                this.cachedFiles.put(file, (NBTTagCompound)nbtTagCompound.func_74737_b());
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                this.logger.warn("[Backpack] Couldn't load data at all.");
            }
        }
        return nbtTagCompound;
    }

    public void save(NBTTagCompound data, File directory, String fileName) {
        File fileNew = new File(directory, fileName + ".dat_new");
        File fileOld = new File(directory, fileName + ".dat_old");
        File file = new File(directory, fileName + ".dat");
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(fileNew));
            if (fileOld.exists()) {
                fileOld.delete();
            }
            file.renameTo(fileOld);
            if (file.exists()) {
                file.delete();
            }
            fileNew.renameTo(file);
            if (fileNew.exists()) {
                fileNew.delete();
            }
            this.cachedFiles.put(file, (NBTTagCompound)data.func_74737_b());
        }
        catch (IOException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            this.logger.warn("[Backpack] Couldn't save data.");
        }
    }

    public void delete(File directory, String fileName) {
        File fileNew = new File(directory, fileName + ".dat_new");
        File fileOld = new File(directory, fileName + ".dat_old");
        File file = new File(directory, fileName + ".dat");
        if (fileOld.exists()) {
            fileOld.delete();
        }
        if (file.exists()) {
            file.delete();
        }
        if (fileNew.exists()) {
            fileNew.delete();
        }
        this.cachedFiles.remove(file);
    }
}

