/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.handler.MinecraftForgeEventHandler;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import com.kuba6000.mobsinfo.mixin.DraconicEvolution.MinecraftForgeEventHandlerAccessor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class DraconicEvolution
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        if (recipe.entity instanceof EntityDragon || k.equals("HardcoreEnderExpansion.Dragon")) {
            MobDrop drop = new MobDrop(new ItemStack((Item)ModItems.dragonHeart, recipe.entity instanceof EntityCustomDragon ? 2 : 1), MobDrop.DropType.Normal, 10000, null, null, false, false);
            drops.add(drop);
            MobDrop drop2 = new MobDrop(new ItemStack((Item)ModItems.draconiumDust), MobDrop.DropType.Normal, (int)(MobDrop.getChanceBasedOnFromTo(30, 59) * 10000.0), null, null, false, false);
            drop2.clampChance();
            drops.add(drop2);
        }
        if (!((MinecraftForgeEventHandlerAccessor)new MinecraftForgeEventHandler()).callIsValidEntity((EntityLivingBase)recipe.entity)) {
            return;
        }
        ItemStack soul = new ItemStack((Item)ModItems.mobSoul);
        soul.field_77990_d = new NBTTagCompound();
        soul.field_77990_d.func_74778_a("Name", k.equals("witherSkeleton") ? "Skeleton" : k);
        if (recipe.entity instanceof EntitySkeleton) {
            soul.field_77990_d.func_74768_a("SkeletonType", ((EntitySkeleton)recipe.entity).func_82202_m());
        }
        MobDrop drop = new MobDrop(soul, MobDrop.DropType.Normal, 0, null, null, false, false);
        drop.variableChance = true;
        double baseChance = 1.0 / (double)(recipe.entity instanceof EntityAnimal ? ConfigHandler.passiveSoulDropChance : ConfigHandler.soulDropChance) * 100.0;
        drop.chanceModifiers.add(new DraconicEvolutionSoulChanceModifier(baseChance));
        drops.add(drop);
    }

    private static class DraconicEvolutionSoulChanceModifier
    implements IChanceModifier {
        double baseChance;

        DraconicEvolutionSoulChanceModifier() {
        }

        DraconicEvolutionSoulChanceModifier(double baseChance) {
            this.baseChance = baseChance;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyTooltip(List<String> currentTooltip) {
            currentTooltip.addAll(Arrays.asList(Translations.VARIABLE_CHANCE.get() + ":", Translations.DRACONIC_EVOLUTION_MOB_SOUL.get(), Translations.DRACONIC_EVOLUTION_MOB_SOUL_1.get(), Translations.DRACONIC_EVOLUTION_MOB_SOUL_2.get(0.0, this.baseChance * 1.0, this.baseChance * 2.0, this.baseChance * 3.0, this.baseChance * 4.0, this.baseChance * 5.0), Translations.DRACONIC_EVOLUTION_MOB_SOUL_3.get(this.baseChance * 1.0, this.baseChance * 2.0, this.baseChance * 3.0, this.baseChance * 4.0, this.baseChance * 5.0, this.baseChance * 6.0), Translations.DRACONIC_EVOLUTION_MOB_SOUL_4.get(this.baseChance * 2.0, this.baseChance * 3.0, this.baseChance * 4.0, this.baseChance * 5.0, this.baseChance * 6.0, this.baseChance * 7.0), Translations.DRACONIC_EVOLUTION_MOB_SOUL_5.get(this.baseChance * 3.0, this.baseChance * 4.0, this.baseChance * 5.0, this.baseChance * 6.0, this.baseChance * 7.0, this.baseChance * 8.0)));
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return 0.0;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeDouble(this.baseChance);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.baseChance = byteBuf.readDouble();
        }
    }
}

