/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;

public class RotatedDrawable
implements IDrawable {
    private final IDrawable drawable;
    private float rotation;

    public RotatedDrawable(IDrawable drawable) {
        this.drawable = drawable;
    }

    public RotatedDrawable setRotationDegree(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public RotatedDrawable setRotationRadian(float rotation) {
        return this.setRotationDegree(57.295776f * rotation);
    }

    public RotatedDrawable setRotationRadian(double rotation) {
        return this.setRotationRadian((float)rotation);
    }

    @Override
    public void applyThemeColor(int color) {
        this.drawable.applyThemeColor(color);
    }

    @Override
    public void draw(float x, float y, float width, float height, float partialTicks) {
        GlStateManager.pushMatrix();
        this.drawable.rotate(this.rotation, width, height);
        this.drawable.draw(x, y, width, height, partialTicks);
        GlStateManager.popMatrix();
    }
}

