/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.client;

import biomesoplenty.common.eventhandler.client.gui.WorldTypeMessageEventHandler;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.client.ClientTicker;
import com.mitchej123.hodgepodge.client.DebugScreenHandler;
import com.mitchej123.hodgepodge.client.handlers.ClientKeyListener;
import com.mitchej123.hodgepodge.config.DebugConfig;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.util.ManagedEnum;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import java.util.Collections;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;

public class HodgepodgeClient {
    public static final ManagedEnum<AnimationMode> animationsMode = new ManagedEnum<AnimationMode>(AnimationMode.VISIBLE_ONLY);
    public static final ManagedEnum<RenderDebugMode> renderDebugMode = new ManagedEnum<RenderDebugMode>(RenderDebugMode.REDUCED);

    public static void postInit() {
        if (DebugConfig.renderDebug) {
            renderDebugMode.set(DebugConfig.renderDebugMode);
        } else {
            renderDebugMode.set(RenderDebugMode.OFF);
        }
        if (TweaksConfig.enableDefaultLanPort && (TweaksConfig.defaultLanPort < 0 || TweaksConfig.defaultLanPort > 65535)) {
            Common.log.error(String.format("Default LAN port number must be in range of 0-65535, but %s was given. Defaulting to 0.", TweaksConfig.defaultLanPort));
            TweaksConfig.defaultLanPort = 0;
        }
        FMLCommonHandler.instance().bus().register((Object)ClientTicker.INSTANCE);
        ClientRegistry.registerKeyBinding((KeyBinding)ClientKeyListener.FastBlockPlacingKey);
        if (TweaksConfig.addSystemInfo) {
            MinecraftForge.EVENT_BUS.register((Object)DebugScreenHandler.INSTANCE);
        }
        if (FixesConfig.speedupAnimations) {
            FMLCommonHandler.instance().bus().register((Object)new ClientKeyListener());
        }
        if (Compat.isIC2CropPluginPresent()) {
            ModMetadata meta = ((ModContainer)Loader.instance().getIndexedModList().get("Ic2Nei")).getMetadata();
            meta.authorList = Collections.singletonList("Speiger");
            meta.description = "This IC2 Addon allows you to simulate the CropBreeding.";
            meta.autogenerated = false;
        }
        if (Compat.isBiomesOPlentyPresent() && (Compat.isDreamcraftPresent() || FixesConfig.removeBOPWarning)) {
            MinecraftForge.EVENT_BUS.unregister((Object)WorldTypeMessageEventHandler.instance);
        }
    }

    public static enum RenderDebugMode {
        OFF,
        REDUCED,
        FULL;

    }

    public static enum AnimationMode {
        NONE,
        VISIBLE_ONLY,
        ALL;

    }
}

