/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.CollapsibleItems;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemSorter;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.ThreadOperationTimer;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemList {
    public static volatile List<ItemStack> items = new ArrayList<ItemStack>();
    public static volatile ListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
    public static final List<ItemFilter.ItemFilterProvider> itemFilterers = new LinkedList<ItemFilter.ItemFilterProvider>();
    public static final List<ItemsLoadedCallback> loadCallbacks = new LinkedList<ItemsLoadedCallback>();
    public static final CollapsibleItems collapsibleItems = new CollapsibleItems();
    private static final HashSet<Item> erroredItems = new HashSet();
    private static final HashSet<String> stackTraces = new HashSet();
    private static final HashMap<ItemStack, Integer> ordering = new HashMap();
    public static boolean loadFinished;
    public static final RestartableTask loadItems;
    public static ForkJoinPool forkJoinPool;
    public static final RestartableTask updateFilter;

    public static boolean itemMatchesAll(ItemStack item, List<ItemFilter> filters) {
        for (ItemFilter filter : filters) {
            try {
                if (filter == null || filter.matches(item)) continue;
                return false;
            }
            catch (Exception e) {
                NEIClientConfig.logger.error("Exception filtering " + item + " with " + filter, (Throwable)e);
            }
        }
        return true;
    }

    @Deprecated
    public static boolean itemMatches(ItemStack item) {
        return ItemList.getItemListFilter().matches(item);
    }

    public static ItemFilter getItemListFilter() {
        return new AllMultiItemFilter(ItemList.getItemFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemFilter> getItemFilters() {
        LinkedList<ItemFilter> filters = new LinkedList<ItemFilter>();
        List<ItemFilter.ItemFilterProvider> list = itemFilterers;
        synchronized (list) {
            for (ItemFilter.ItemFilterProvider p : itemFilterers) {
                filters.add(p.getFilter());
            }
        }
        return filters;
    }

    @Deprecated
    public static void updateFilter() {
        updateFilter.restart();
    }

    @Deprecated
    public static void loadItems() {
        loadItems.restart();
    }

    static {
        loadItems = new RestartableTask("NEI Item Loading"){

            private void damageSearch(Item item, List<ItemStack> permutations) {
                HashSet<String> damageIconSet = new HashSet<String>();
                for (int damage = 0; damage < 16; ++damage) {
                    try {
                        ItemStack itemstack = new ItemStack(item, 1, damage);
                        IIcon icon = item.func_77650_f(itemstack);
                        String name = this.getTooltip(itemstack);
                        String s = name + "@" + (icon == null ? 0 : icon.hashCode());
                        if (damageIconSet.contains(s)) continue;
                        damageIconSet.add(s);
                        permutations.add(itemstack);
                        continue;
                    }
                    catch (ThreadOperationTimer.TimeoutException t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        NEIServerUtils.logOnce(t, stackTraces, "Ommiting " + item + ":" + damage + " " + item.getClass().getSimpleName(), item.toString());
                    }
                }
            }

            private String getTooltip(ItemStack stack) {
                try {
                    return String.join((CharSequence)"\n", stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false));
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            private void updateOrdering(List<ItemStack> items) {
                ordering.clear();
                ItemSorter.sort(items);
                if (!collapsibleItems.isEmpty()) {
                    HashMap<Integer, Integer> groups = new HashMap<Integer, Integer>();
                    int orderIndex = 0;
                    for (ItemStack stack : items) {
                        int groupIndex = collapsibleItems.getGroupIndex(stack);
                        if (groupIndex == -1) {
                            ordering.put(stack, orderIndex++);
                            continue;
                        }
                        if (!groups.containsKey(groupIndex)) {
                            groups.put(groupIndex, orderIndex++);
                        }
                        ordering.put(stack, (Integer)groups.get(groupIndex));
                    }
                } else {
                    int orderIndex = 0;
                    for (ItemStack stack : items) {
                        ordering.put(stack, orderIndex++);
                    }
                }
            }

            @Override
            public void execute() {
                ThreadOperationTimer timer = this.getTimer(NEIClientConfig.getItemLoadingTimeout());
                LayoutManager.itemsLoaded = true;
                loadFinished = false;
                LinkedList<ItemStack> items = new LinkedList<ItemStack>();
                List<Object> permutations = new LinkedList<ItemStack>();
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                timer.setLimit(NEIClientConfig.getItemLoadingTimeout());
                for (Item item : Item.field_150901_e) {
                    if (this.interrupted()) {
                        return;
                    }
                    if (item == null || erroredItems.contains(item)) continue;
                    try {
                        timer.reset(item);
                        permutations.clear();
                        permutations.addAll(ItemInfo.itemOverrides.get((Object)item));
                        if (permutations.isEmpty()) {
                            item.func_150895_a(item, null, permutations);
                        }
                        if (permutations.isEmpty()) {
                            this.damageSearch(item, permutations);
                        }
                        permutations.addAll(ItemInfo.itemVariants.get((Object)item));
                        timer.reset();
                        permutations = permutations.stream().filter(stack -> !ItemInfo.isHidden(stack)).collect(Collectors.toCollection(ArrayList::new));
                        items.addAll(permutations);
                        itemMap.putAll((Object)item, permutations);
                    }
                    catch (Throwable t) {
                        NEIServerConfig.logger.error("Removing item: " + item + " from list.", t);
                        erroredItems.add(item);
                    }
                }
                if (this.interrupted()) {
                    return;
                }
                ItemList.items = items;
                ItemList.itemMap = itemMap;
                for (ItemsLoadedCallback callback : loadCallbacks) {
                    callback.itemsLoaded();
                }
                if (this.interrupted()) {
                    return;
                }
                collapsibleItems.updateCache(items);
                this.updateOrdering(items);
                loadFinished = true;
                updateFilter.restart();
            }
        };
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            private int workerId;

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("NEI-worker-thread-" + this.workerId++);
                return worker;
            }
        };
        int poolSize = Runtime.getRuntime().availableProcessors() * 2 / 3;
        if (poolSize < 1) {
            poolSize = 1;
        }
        forkJoinPool = new ForkJoinPool(poolSize, factory, null, false);
        updateFilter = new RestartableTask("NEI Item Filtering"){

            private int compare(ItemStack o1, ItemStack o2) {
                return Integer.compare((Integer)ordering.get(o1), (Integer)ordering.get(o2));
            }

            @Override
            public void execute() {
                ArrayList filtered;
                if (!loadFinished) {
                    return;
                }
                ItemFilter filter = ItemList.getItemListFilter();
                try {
                    filtered = (ArrayList)((ForkJoinTask)forkJoinPool.submit(() -> items.parallelStream().filter(filter::matches).collect(Collectors.toCollection(ArrayList::new)))).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    filtered = new ArrayList();
                    e.printStackTrace();
                    this.stop();
                }
                if (this.interrupted()) {
                    return;
                }
                filtered.sort(this::compare);
                if (this.interrupted()) {
                    return;
                }
                ItemPanel.updateItemList(filtered);
            }
        };
    }

    public static class AllMultiItemFilter
    implements ItemFilter {
        public List<ItemFilter> filters;

        public AllMultiItemFilter(List<ItemFilter> filters) {
            this.filters = filters;
        }

        public AllMultiItemFilter(ItemFilter ... filters) {
            this(new LinkedList<ItemFilter>(Arrays.asList(filters)));
        }

        public AllMultiItemFilter() {
            this(new LinkedList<ItemFilter>());
        }

        @Override
        public boolean matches(ItemStack item) {
            for (ItemFilter filter : this.filters) {
                try {
                    if (filter == null || filter.matches(item)) continue;
                    return false;
                }
                catch (Exception e) {
                    NEIClientConfig.logger.error("Exception filtering " + item + " with " + filter, (Throwable)e);
                }
            }
            return true;
        }
    }

    public static interface ItemsLoadedCallback {
        public void itemsLoaded();
    }

    public static class AnyMultiItemFilter
    implements ItemFilter {
        public List<ItemFilter> filters;

        public AnyMultiItemFilter(List<ItemFilter> filters) {
            this.filters = filters;
        }

        public AnyMultiItemFilter() {
            this(new LinkedList<ItemFilter>());
        }

        @Override
        public boolean matches(ItemStack item) {
            for (ItemFilter filter : this.filters) {
                try {
                    if (filter == null || !filter.matches(item)) continue;
                    return true;
                }
                catch (Exception e) {
                    NEIClientConfig.logger.error("Exception filtering " + item + " with " + filter, (Throwable)e);
                }
            }
            return false;
        }
    }

    public static class PatternItemFilter
    implements ItemFilter {
        public Pattern pattern;

        public PatternItemFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(ItemStack item) {
            String displayName = EnumChatFormatting.func_110646_a((String)item.func_82833_r());
            if (!displayName.isEmpty() && this.pattern.matcher(displayName).find()) {
                return true;
            }
            if (item.func_82837_s()) {
                displayName = EnumChatFormatting.func_110646_a((String)item.func_77973_b().func_77653_i(item));
                return !displayName.isEmpty() && this.pattern.matcher(displayName).find();
            }
            return false;
        }
    }

    public static class NegatedItemFilter
    implements ItemFilter {
        public ItemFilter filter;

        public NegatedItemFilter(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.filter == null || !this.filter.matches(item);
        }
    }

    public static class NothingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return false;
        }
    }

    public static class EverythingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return true;
        }
    }
}

