/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.core.item.ItemMisc;
import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.lumbermill.Lumbermill;
import net.minecraft.item.ItemStack;

public class LumbermillComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    public LumbermillComponentLogic(Machine machine) {
        super(machine, 900, 30);
    }

    @Override
    public ErrorState canWork() {
        ItemStack currentPlank;
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("extratrees.machine.lumbermill.error.noWood"), 0);
        }
        ItemStack result = Lumbermill.getPlankProduct(this.getUtil().getStack(0));
        if (!(this.getUtil().isSlotEmpty(1) || result == null || result.func_77969_a(currentPlank = this.getUtil().getStack(1)) && result.field_77994_a + currentPlank.field_77994_a <= currentPlank.func_77976_d())) {
            return new ErrorState.NoSpace(I18N.localise("extratrees.machine.lumbermill.error.noRoom"), 1);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().liquidInTank(0, 5)) {
            return new ErrorState.InsufficientLiquid(I18N.localise("extratrees.machine.lumbermill.error.noWater"), 0);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        ItemStack result = Lumbermill.getPlankProduct(this.getUtil().getStack(0));
        if (result == null) {
            return;
        }
        this.getUtil().addStack(1, result);
        this.getUtil().addStack(3, ((ItemMisc)ExtraTrees.itemMisc).getStack(ExtraTreeItems.Sawdust, 1));
        this.getUtil().addStack(2, ((ItemMisc)ExtraTrees.itemMisc).getStack(ExtraTreeItems.Bark, 1));
        this.getUtil().decreaseStack(0, 1);
    }

    @Override
    protected void onTickTask() {
        this.getUtil().drainTank(0, 10);
    }
}

