/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable.model;

import com.github.weisj.darklaf.components.treetable.model.DelegatingListSelectionModel;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class DefaultTreeTableSelectionModel
extends DefaultTreeSelectionModel
implements DelegatingListSelectionModel {
    private final JTree tree;
    private final ListSelectionModel bridgeModel;

    public DefaultTreeTableSelectionModel(JTree tree) {
        this.tree = tree;
        this.bridgeModel = new TreeTableListSelectionModel();
    }

    @Override
    public ListSelectionModel getListDelegate() {
        return this.bridgeModel;
    }

    protected class TreeTableListSelectionModel
    implements DelegatingListSelectionModel {
        protected TreeTableListSelectionModel() {
        }

        @Override
        public ListSelectionModel getListDelegate() {
            return DefaultTreeTableSelectionModel.this.listSelectionModel;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            DefaultTreeTableSelectionModel.this.setSelectionPaths(this.getTreePaths(index0, index1));
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            DefaultTreeTableSelectionModel.this.addSelectionPaths(this.getTreePaths(index0, index1));
        }

        protected TreePath[] getTreePaths(int index0, int index1) {
            int start = Math.min(index0, index1);
            int end = Math.max(index0, index1);
            TreePath[] paths = new TreePath[end - start + 1];
            for (int i = start; i <= end; ++i) {
                paths[i - start] = DefaultTreeTableSelectionModel.this.tree.getPathForRow(i);
            }
            return paths;
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            DefaultTreeTableSelectionModel.this.removeSelectionPaths(this.getTreePaths(index0, index1));
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            DefaultTreeTableSelectionModel.this.tree.setLeadSelectionPath(DefaultTreeTableSelectionModel.this.tree.getPathForRow(index));
        }

        @Override
        public int getLeadSelectionIndex() {
            return DefaultTreeTableSelectionModel.this.getLeadSelectionRow();
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            DefaultTreeTableSelectionModel.this.tree.setAnchorSelectionPath(DefaultTreeTableSelectionModel.this.tree.getPathForRow(index));
        }

        @Override
        public int getAnchorSelectionIndex() {
            return DefaultTreeTableSelectionModel.this.tree.getRowForPath(DefaultTreeTableSelectionModel.this.tree.getAnchorSelectionPath());
        }
    }
}

