/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.tiles.TileMirror;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.IAutomagyLocationLink;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.IContainsEyes;
import tuhljin.automagy.tiles.InventoryObjectEyes;
import tuhljin.automagy.tiles.ModTileEntity;

public abstract class TileWithEyes
extends ModTileEntity
implements IContainsEyes {
    public InventoryObjectEyes eyesContainingInventory;
    protected int eyesMaxCount;
    protected int eyesMaxDistance;
    protected int eyeCount = 0;

    public TileWithEyes(String eyeInvName, int maxEyes, int maxDistance) {
        this.eyesContainingInventory = new InventoryObjectEyes(this, eyeInvName, maxEyes, maxDistance > 0);
        this.eyesMaxDistance = maxDistance;
        this.eyesMaxCount = maxEyes;
    }

    @Override
    public int getDimensionID() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    @Override
    public BlockCoord getPosition() {
        return new BlockCoord(this);
    }

    @Override
    public int getMaxDistance() {
        return this.eyesMaxDistance;
    }

    @Override
    public void onEyesInventoryChanged(int slot, ItemStack prevStack) {
    }

    public ItemStack removeEye() {
        if (this.eyeCount > 0) {
            int slot = this.eyeCount - 1;
            ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
            this.eyesContainingInventory.func_70299_a(slot, null);
            --this.eyeCount;
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public boolean insertEye(ItemStack stack) {
        if (this.eyeCount < this.eyesMaxCount) {
            this.eyesContainingInventory.func_70299_a(this.eyeCount, stack.func_77979_a(1));
            ++this.eyeCount;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean itemIsValidEye(ItemStack stack) {
        return this.eyesContainingInventory.func_94041_b(this.eyeCount, stack);
    }

    public int getEyeCount() {
        return this.eyeCount;
    }

    public boolean isEyeLinkedToPairedMirror(ItemStack stack) {
        WorldSpecificCoordinates coord;
        if (stack.func_77973_b() instanceof IAutomagyLocationLink && (coord = ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack)) != null) {
            WorldServer targetWorld = DimensionManager.getWorld((int)coord.dim);
            if (targetWorld == null) {
                return false;
            }
            TileEntity te = targetWorld.func_147438_o(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof TileMirror)) {
                return false;
            }
            TileMirror tm = (TileMirror)te;
            return tm.linked;
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.eyesContainingInventory.writeCustomNBT(nbttagcompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.eyesContainingInventory.readCustomNBT(nbttagcompound);
        this.eyeCount = 0;
        int size = this.eyesContainingInventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (this.eyesContainingInventory.func_70301_a(i) == null) continue;
            ++this.eyeCount;
        }
    }
}

