/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import tmechworks.blocks.SignalBus;
import tmechworks.blocks.logic.SignalBusLogic;

public class SignalBusRender
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_147782_a(0.375, 0.0, 0.375, 0.625, 0.2, 0.625);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_147782_a(0.375, 0.0, 0.0, 0.625, 0.2, 0.375);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_147782_a(0.375, 0.0, 0.625, 0.625, 0.2, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean didRender = false;
        if (modelId == renderID) {
            SignalBusLogic tile = (SignalBusLogic)world.func_147438_o(x, y, z);
            boolean[] placedSides = tile.placedSides();
            for (int i = 0; i < 6; ++i) {
                if (!placedSides[i]) continue;
                didRender = true;
                boolean[] connectedSides = tile.connectedSides(ForgeDirection.getOrientation((int)i));
                boolean[] corners = tile.getRenderCorners(ForgeDirection.getOrientation((int)i));
                this.renderFaceWithConnections(renderer, block, x, y, z, i, placedSides, connectedSides, corners);
            }
            if (!didRender) {
                double minX = SignalBus.BusGeometry.cable_width_min;
                double minY = SignalBus.BusGeometry.cable_low_offset;
                double minZ = SignalBus.BusGeometry.cable_width_min;
                double maxX = SignalBus.BusGeometry.cable_width_max;
                double maxY = SignalBus.BusGeometry.cable_low_height;
                double maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
            }
        }
        return true;
    }

    private void renderFaceWithConnections(RenderBlocks renderer, Block block, int x, int y, int z, int side, boolean[] placed, boolean[] connectedSides, boolean[] corners) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        boolean[] renderDir = new boolean[]{connectedSides[0] || placed[0] || corners[0], connectedSides[1] || placed[1] || corners[1], connectedSides[2] || placed[2] || corners[2], connectedSides[3] || placed[3] || corners[3], connectedSides[4] || placed[4] || corners[4], connectedSides[5] || placed[5] || corners[5]};
        switch (side) {
            case 0: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_low_offset;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_low_height;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.func_147782_a(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY += SignalBus.BusGeometry.zfight, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_low_offset;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_low_height;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    minZ = corners[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minZ;
                    maxZ = corners[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxZ;
                    renderer.func_147782_a(minX, minY, minZ, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_low_offset;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_low_height;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            case 1: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_high_offset;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_high_height;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.func_147782_a(minX, minY -= SignalBus.BusGeometry.zfight, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_high_offset;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_high_height;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    minZ = corners[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minZ;
                    maxZ = corners[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxZ;
                    renderer.func_147782_a(minX, minY, minZ, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_high_offset;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_high_height;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            case 2: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_low_offset;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_low_height;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.func_147782_a(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_low_offset;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_low_height;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_low_offset;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_low_height;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            case 3: {
                if (renderDir[ForgeDirection.WEST.ordinal()] || renderDir[ForgeDirection.EAST.ordinal()]) {
                    minX = renderDir[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_high_offset;
                    maxX = renderDir[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_high_height;
                    minX = corners[ForgeDirection.WEST.ordinal()] ? SignalBus.BusGeometry.cable_corner_min : minX;
                    maxX = corners[ForgeDirection.EAST.ordinal()] ? SignalBus.BusGeometry.cable_corner_max : maxX;
                    renderer.func_147782_a(minX, minY, minZ, SignalBus.BusGeometry.cable_width_min, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(SignalBus.BusGeometry.cable_width_max, minY, minZ, maxX, maxY, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_width_min;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_high_offset;
                    maxX = SignalBus.BusGeometry.cable_width_max;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_high_height;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_width_min;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_high_offset;
                maxX = SignalBus.BusGeometry.cable_width_max;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_high_height;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            case 4: {
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_low_offset;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_low_height;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, minY, minZ += placed[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ -= d);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_low_offset;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_low_height;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_low_offset;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_low_height;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            case 5: {
                if (renderDir[ForgeDirection.NORTH.ordinal()] || renderDir[ForgeDirection.SOUTH.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_high_offset;
                    minY = SignalBus.BusGeometry.cable_width_min;
                    minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_high_height;
                    maxY = SignalBus.BusGeometry.cable_width_max;
                    maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.SOUTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, minY, minZ += placed[ForgeDirection.NORTH.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxX, maxY, SignalBus.BusGeometry.cable_width_min);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY, SignalBus.BusGeometry.cable_width_max, maxX, maxY, maxZ -= d);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (renderDir[ForgeDirection.DOWN.ordinal()] || renderDir[ForgeDirection.UP.ordinal()]) {
                    minX = SignalBus.BusGeometry.cable_high_offset;
                    minY = renderDir[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_extend_min : SignalBus.BusGeometry.cable_width_min;
                    minZ = SignalBus.BusGeometry.cable_width_min;
                    maxX = SignalBus.BusGeometry.cable_high_height;
                    maxY = renderDir[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_extend_max : SignalBus.BusGeometry.cable_width_max;
                    maxZ = SignalBus.BusGeometry.cable_width_max;
                    double d = placed[ForgeDirection.DOWN.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0;
                    renderer.func_147782_a(minX, SignalBus.BusGeometry.cable_width_max, minZ, maxX, maxY -= placed[ForgeDirection.UP.ordinal()] ? SignalBus.BusGeometry.cable_low_height : 0.0, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                    renderer.func_147782_a(minX, minY += d, minZ, maxX, SignalBus.BusGeometry.cable_width_min, maxZ);
                    renderer.func_147784_q(block, x, y, z);
                }
                minX = SignalBus.BusGeometry.cable_high_offset;
                minY = SignalBus.BusGeometry.cable_width_min;
                minZ = SignalBus.BusGeometry.cable_width_min;
                maxX = SignalBus.BusGeometry.cable_high_height;
                maxY = SignalBus.BusGeometry.cable_width_max;
                maxZ = SignalBus.BusGeometry.cable_width_max;
                renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
                renderer.func_147784_q(block, x, y, z);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void renderStandardBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory(int model) {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

