/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import travellersgear.TravellersGear;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.ToolDisplayInfo;

public class MessagePlayerInventorySync
implements IMessage {
    int playerid;
    int[] targetedSlots;
    ItemStack[] items;

    public MessagePlayerInventorySync() {
    }

    public MessagePlayerInventorySync(EntityPlayer player) {
        int i;
        this.playerid = player.func_145782_y();
        NBTTagList list = TravellersGearAPI.getDisplayTools(player);
        this.targetedSlots = new int[list.func_74745_c()];
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.targetedSlots[i] = ToolDisplayInfo.readFromNBT((NBTTagCompound)list.func_150305_b((int)i)).slot;
        }
        this.items = new ItemStack[this.targetedSlots.length];
        for (i = 0; i < this.items.length; ++i) {
            this.items[i] = player.field_71071_by.field_70462_a[this.targetedSlots[i]];
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.playerid);
        buf.writeInt(this.targetedSlots.length);
        for (i = 0; i < this.targetedSlots.length; ++i) {
            buf.writeInt(this.targetedSlots[i]);
        }
        for (i = 0; i < this.targetedSlots.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.items[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.playerid = buf.readInt();
        int l = buf.readInt();
        this.targetedSlots = new int[l];
        for (i = 0; i < l; ++i) {
            this.targetedSlots[i] = buf.readInt();
        }
        this.items = new ItemStack[l];
        for (i = 0; i < l; ++i) {
            this.items[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessagePlayerInventorySync, IMessage> {
        public IMessage onMessage(MessagePlayerInventorySync message, MessageContext ctx) {
            World world = TravellersGear.proxy.getClientWorld();
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerid);
            if (!(player instanceof EntityPlayer)) {
                return null;
            }
            for (int i = 0; i < message.targetedSlots.length; ++i) {
                ((EntityPlayer)player).field_71071_by.field_70462_a[message.targetedSlots[i]] = message.items[i];
            }
            return null;
        }
    }
}

