/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SliderWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.modularui.IControllerWithOptionalFeatures;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import tectech.TecTech;
import tectech.thing.gui.TecTechUITextures;

public class ForgeOfGodsUI {
    public static final int RED_ARGB = -43691;
    public static final int GREEN_ARGB = -11141291;
    public static final int BLUE_ARGB = -16777046;
    public static final int GOLD_ARGB = -22016;

    public static ButtonWidget createPowerSwitchButton(IGregTechTileEntity tileEntity) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            if (tileEntity.isAllowedToWork()) {
                tileEntity.disableWorking();
            } else {
                tileEntity.enableWorking();
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (tileEntity.isAllowedToWork()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, 148).setSize(16, 16);
        button.addTooltip("Power Switch").setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    public static ButtonWidget createInputSeparationButton(IGregTechTileEntity tileEntity, IControllerWithOptionalFeatures mte, IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            mte.setInputSeparation(!mte.isInputSeparationEnabled());
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (mte.isInputSeparationEnabled()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_INPUT_SEPARATION);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(mte::isInputSeparationEnabled, mte::setInputSeparation), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.input_separation")).setTooltipShowUpDelay(5).setPos(mte.getInputSeparationButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public static ButtonWidget createBatchModeButton(IGregTechTileEntity tileEntity, IControllerWithOptionalFeatures mte, IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            mte.setBatchMode(!mte.isBatchModeEnabled());
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (mte.isBatchModeEnabled()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_BATCH_MODE);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_BATCH_MODE_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(mte::isBatchModeEnabled, mte::setBatchMode), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.batch_mode")).setTooltipShowUpDelay(5).setPos(mte.getBatchModeButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public static ButtonWidget createLockToSingleRecipeButton(IGregTechTileEntity tileEntity, IControllerWithOptionalFeatures mte, IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            mte.setRecipeLocking(!mte.isRecipeLockingEnabled());
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (mte.isRecipeLockingEnabled()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_RECIPE_LOCKED);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(mte::isRecipeLockingEnabled, mte::setRecipeLocking), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.lock_recipe")).setTooltipShowUpDelay(5).setPos(mte.getRecipeLockingButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public static ButtonWidget createStructureUpdateButton(IGregTechTileEntity tileEntity, IControllerWithOptionalFeatures mte, IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            if (mte.getStructureUpdateTime() <= -20) {
                mte.setStructureUpdateTime(1);
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (mte.getStructureUpdateTime() > -20) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_STRUCTURE_CHECK);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_STRUCTURE_CHECK_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(mte::getStructureUpdateTime, mte::setStructureUpdateTime), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.structure_update")).setTooltipShowUpDelay(5).setPos(mte.getStructureUpdateButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public static ButtonWidget createVoidExcessButton(IGregTechTileEntity tileEntity, IControllerWithOptionalFeatures mte, IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(tileEntity, "fx_click");
            Set<VoidingMode> allowed = mte.getAllowedVoidingModes();
            switch (clickData.mouseButton) {
                case 0: {
                    mte.setVoidingMode(mte.getVoidingMode().nextInCollection(allowed));
                    break;
                }
                case 1: {
                    mte.setVoidingMode(mte.getVoidingMode().previousInCollection(allowed));
                }
            }
            widget.notifyTooltipChange();
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            switch (mte.getVoidingMode()) {
                case VOID_NONE: {
                    ret.add(TecTechUITextures.OVERLAY_BUTTON_VOIDING_OFF);
                    break;
                }
                case VOID_ITEM: {
                    ret.add(TecTechUITextures.OVERLAY_BUTTON_VOIDING_ITEMS);
                    break;
                }
                case VOID_FLUID: {
                    ret.add(TecTechUITextures.OVERLAY_BUTTON_VOIDING_FLUIDS);
                    break;
                }
                case VOID_ALL: {
                    ret.add(TecTechUITextures.OVERLAY_BUTTON_VOIDING_BOTH);
                }
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> mte.getVoidingMode().ordinal(), val -> mte.setVoidingMode(VoidingMode.fromOrdinal(val))), builder).dynamicTooltip(() -> Arrays.asList(StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode"), StatCollector.func_74838_a((String)mte.getVoidingMode().getTransKey()))).setTooltipShowUpDelay(5).setPos(mte.getVoidingModeButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public static ModularWindow createGeneralInfoWindow(Supplier<Boolean> inversionGetter, Consumer<Boolean> inversionSetter) {
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int WIDTH = 300;
        int HEIGHT = 300;
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)300);
        builder.setDraggable(true);
        ((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)scrollable.widget(new TextWidget(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.introduction")).setDefaultColor(EnumChatFormatting.DARK_PURPLE).setTextAlignment(Alignment.TopCenter).setPos(7, 13).setSize(280, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.introductioninfotext")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 30).setSize(280, 50))).widget(new TextWidget(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.tableofcontents")).setDefaultColor(EnumChatFormatting.AQUA).setTextAlignment(Alignment.CenterLeft).setPos(7, 80).setSize(150, 15))).widget(new ButtonWidget().setOnClick((clickData, widget) -> scrollable.setVerticalScrollOffset(150)).setBackground(new IDrawable[]{new Text(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuel")).alignment(Alignment.CenterLeft).color(0x55FFFF)}).setPos(7, 95).setSize(150, 15))).widget(new ButtonWidget().setOnClick((clickData, widget) -> scrollable.setVerticalScrollOffset(434)).setBackground(new IDrawable[]{new Text(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.modules")).alignment(Alignment.CenterLeft).color(0x55FFFF)}).setPos(7, 110).setSize(150, 15))).widget(new ButtonWidget().setOnClick((clickData, widget) -> scrollable.setVerticalScrollOffset(1088)).setBackground(new IDrawable[]{new Text(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.upgrades")).alignment(Alignment.CenterLeft).color(0x55FFFF)}).setPos(7, 125).setSize(150, 15))).widget(new ButtonWidget().setOnClick((clickData, widget) -> scrollable.setVerticalScrollOffset(1412)).setBackground(new IDrawable[]{new Text(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestones")).alignment(Alignment.CenterLeft).color(0x55FFFF)}).setPos(7, 140).setSize(150, 15))).widget(TextWidget.dynamicText(() -> ForgeOfGodsUI.inversionInfoText((Boolean)inversionGetter.get())).setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.CenterLeft).setPos(7, 155).setSize(150, 15))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (((Boolean)inversionGetter.get()).booleanValue()) {
                scrollable.setVerticalScrollOffset(1766);
            }
        }).setPlayClickSound(inversionGetter.get().booleanValue()).setPos(7, 155).setSize(150, 15).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(inversionGetter, inversionSetter), (IWidgetBuilder)scrollable))).widget(new TextWidget(EnumChatFormatting.BOLD + "\u00a7N" + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuel")).setDefaultColor(EnumChatFormatting.DARK_PURPLE).setTextAlignment(Alignment.TopCenter).setPos(127, 160).setSize(40, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfotext")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 177).setSize(280, 250))).widget(new TextWidget(EnumChatFormatting.BOLD + "\u00a7N" + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.modules")).setDefaultColor(EnumChatFormatting.DARK_PURPLE).setTextAlignment(Alignment.TopCenter).setPos(7, 440).setSize(280, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.moduleinfotext")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 461).setSize(280, 620))).widget(new TextWidget(EnumChatFormatting.BOLD + "\u00a7N" + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.upgrades")).setDefaultColor(EnumChatFormatting.DARK_PURPLE).setTextAlignment(Alignment.TopCenter).setPos(7, 1098).setSize(280, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.upgradeinfotext")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 1115).setSize(280, 290))).widget(new TextWidget(EnumChatFormatting.BOLD + "\u00a7N" + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestones")).setDefaultColor(EnumChatFormatting.DARK_PURPLE).setTextAlignment(Alignment.TopCenter).setPos(7, 1422).setSize(280, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestoneinfotext")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 1439).setSize(280, 320))).widget(TextWidget.dynamicText(() -> ForgeOfGodsUI.inversionHeaderText((Boolean)inversionGetter.get())).setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.TopCenter).setPos(7, 1776).setSize(280, 15))).widget(TextWidget.dynamicText(() -> ForgeOfGodsUI.inversionInfoText((Boolean)inversionGetter.get())).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(7, 1793).setSize(280, 160))).widget(new TextWidget("").setPos(7, 1965).setSize(10, 10));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_GLOW_WHITE).setPos(0, 0).setSize(300, 300))).widget(scrollable.setSize(292, 292).setPos(4, 4))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(284, 4));
        return builder.build();
    }

    private static Text inversionHeaderText(boolean inversion) {
        return inversion ? new Text(EnumChatFormatting.BOLD + "\u00a7k2" + EnumChatFormatting.RESET + EnumChatFormatting.WHITE + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.inversion") + EnumChatFormatting.BOLD + "\u00a7k2") : new Text("");
    }

    private static Text inversionInfoText(boolean inversion) {
        return inversion ? new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.inversioninfotext")) : new Text("");
    }

    public static void reopenWindow(Widget widget, int windowId) {
        if (!widget.isClient()) {
            ModularUIContext ctx = widget.getContext();
            if (ctx.isWindowOpen(windowId)) {
                ctx.closeWindow(windowId);
            }
            ctx.openSyncedWindow(windowId);
        }
    }

    public static Widget createStarColorRGBMGroup(StarColorRGBM color, DoubleConsumer setter, DoubleSupplier getter) {
        MultiChildWidget widget = new MultiChildWidget();
        widget.setSize(184, 16);
        widget.addChild(new TextWidget(StatCollector.func_74838_a((String)color.title)).setDefaultColor(color.mcColor).setTextAlignment(Alignment.CenterLeft).setPos(0, 0).setSize(32, 16));
        widget.addChild(new SliderWidget().setSetter(val -> {
            int aux = (int)(val.floatValue() * 10.0f);
            setter.accept((double)aux / 10.0);
        }).setGetter(() -> Float.valueOf((float)getter.getAsDouble())).setBounds(color.lowerBound, color.upperBound).setHandleSize(new Size(4, 0)).dynamicTooltip(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(color.tooltip((float)getter.getAsDouble()));
            return ret;
        }).setUpdateTooltipEveryTick(true).setSize(118, 8).setPos(32, 4));
        Widget numberEntry = new NumericWidget().setSetter(setter).setGetter(getter).setBounds((double)color.lowerBound, (double)color.upperBound).setDefaultValue((double)color.defaultValue).setTextAlignment(Alignment.Center).setTextColor(color.muiColor).setSize(32, 16).setPos(152, 0).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD});
        if (color == StarColorRGBM.GAMMA) {
            numberEntry.addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.onlydecimals"));
            ((NumericWidget)numberEntry).setIntegerOnly(false);
        } else {
            numberEntry.addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.onlyintegers"));
        }
        return widget.addChild(numberEntry);
    }

    public static Widget createStarColorButton(String text, String tooltip, BiConsumer<Widget.ClickData, Widget> onClick) {
        MultiChildWidget widget = new MultiChildWidget();
        widget.setSize(35, 15);
        widget.addChild(new ButtonWidget().setOnClick(onClick).setSize(35, 15).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).addTooltip(StatCollector.func_74838_a((String)tooltip)).setTooltipShowUpDelay(5).setPos(0, 0));
        widget.addChild(TextWidget.localised((String)text, (Object[])new Object[0]).setTextAlignment(Alignment.Center).setPos(0, 0).setSize(35, 15));
        return widget;
    }

    public static Widget createStarColorButton(Supplier<String> text, Supplier<String> tooltip, BiConsumer<Widget.ClickData, Widget> onClick) {
        MultiChildWidget widget = new MultiChildWidget();
        widget.setSize(35, 15);
        widget.addChild(new ButtonWidget().setOnClick(onClick).setSize(35, 15).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).dynamicTooltip(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(StatCollector.func_74838_a((String)((String)tooltip.get())));
            return ret;
        }).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5).setPos(0, 0));
        widget.addChild(new DynamicTextWidget(() -> new Text(StatCollector.func_74838_a((String)((String)text.get())))).setTextAlignment(Alignment.Center).setPos(0, 0).setSize(35, 15));
        return widget;
    }

    public static enum StarColorRGBM {
        RED(EnumChatFormatting.RED, -43691, 0.0f, 255.0f, 179.0f),
        GREEN(EnumChatFormatting.GREEN, -11141291, 0.0f, 255.0f, 204.0f),
        BLUE(EnumChatFormatting.DARK_BLUE, -16777046, 0.0f, 255.0f, 255.0f),
        GAMMA(EnumChatFormatting.GOLD, -22016, 0.0f, 100.0f, 3.0f);

        private final String title = "fog.cosmetics.color." + this.name().toLowerCase();
        private final EnumChatFormatting mcColor;
        private final int muiColor;
        private final float lowerBound;
        private final float upperBound;
        private final float defaultValue;

        private StarColorRGBM(EnumChatFormatting mcColor, int muiColor, float lower, float upper, float defaultVal) {
            this.mcColor = mcColor;
            this.muiColor = muiColor;
            this.lowerBound = lower;
            this.upperBound = upper;
            this.defaultValue = defaultVal;
        }

        public String tooltip(float value) {
            if (this == GAMMA) {
                return String.format("%s%s: %.1f", this.mcColor, StatCollector.func_74838_a((String)this.title), Float.valueOf(value));
            }
            return String.format("%s%s: %d", this.mcColor, StatCollector.func_74838_a((String)this.title), (int)value);
        }
    }
}

