/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.client.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.interfaces.ITexture;
import gtPlusPlus.api.interfaces.ITexturedBlock;
import gtPlusPlus.api.objects.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CustomOreBlockRenderer
implements ISimpleBlockRenderingHandler {
    public static CustomOreBlockRenderer INSTANCE;
    public final int mRenderID;
    public double renderMinX;
    public double renderMaxX;
    public double renderMinY;
    public double renderMaxY;
    public double renderMinZ;
    public double renderMaxZ;
    public boolean lockBlockBounds;
    public boolean partialRenderBounds;
    public final Minecraft minecraftRB;
    public int uvRotateEast;
    public int uvRotateWest;
    public int uvRotateSouth;
    public int uvRotateNorth;
    public int uvRotateTop;
    public int uvRotateBottom;
    public boolean enableAO;
    public float aoLightValueScratchXYZNNN;
    public float aoLightValueScratchXYNN;
    public float aoLightValueScratchXYZNNP;
    public float aoLightValueScratchYZNN;
    public float aoLightValueScratchYZNP;
    public float aoLightValueScratchXYZPNN;
    public float aoLightValueScratchXYPN;
    public float aoLightValueScratchXYZPNP;
    public float aoLightValueScratchXYZNPN;
    public float aoLightValueScratchXYNP;
    public float aoLightValueScratchXYZNPP;
    public float aoLightValueScratchYZPN;
    public float aoLightValueScratchXYZPPN;
    public float aoLightValueScratchXYPP;
    public float aoLightValueScratchYZPP;
    public float aoLightValueScratchXYZPPP;
    public float aoLightValueScratchXZNN;
    public float aoLightValueScratchXZPN;
    public float aoLightValueScratchXZNP;
    public float aoLightValueScratchXZPP;
    public int aoBrightnessXYZNNN;
    public int aoBrightnessXYNN;
    public int aoBrightnessXYZNNP;
    public int aoBrightnessYZNN;
    public int aoBrightnessYZNP;
    public int aoBrightnessXYZPNN;
    public int aoBrightnessXYPN;
    public int aoBrightnessXYZPNP;
    public int aoBrightnessXYZNPN;
    public int aoBrightnessXYNP;
    public int aoBrightnessXYZNPP;
    public int aoBrightnessYZPN;
    public int aoBrightnessXYZPPN;
    public int aoBrightnessXYPP;
    public int aoBrightnessYZPP;
    public int aoBrightnessXYZPPP;
    public int aoBrightnessXZNN;
    public int aoBrightnessXZPN;
    public int aoBrightnessXZNP;
    public int aoBrightnessXZPP;
    public int brightnessTopLeft;
    public int brightnessBottomLeft;
    public int brightnessBottomRight;
    public int brightnessTopRight;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public IIcon overrideBlockTexture;
    IBlockAccess blockAccess;

    public CustomOreBlockRenderer() {
        this.minecraftRB = RenderBlocks.getInstance().field_147877_p;
        this.blockAccess = RenderBlocks.getInstance().field_147845_a;
        INSTANCE = this;
        this.mRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
        Logger.INFO("Registered Custom Ore Block Renderer.");
    }

    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        if (aBlock instanceof ITexturedBlock) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, new ITexture[][]{((ITexturedBlock)aBlock).getTexture(ForgeDirection.DOWN), ((ITexturedBlock)aBlock).getTexture(ForgeDirection.UP), ((ITexturedBlock)aBlock).getTexture(ForgeDirection.NORTH), ((ITexturedBlock)aBlock).getTexture(ForgeDirection.SOUTH), ((ITexturedBlock)aBlock).getTexture(ForgeDirection.WEST), ((ITexturedBlock)aBlock).getTexture(ForgeDirection.EAST)});
        }
        return false;
    }

    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer, ITexture[][] aTextures) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        int l = aBlock.func_149720_d(aWorld, aX, aY, aZ);
        float RED = (float)(l >> 16 & 0xFF) / 255.0f;
        float GREEN = (float)(l >> 8 & 0xFF) / 255.0f;
        float BLUE = (float)(l & 0xFF) / 255.0f;
        if (Minecraft.func_71379_u() && aBlock.func_149750_m() == 0) {
            if (RenderBlocks.getInstance().field_147849_o) {
                return INSTANCE.renderStandardBlockWithAmbientOcclusionPartial(aWorld, aRenderer, aTextures, aBlock, aX, aY, aZ, RED, GREEN, BLUE);
            }
            return INSTANCE.renderStandardBlockWithAmbientOcclusion(aWorld, aRenderer, aTextures, aBlock, aX, aY, aZ, RED, GREEN, BLUE);
        }
        CustomOreBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[0], true);
        CustomOreBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[1], true);
        CustomOreBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[2], true);
        CustomOreBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[3], true);
        CustomOreBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[4], true);
        CustomOreBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[5], true);
        return true;
    }

    public static void renderFaceYNeg(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[0], true);
    }

    public static void renderFaceYPos(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[1], true);
    }

    public static void renderFaceZNeg(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[2], true);
    }

    public static void renderFaceZPos(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[3], true);
    }

    public static void renderFaceXNeg(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[4], true);
    }

    public static void renderFaceXPos(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[][] aIcon) {
        CustomOreBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aIcon[5], true);
    }

    public static void renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY - 1, aZ, 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY + 1, aZ, 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX - 1, aY, aZ, 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderXNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX + 1, aY, aZ, 5)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderXPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
        CustomOreBlockRenderer.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.DOWN), true);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        CustomOreBlockRenderer.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.UP), true);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        CustomOreBlockRenderer.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.NORTH), true);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
        CustomOreBlockRenderer.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.SOUTH), true);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        CustomOreBlockRenderer.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.WEST), true);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
        CustomOreBlockRenderer.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, ((ITexturedBlock)aBlock).getTexture(ForgeDirection.EAST), true);
        Tessellator.field_78398_a.func_78381_a();
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        this.blockAccess = aWorld;
        return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }

    public void setRenderBounds(double p_147782_1_, double p_147782_3_, double p_147782_5_, double p_147782_7_, double p_147782_9_, double p_147782_11_) {
        if (!this.lockBlockBounds) {
            this.renderMinX = p_147782_1_;
            this.renderMaxX = p_147782_7_;
            this.renderMinY = p_147782_3_;
            this.renderMaxY = p_147782_9_;
            this.renderMinZ = p_147782_5_;
            this.renderMaxZ = p_147782_11_;
            this.partialRenderBounds = this.minecraftRB.field_71474_y.field_74348_k >= 2 && (this.renderMinX > 0.0 || this.renderMaxX < 1.0 || this.renderMinY > 0.0 || this.renderMaxY < 1.0 || this.renderMinZ > 0.0 || this.renderMaxZ < 1.0);
        }
    }

    public void setRenderBoundsFromBlock(Block block) {
        if (!this.lockBlockBounds) {
            this.renderMinX = block.func_149704_x();
            this.renderMaxX = block.func_149753_y();
            this.renderMinY = block.func_149665_z();
            this.renderMaxY = block.func_149669_A();
            this.renderMinZ = block.func_149706_B();
            this.renderMaxZ = block.func_149693_C();
            this.partialRenderBounds = this.minecraftRB.field_71474_y.field_74348_k >= 2 && (this.renderMinX > 0.0 || this.renderMaxX < 1.0 || this.renderMinY > 0.0 || this.renderMaxY < 1.0 || this.renderMinZ > 0.0 || this.renderMaxZ < 1.0);
        }
    }

    public void clearOverrideBlockTexture() {
        this.overrideBlockTexture = null;
    }

    public boolean hasOverrideBlockTexture() {
        return this.overrideBlockTexture != null;
    }

    public IIcon getBlockIcon(Block block, IBlockAccess access, int x, int y, int z, int side) {
        return this.getIconSafe(block.func_149673_e(access, x, y, z, side));
    }

    public IIcon getBlockIconFromSideAndMetadata(Block block, int side, int meta) {
        return this.getIconSafe(block.func_149691_a(side, meta));
    }

    public IIcon getBlockIconFromSide(Block block, int side) {
        return this.getIconSafe(block.func_149733_h(side));
    }

    public IIcon getBlockIcon(Block block) {
        return this.getIconSafe(block.func_149733_h(1));
    }

    public IIcon getIconSafe(IIcon iicon) {
        if (iicon == null) {
            iicon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return iicon;
    }

    public boolean renderStandardBlockWithAmbientOcclusion(IBlockAccess aWorld, RenderBlocks aRenderer, ITexture[][] aTextures, Block block, int xPos, int yPos, int zPos, float R, float G, float B) {
        IIcon iicon;
        float f7;
        int i1;
        boolean flag5;
        boolean flag4;
        boolean flag3;
        boolean flag2;
        this.enableAO = true;
        boolean flag = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean flag1 = true;
        int l = block.func_149677_c(this.blockAccess, xPos, yPos, zPos);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (this.getBlockIcon(block).func_94215_i().equals("grass_top")) {
            flag1 = false;
        } else if (this.hasOverrideBlockTexture()) {
            flag1 = false;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos - 1, zPos, 0)) {
            if (this.renderMinY <= 0.0) {
                --yPos;
            }
            this.aoBrightnessXYNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessYZNN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessYZNP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoLightValueScratchXYNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchYZNP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149751_l();
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXYNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXYNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXYNN;
                this.aoBrightnessXYZNNP = this.aoBrightnessXYNN;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos + 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXYPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXYPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXYPN;
                this.aoBrightnessXYZPNP = this.aoBrightnessXYPN;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos + 1);
            }
            if (this.renderMinY <= 0.0) {
                ++yPos;
            }
            i1 = l;
            if (this.renderMinY <= 0.0 || !this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            f3 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXYNN + this.aoLightValueScratchYZNP + f7) / 4.0f;
            f6 = (this.aoLightValueScratchYZNP + f7 + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXYPN) / 4.0f;
            f5 = (f7 + this.aoLightValueScratchYZNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNN) / 4.0f;
            f4 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNN + f7 + this.aoLightValueScratchYZNN) / 4.0f;
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNP, this.aoBrightnessXYNN, this.aoBrightnessYZNP, i1);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXYPN, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNN, this.aoBrightnessXYPN, this.aoBrightnessXYZPNN, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNN, this.aoBrightnessXYZNNN, this.aoBrightnessYZNN, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.5f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.5f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.5f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.5f;
                this.colorRedBottomRight = 0.5f;
                this.colorRedBottomLeft = 0.5f;
                this.colorRedTopLeft = 0.5f;
                this.colorGreenTopRight = 0.5f;
                this.colorGreenBottomRight = 0.5f;
                this.colorGreenBottomLeft = 0.5f;
                this.colorGreenTopLeft = 0.5f;
                this.colorBlueTopRight = 0.5f;
                this.colorBlueBottomRight = 0.5f;
                this.colorBlueBottomLeft = 0.5f;
                this.colorBlueTopLeft = 0.5f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            CustomOreBlockRenderer.renderFaceYNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos + 1, zPos, 1)) {
            if (this.renderMaxY >= 1.0) {
                ++yPos;
            }
            this.aoBrightnessXYNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessXYPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoBrightnessYZPN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessYZPP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoLightValueScratchXYNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchXYPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZPN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchYZPP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149751_l();
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXYNP;
                this.aoBrightnessXYZNPN = this.aoBrightnessXYNP;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos - 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXYPP;
                this.aoBrightnessXYZPPN = this.aoBrightnessXYPP;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXYNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXYNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos + 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXYPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXYPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos + 1);
            }
            if (this.renderMaxY >= 1.0) {
                --yPos;
            }
            i1 = l;
            if (this.renderMaxY >= 1.0 || !this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            f6 = (this.aoLightValueScratchXYZNPP + this.aoLightValueScratchXYNP + this.aoLightValueScratchYZPP + f7) / 4.0f;
            f3 = (this.aoLightValueScratchYZPP + f7 + this.aoLightValueScratchXYZPPP + this.aoLightValueScratchXYPP) / 4.0f;
            f4 = (f7 + this.aoLightValueScratchYZPN + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPN + f7 + this.aoLightValueScratchYZPN) / 4.0f;
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNPP, this.aoBrightnessXYNP, this.aoBrightnessYZPP, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPP, this.aoBrightnessXYZPPP, this.aoBrightnessXYPP, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPN, this.aoBrightnessXYPP, this.aoBrightnessXYZPPN, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNP, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, i1);
            this.colorRedBottomRight = this.colorRedTopRight = R;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = G;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = B;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            CustomOreBlockRenderer.renderFaceYPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos, zPos - 1, 2)) {
            if (this.renderMinZ <= 0.0) {
                --zPos;
            }
            this.aoLightValueScratchXZNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchYZPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoLightValueScratchXZPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoBrightnessXZNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessYZNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessYZPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            this.aoBrightnessXZPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos - 1, zPos);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos - 1, yPos + 1, zPos);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos + 1, yPos - 1, zPos);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos + 1, zPos);
            }
            if (this.renderMinZ <= 0.0) {
                ++zPos;
            }
            i1 = l;
            if (this.renderMinZ <= 0.0 || !this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            f3 = (this.aoLightValueScratchXZNN + this.aoLightValueScratchXYZNPN + f7 + this.aoLightValueScratchYZPN) / 4.0f;
            f4 = (f7 + this.aoLightValueScratchYZPN + this.aoLightValueScratchXZPN + this.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (this.aoLightValueScratchYZNN + f7 + this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXZPN) / 4.0f;
            f6 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXZNN + this.aoLightValueScratchYZNN + f7) / 4.0f;
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPN, this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNN, this.aoBrightnessXYZPNN, this.aoBrightnessXZPN, i1);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNN, this.aoBrightnessXZNN, this.aoBrightnessYZNN, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.8f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.8f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.8f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.8f;
                this.colorRedBottomRight = 0.8f;
                this.colorRedBottomLeft = 0.8f;
                this.colorRedTopLeft = 0.8f;
                this.colorGreenTopRight = 0.8f;
                this.colorGreenBottomRight = 0.8f;
                this.colorGreenBottomLeft = 0.8f;
                this.colorGreenTopLeft = 0.8f;
                this.colorBlueTopRight = 0.8f;
                this.colorBlueBottomRight = 0.8f;
                this.colorBlueBottomLeft = 0.8f;
                this.colorBlueTopLeft = 0.8f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 2);
            CustomOreBlockRenderer.renderFaceZNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceZNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos, zPos + 1, 3)) {
            if (this.renderMaxZ >= 1.0) {
                ++zPos;
            }
            this.aoLightValueScratchXZNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchXZPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchYZPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXZNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessXZPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoBrightnessYZNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessYZPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos - 1, zPos);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos - 1, yPos + 1, zPos);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos + 1, yPos - 1, zPos);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos + 1, zPos);
            }
            if (this.renderMaxZ >= 1.0) {
                --zPos;
            }
            i1 = l;
            if (this.renderMaxZ >= 1.0 || !this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            f3 = (this.aoLightValueScratchXZNP + this.aoLightValueScratchXYZNPP + f7 + this.aoLightValueScratchYZPP) / 4.0f;
            f6 = (f7 + this.aoLightValueScratchYZPP + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYZPPP) / 4.0f;
            f5 = (this.aoLightValueScratchYZNP + f7 + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXZPP) / 4.0f;
            f4 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXZNP + this.aoLightValueScratchYZNP + f7) / 4.0f;
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNP, this.aoBrightnessXYZNPP, this.aoBrightnessYZPP, i1);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPP, this.aoBrightnessXZPP, this.aoBrightnessXYZPPP, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, this.aoBrightnessYZNP, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.8f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.8f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.8f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.8f;
                this.colorRedBottomRight = 0.8f;
                this.colorRedBottomLeft = 0.8f;
                this.colorRedTopLeft = 0.8f;
                this.colorGreenTopRight = 0.8f;
                this.colorGreenBottomRight = 0.8f;
                this.colorGreenBottomLeft = 0.8f;
                this.colorGreenTopLeft = 0.8f;
                this.colorBlueTopRight = 0.8f;
                this.colorBlueBottomRight = 0.8f;
                this.colorBlueBottomLeft = 0.8f;
                this.colorBlueTopLeft = 0.8f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 3);
            CustomOreBlockRenderer.renderFaceZPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceZPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos - 1, yPos, zPos, 4)) {
            if (this.renderMinX <= 0.0) {
                --xPos;
            }
            this.aoLightValueScratchXYNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchXZNN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchXZNP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYNP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXYNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessXZNN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessXZNP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYNP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149751_l();
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos - 1);
            }
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos + 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos - 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos + 1);
            }
            if (this.renderMinX <= 0.0) {
                ++xPos;
            }
            i1 = l;
            if (this.renderMinX <= 0.0 || !this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            f6 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNP + f7 + this.aoLightValueScratchXZNP) / 4.0f;
            f3 = (f7 + this.aoLightValueScratchXZNP + this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPP) / 4.0f;
            f4 = (this.aoLightValueScratchXZNN + f7 + this.aoLightValueScratchXYZNPN + this.aoLightValueScratchXYNP) / 4.0f;
            f5 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXYNN + this.aoLightValueScratchXZNN + f7) / 4.0f;
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNN, this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNP, this.aoBrightnessXYNP, this.aoBrightnessXYZNPP, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessXYNP, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNN, this.aoBrightnessXYNN, this.aoBrightnessXZNN, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.6f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.6f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.6f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.6f;
                this.colorRedBottomRight = 0.6f;
                this.colorRedBottomLeft = 0.6f;
                this.colorRedTopLeft = 0.6f;
                this.colorGreenTopRight = 0.6f;
                this.colorGreenBottomRight = 0.6f;
                this.colorGreenBottomLeft = 0.6f;
                this.colorGreenTopLeft = 0.6f;
                this.colorBlueTopRight = 0.6f;
                this.colorBlueBottomRight = 0.6f;
                this.colorBlueBottomLeft = 0.6f;
                this.colorBlueTopLeft = 0.6f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 4);
            CustomOreBlockRenderer.renderFaceXNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceXNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos + 1, yPos, zPos, 5)) {
            if (this.renderMaxX >= 1.0) {
                ++xPos;
            }
            this.aoLightValueScratchXYPN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchXZPN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchXZPP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXYPN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessXZPN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessXZPP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos - 1);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos + 1);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos - 1);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos + 1);
            }
            if (this.renderMaxX >= 1.0) {
                --xPos;
            }
            i1 = l;
            if (this.renderMaxX >= 1.0 || !this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            f3 = (this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNP + f7 + this.aoLightValueScratchXZPP) / 4.0f;
            f4 = (this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXZPN + f7) / 4.0f;
            f5 = (this.aoLightValueScratchXZPN + f7 + this.aoLightValueScratchXYZPPN + this.aoLightValueScratchXYPP) / 4.0f;
            f6 = (f7 + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPP) / 4.0f;
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYPN, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, i1);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZPP, this.aoBrightnessXYPP, this.aoBrightnessXYZPPP, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, this.aoBrightnessXYPP, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZPNN, this.aoBrightnessXYPN, this.aoBrightnessXZPN, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.6f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.6f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.6f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.6f;
                this.colorRedBottomRight = 0.6f;
                this.colorRedBottomLeft = 0.6f;
                this.colorRedTopLeft = 0.6f;
                this.colorGreenTopRight = 0.6f;
                this.colorGreenBottomRight = 0.6f;
                this.colorGreenBottomLeft = 0.6f;
                this.colorGreenTopLeft = 0.6f;
                this.colorBlueTopRight = 0.6f;
                this.colorBlueBottomRight = 0.6f;
                this.colorBlueBottomLeft = 0.6f;
                this.colorBlueTopLeft = 0.6f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 5);
            CustomOreBlockRenderer.renderFaceXPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceXPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        this.enableAO = false;
        return flag;
    }

    public boolean renderStandardBlockWithAmbientOcclusionPartial(IBlockAccess aWorld, RenderBlocks aRenderer, ITexture[][] aTextures, Block block, int xPos, int yPos, int zPos, float R, float G, float B) {
        IIcon iicon;
        int i2;
        int l1;
        int k1;
        int j1;
        float f11;
        float f10;
        float f9;
        float f8;
        float f7;
        int i1;
        boolean flag5;
        boolean flag4;
        boolean flag3;
        boolean flag2;
        this.enableAO = true;
        boolean flag = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean flag1 = true;
        int l = block.func_149677_c(this.blockAccess, xPos, yPos, zPos);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (this.getBlockIcon(block).func_94215_i().equals("grass_top")) {
            flag1 = false;
        } else if (this.hasOverrideBlockTexture()) {
            flag1 = false;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos - 1, zPos, 0)) {
            if (this.renderMinY <= 0.0) {
                --yPos;
            }
            this.aoBrightnessXYNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessYZNN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessYZNP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoLightValueScratchXYNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchYZNP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149751_l();
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXYNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXYNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXYNN;
                this.aoBrightnessXYZNNP = this.aoBrightnessXYNN;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos + 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXYPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXYPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXYPN;
                this.aoBrightnessXYZPNP = this.aoBrightnessXYPN;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos + 1);
            }
            if (this.renderMinY <= 0.0) {
                ++yPos;
            }
            i1 = l;
            if (this.renderMinY <= 0.0 || !this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            f3 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXYNN + this.aoLightValueScratchYZNP + f7) / 4.0f;
            f6 = (this.aoLightValueScratchYZNP + f7 + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXYPN) / 4.0f;
            f5 = (f7 + this.aoLightValueScratchYZNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNN) / 4.0f;
            f4 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNN + f7 + this.aoLightValueScratchYZNN) / 4.0f;
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNP, this.aoBrightnessXYNN, this.aoBrightnessYZNP, i1);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXYPN, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNN, this.aoBrightnessXYPN, this.aoBrightnessXYZPNN, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNN, this.aoBrightnessXYZNNN, this.aoBrightnessYZNN, i1);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.5f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.5f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.5f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.5f;
                this.colorRedBottomRight = 0.5f;
                this.colorRedBottomLeft = 0.5f;
                this.colorRedTopLeft = 0.5f;
                this.colorGreenTopRight = 0.5f;
                this.colorGreenBottomRight = 0.5f;
                this.colorGreenBottomLeft = 0.5f;
                this.colorGreenTopLeft = 0.5f;
                this.colorBlueTopRight = 0.5f;
                this.colorBlueBottomRight = 0.5f;
                this.colorBlueBottomLeft = 0.5f;
                this.colorBlueTopLeft = 0.5f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            CustomOreBlockRenderer.renderFaceYNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos + 1, zPos, 1)) {
            if (this.renderMaxY >= 1.0) {
                ++yPos;
            }
            this.aoBrightnessXYNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessXYPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoBrightnessYZPN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessYZPP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoLightValueScratchXYNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchXYPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZPN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchYZPP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149751_l();
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXYNP;
                this.aoBrightnessXYZNPN = this.aoBrightnessXYNP;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos - 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXYPP;
                this.aoBrightnessXYZPPN = this.aoBrightnessXYPP;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos - 1);
            }
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXYNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXYNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos + 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXYPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXYPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos + 1);
            }
            if (this.renderMaxY >= 1.0) {
                --yPos;
            }
            i1 = l;
            if (this.renderMaxY >= 1.0 || !this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            f6 = (this.aoLightValueScratchXYZNPP + this.aoLightValueScratchXYNP + this.aoLightValueScratchYZPP + f7) / 4.0f;
            f3 = (this.aoLightValueScratchYZPP + f7 + this.aoLightValueScratchXYZPPP + this.aoLightValueScratchXYPP) / 4.0f;
            f4 = (f7 + this.aoLightValueScratchYZPN + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPN + f7 + this.aoLightValueScratchYZPN) / 4.0f;
            this.brightnessTopRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNPP, this.aoBrightnessXYNP, this.aoBrightnessYZPP, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPP, this.aoBrightnessXYZPPP, this.aoBrightnessXYPP, i1);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPN, this.aoBrightnessXYPP, this.aoBrightnessXYZPPN, i1);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNP, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, i1);
            this.colorRedBottomRight = this.colorRedTopRight = R;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = G;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = B;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            CustomOreBlockRenderer.renderFaceYPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos, zPos - 1, 2)) {
            if (this.renderMinZ <= 0.0) {
                --zPos;
            }
            this.aoLightValueScratchXZNN = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchYZPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoLightValueScratchXZPN = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoBrightnessXZNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessYZNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessYZPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            this.aoBrightnessXZPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos - 1, yPos - 1, zPos);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos - 1, yPos + 1, zPos);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos + 1, yPos - 1, zPos);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos + 1, yPos + 1, zPos);
            }
            if (this.renderMinZ <= 0.0) {
                ++zPos;
            }
            i1 = l;
            if (this.renderMinZ <= 0.0 || !this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            f8 = (this.aoLightValueScratchXZNN + this.aoLightValueScratchXYZNPN + f7 + this.aoLightValueScratchYZPN) / 4.0f;
            f9 = (f7 + this.aoLightValueScratchYZPN + this.aoLightValueScratchXZPN + this.aoLightValueScratchXYZPPN) / 4.0f;
            f10 = (this.aoLightValueScratchYZNN + f7 + this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXZPN) / 4.0f;
            f11 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXZNN + this.aoLightValueScratchYZNN + f7) / 4.0f;
            f3 = (float)((double)f8 * this.renderMaxY * (1.0 - this.renderMinX) + (double)f9 * this.renderMaxY * this.renderMinX + (double)f10 * (1.0 - this.renderMaxY) * this.renderMinX + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMinX));
            f4 = (float)((double)f8 * this.renderMaxY * (1.0 - this.renderMaxX) + (double)f9 * this.renderMaxY * this.renderMaxX + (double)f10 * (1.0 - this.renderMaxY) * this.renderMaxX + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMaxX));
            f5 = (float)((double)f8 * this.renderMinY * (1.0 - this.renderMaxX) + (double)f9 * this.renderMinY * this.renderMaxX + (double)f10 * (1.0 - this.renderMinY) * this.renderMaxX + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMaxX));
            f6 = (float)((double)f8 * this.renderMinY * (1.0 - this.renderMinX) + (double)f9 * this.renderMinY * this.renderMinX + (double)f10 * (1.0 - this.renderMinY) * this.renderMinX + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMinX));
            j1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, i1);
            k1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPN, this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, i1);
            l1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNN, this.aoBrightnessXYZPNN, this.aoBrightnessXZPN, i1);
            i2 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNN, this.aoBrightnessXZNN, this.aoBrightnessYZNN, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147727_a(j1, k1, l1, i2, this.renderMaxY * (1.0 - this.renderMinX), this.renderMaxY * this.renderMinX, (1.0 - this.renderMaxY) * this.renderMinX, (1.0 - this.renderMaxY) * (1.0 - this.renderMinX));
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147727_a(j1, k1, l1, i2, this.renderMaxY * (1.0 - this.renderMaxX), this.renderMaxY * this.renderMaxX, (1.0 - this.renderMaxY) * this.renderMaxX, (1.0 - this.renderMaxY) * (1.0 - this.renderMaxX));
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147727_a(j1, k1, l1, i2, this.renderMinY * (1.0 - this.renderMaxX), this.renderMinY * this.renderMaxX, (1.0 - this.renderMinY) * this.renderMaxX, (1.0 - this.renderMinY) * (1.0 - this.renderMaxX));
            this.brightnessTopRight = RenderBlocks.getInstance().func_147727_a(j1, k1, l1, i2, this.renderMinY * (1.0 - this.renderMinX), this.renderMinY * this.renderMinX, (1.0 - this.renderMinY) * this.renderMinX, (1.0 - this.renderMinY) * (1.0 - this.renderMinX));
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.8f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.8f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.8f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.8f;
                this.colorRedBottomRight = 0.8f;
                this.colorRedBottomLeft = 0.8f;
                this.colorRedTopLeft = 0.8f;
                this.colorGreenTopRight = 0.8f;
                this.colorGreenBottomRight = 0.8f;
                this.colorGreenBottomLeft = 0.8f;
                this.colorGreenTopLeft = 0.8f;
                this.colorBlueTopRight = 0.8f;
                this.colorBlueBottomRight = 0.8f;
                this.colorBlueBottomLeft = 0.8f;
                this.colorBlueTopLeft = 0.8f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 2);
            CustomOreBlockRenderer.renderFaceZNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceZNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos, yPos, zPos + 1, 3)) {
            if (this.renderMaxZ >= 1.0) {
                ++zPos;
            }
            this.aoLightValueScratchXZNP = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchXZPP = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            this.aoLightValueScratchYZNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchYZPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXZNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            this.aoBrightnessXZPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            this.aoBrightnessYZNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessYZPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos - 1, yPos - 1, zPos);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos - 1, yPos + 1, zPos);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos + 1, yPos - 1, zPos);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos + 1, yPos + 1, zPos);
            }
            if (this.renderMaxZ >= 1.0) {
                --zPos;
            }
            i1 = l;
            if (this.renderMaxZ >= 1.0 || !this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            }
            f7 = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            f8 = (this.aoLightValueScratchXZNP + this.aoLightValueScratchXYZNPP + f7 + this.aoLightValueScratchYZPP) / 4.0f;
            f9 = (f7 + this.aoLightValueScratchYZPP + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYZPPP) / 4.0f;
            f10 = (this.aoLightValueScratchYZNP + f7 + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXZPP) / 4.0f;
            f11 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXZNP + this.aoLightValueScratchYZNP + f7) / 4.0f;
            f3 = (float)((double)f8 * this.renderMaxY * (1.0 - this.renderMinX) + (double)f9 * this.renderMaxY * this.renderMinX + (double)f10 * (1.0 - this.renderMaxY) * this.renderMinX + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMinX));
            f4 = (float)((double)f8 * this.renderMinY * (1.0 - this.renderMinX) + (double)f9 * this.renderMinY * this.renderMinX + (double)f10 * (1.0 - this.renderMinY) * this.renderMinX + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMinX));
            f5 = (float)((double)f8 * this.renderMinY * (1.0 - this.renderMaxX) + (double)f9 * this.renderMinY * this.renderMaxX + (double)f10 * (1.0 - this.renderMinY) * this.renderMaxX + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMaxX));
            f6 = (float)((double)f8 * this.renderMaxY * (1.0 - this.renderMaxX) + (double)f9 * this.renderMaxY * this.renderMaxX + (double)f10 * (1.0 - this.renderMaxY) * this.renderMaxX + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMaxX));
            j1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNP, this.aoBrightnessXYZNPP, this.aoBrightnessYZPP, i1);
            k1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZPP, this.aoBrightnessXZPP, this.aoBrightnessXYZPPP, i1);
            l1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, i1);
            i2 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, this.aoBrightnessYZNP, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, this.renderMaxY * (1.0 - this.renderMinX), (1.0 - this.renderMaxY) * (1.0 - this.renderMinX), (1.0 - this.renderMaxY) * this.renderMinX, this.renderMaxY * this.renderMinX);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, this.renderMinY * (1.0 - this.renderMinX), (1.0 - this.renderMinY) * (1.0 - this.renderMinX), (1.0 - this.renderMinY) * this.renderMinX, this.renderMinY * this.renderMinX);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, this.renderMinY * (1.0 - this.renderMaxX), (1.0 - this.renderMinY) * (1.0 - this.renderMaxX), (1.0 - this.renderMinY) * this.renderMaxX, this.renderMinY * this.renderMaxX);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, this.renderMaxY * (1.0 - this.renderMaxX), (1.0 - this.renderMaxY) * (1.0 - this.renderMaxX), (1.0 - this.renderMaxY) * this.renderMaxX, this.renderMaxY * this.renderMaxX);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.8f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.8f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.8f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.8f;
                this.colorRedBottomRight = 0.8f;
                this.colorRedBottomLeft = 0.8f;
                this.colorRedTopLeft = 0.8f;
                this.colorGreenTopRight = 0.8f;
                this.colorGreenBottomRight = 0.8f;
                this.colorGreenBottomLeft = 0.8f;
                this.colorGreenTopLeft = 0.8f;
                this.colorBlueTopRight = 0.8f;
                this.colorBlueBottomRight = 0.8f;
                this.colorBlueBottomLeft = 0.8f;
                this.colorBlueTopLeft = 0.8f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 3);
            CustomOreBlockRenderer.renderFaceZPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceZPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos - 1, yPos, zPos, 4)) {
            if (this.renderMinX <= 0.0) {
                --xPos;
            }
            this.aoLightValueScratchXYNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchXZNN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchXZNP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYNP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXYNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessXZNN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessXZNP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYNP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos - 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos - 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos - 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos + 1).func_149751_l();
            if (!flag4 && !flag3) {
                this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos - 1);
            }
            if (!flag5 && !flag3) {
                this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos + 1);
            }
            if (!flag4 && !flag2) {
                this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
            } else {
                this.aoLightValueScratchXYZNPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZNPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos - 1);
            }
            if (!flag5 && !flag2) {
                this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
            } else {
                this.aoLightValueScratchXYZNPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZNPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos + 1);
            }
            if (this.renderMinX <= 0.0) {
                ++xPos;
            }
            i1 = l;
            if (this.renderMinX <= 0.0 || !this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos - 1, yPos, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos - 1, yPos, zPos).func_149685_I();
            f8 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNP + f7 + this.aoLightValueScratchXZNP) / 4.0f;
            f9 = (f7 + this.aoLightValueScratchXZNP + this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPP) / 4.0f;
            f10 = (this.aoLightValueScratchXZNN + f7 + this.aoLightValueScratchXYZNPN + this.aoLightValueScratchXYNP) / 4.0f;
            f11 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXYNN + this.aoLightValueScratchXZNN + f7) / 4.0f;
            f3 = (float)((double)f9 * this.renderMaxY * this.renderMaxZ + (double)f10 * this.renderMaxY * (1.0 - this.renderMaxZ) + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMaxZ) + (double)f8 * (1.0 - this.renderMaxY) * this.renderMaxZ);
            f4 = (float)((double)f9 * this.renderMaxY * this.renderMinZ + (double)f10 * this.renderMaxY * (1.0 - this.renderMinZ) + (double)f11 * (1.0 - this.renderMaxY) * (1.0 - this.renderMinZ) + (double)f8 * (1.0 - this.renderMaxY) * this.renderMinZ);
            f5 = (float)((double)f9 * this.renderMinY * this.renderMinZ + (double)f10 * this.renderMinY * (1.0 - this.renderMinZ) + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMinZ) + (double)f8 * (1.0 - this.renderMinY) * this.renderMinZ);
            f6 = (float)((double)f9 * this.renderMinY * this.renderMaxZ + (double)f10 * this.renderMinY * (1.0 - this.renderMaxZ) + (double)f11 * (1.0 - this.renderMinY) * (1.0 - this.renderMaxZ) + (double)f8 * (1.0 - this.renderMinY) * this.renderMaxZ);
            j1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYNN, this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, i1);
            k1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNP, this.aoBrightnessXYNP, this.aoBrightnessXYZNPP, i1);
            l1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessXYNP, i1);
            i2 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZNNN, this.aoBrightnessXYNN, this.aoBrightnessXZNN, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147727_a(k1, l1, i2, j1, this.renderMaxY * this.renderMaxZ, this.renderMaxY * (1.0 - this.renderMaxZ), (1.0 - this.renderMaxY) * (1.0 - this.renderMaxZ), (1.0 - this.renderMaxY) * this.renderMaxZ);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147727_a(k1, l1, i2, j1, this.renderMaxY * this.renderMinZ, this.renderMaxY * (1.0 - this.renderMinZ), (1.0 - this.renderMaxY) * (1.0 - this.renderMinZ), (1.0 - this.renderMaxY) * this.renderMinZ);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147727_a(k1, l1, i2, j1, this.renderMinY * this.renderMinZ, this.renderMinY * (1.0 - this.renderMinZ), (1.0 - this.renderMinY) * (1.0 - this.renderMinZ), (1.0 - this.renderMinY) * this.renderMinZ);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147727_a(k1, l1, i2, j1, this.renderMinY * this.renderMaxZ, this.renderMinY * (1.0 - this.renderMaxZ), (1.0 - this.renderMinY) * (1.0 - this.renderMaxZ), (1.0 - this.renderMinY) * this.renderMaxZ);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.6f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.6f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.6f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.6f;
                this.colorRedBottomRight = 0.6f;
                this.colorRedBottomLeft = 0.6f;
                this.colorRedTopLeft = 0.6f;
                this.colorGreenTopRight = 0.6f;
                this.colorGreenBottomRight = 0.6f;
                this.colorGreenBottomLeft = 0.6f;
                this.colorGreenTopLeft = 0.6f;
                this.colorBlueTopRight = 0.6f;
                this.colorBlueBottomRight = 0.6f;
                this.colorBlueBottomLeft = 0.6f;
                this.colorBlueTopLeft = 0.6f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 4);
            CustomOreBlockRenderer.renderFaceXNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceXNeg(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        if (RenderBlocks.getInstance().field_147837_f || block.func_149646_a(this.blockAccess, xPos + 1, yPos, zPos, 5)) {
            if (this.renderMaxX >= 1.0) {
                ++xPos;
            }
            this.aoLightValueScratchXYPN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos).func_149685_I();
            this.aoLightValueScratchXZPN = this.blockAccess.func_147439_a(xPos, yPos, zPos - 1).func_149685_I();
            this.aoLightValueScratchXZPP = this.blockAccess.func_147439_a(xPos, yPos, zPos + 1).func_149685_I();
            this.aoLightValueScratchXYPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos).func_149685_I();
            this.aoBrightnessXYPN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos);
            this.aoBrightnessXZPN = block.func_149677_c(this.blockAccess, xPos, yPos, zPos - 1);
            this.aoBrightnessXZPP = block.func_149677_c(this.blockAccess, xPos, yPos, zPos + 1);
            this.aoBrightnessXYPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos);
            flag2 = this.blockAccess.func_147439_a(xPos + 1, yPos + 1, zPos).func_149751_l();
            flag3 = this.blockAccess.func_147439_a(xPos + 1, yPos - 1, zPos).func_149751_l();
            flag4 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos + 1).func_149751_l();
            flag5 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos - 1).func_149751_l();
            if (!flag3 && !flag5) {
                this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPNN = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPNN = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos - 1);
            }
            if (!flag3 && !flag4) {
                this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPNP = this.blockAccess.func_147439_a(xPos, yPos - 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPNP = block.func_149677_c(this.blockAccess, xPos, yPos - 1, zPos + 1);
            }
            if (!flag2 && !flag5) {
                this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
            } else {
                this.aoLightValueScratchXYZPPN = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos - 1).func_149685_I();
                this.aoBrightnessXYZPPN = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos - 1);
            }
            if (!flag2 && !flag4) {
                this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
            } else {
                this.aoLightValueScratchXYZPPP = this.blockAccess.func_147439_a(xPos, yPos + 1, zPos + 1).func_149685_I();
                this.aoBrightnessXYZPPP = block.func_149677_c(this.blockAccess, xPos, yPos + 1, zPos + 1);
            }
            if (this.renderMaxX >= 1.0) {
                --xPos;
            }
            i1 = l;
            if (this.renderMaxX >= 1.0 || !this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149662_c()) {
                i1 = block.func_149677_c(this.blockAccess, xPos + 1, yPos, zPos);
            }
            f7 = this.blockAccess.func_147439_a(xPos + 1, yPos, zPos).func_149685_I();
            f8 = (this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNP + f7 + this.aoLightValueScratchXZPP) / 4.0f;
            f9 = (this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXZPN + f7) / 4.0f;
            f10 = (this.aoLightValueScratchXZPN + f7 + this.aoLightValueScratchXYZPPN + this.aoLightValueScratchXYPP) / 4.0f;
            f11 = (f7 + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPP) / 4.0f;
            f3 = (float)((double)f8 * (1.0 - this.renderMinY) * this.renderMaxZ + (double)f9 * (1.0 - this.renderMinY) * (1.0 - this.renderMaxZ) + (double)f10 * this.renderMinY * (1.0 - this.renderMaxZ) + (double)f11 * this.renderMinY * this.renderMaxZ);
            f4 = (float)((double)f8 * (1.0 - this.renderMinY) * this.renderMinZ + (double)f9 * (1.0 - this.renderMinY) * (1.0 - this.renderMinZ) + (double)f10 * this.renderMinY * (1.0 - this.renderMinZ) + (double)f11 * this.renderMinY * this.renderMinZ);
            f5 = (float)((double)f8 * (1.0 - this.renderMaxY) * this.renderMinZ + (double)f9 * (1.0 - this.renderMaxY) * (1.0 - this.renderMinZ) + (double)f10 * this.renderMaxY * (1.0 - this.renderMinZ) + (double)f11 * this.renderMaxY * this.renderMinZ);
            f6 = (float)((double)f8 * (1.0 - this.renderMaxY) * this.renderMaxZ + (double)f9 * (1.0 - this.renderMaxY) * (1.0 - this.renderMaxZ) + (double)f10 * this.renderMaxY * (1.0 - this.renderMaxZ) + (double)f11 * this.renderMaxY * this.renderMaxZ);
            j1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYPN, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, i1);
            k1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZPP, this.aoBrightnessXYPP, this.aoBrightnessXYZPPP, i1);
            l1 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, this.aoBrightnessXYPP, i1);
            i2 = RenderBlocks.getInstance().func_147778_a(this.aoBrightnessXYZPNN, this.aoBrightnessXYPN, this.aoBrightnessXZPN, i1);
            this.brightnessTopLeft = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, (1.0 - this.renderMinY) * this.renderMaxZ, (1.0 - this.renderMinY) * (1.0 - this.renderMaxZ), this.renderMinY * (1.0 - this.renderMaxZ), this.renderMinY * this.renderMaxZ);
            this.brightnessBottomLeft = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, (1.0 - this.renderMinY) * this.renderMinZ, (1.0 - this.renderMinY) * (1.0 - this.renderMinZ), this.renderMinY * (1.0 - this.renderMinZ), this.renderMinY * this.renderMinZ);
            this.brightnessBottomRight = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, (1.0 - this.renderMaxY) * this.renderMinZ, (1.0 - this.renderMaxY) * (1.0 - this.renderMinZ), this.renderMaxY * (1.0 - this.renderMinZ), this.renderMaxY * this.renderMinZ);
            this.brightnessTopRight = RenderBlocks.getInstance().func_147727_a(j1, i2, l1, k1, (1.0 - this.renderMaxY) * this.renderMaxZ, (1.0 - this.renderMaxY) * (1.0 - this.renderMaxZ), this.renderMaxY * (1.0 - this.renderMaxZ), this.renderMaxY * this.renderMaxZ);
            if (flag1) {
                this.colorRedBottomRight = this.colorRedTopRight = R * 0.6f;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = G * 0.6f;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = B * 0.6f;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedTopRight = 0.6f;
                this.colorRedBottomRight = 0.6f;
                this.colorRedBottomLeft = 0.6f;
                this.colorRedTopLeft = 0.6f;
                this.colorGreenTopRight = 0.6f;
                this.colorGreenBottomRight = 0.6f;
                this.colorGreenBottomLeft = 0.6f;
                this.colorGreenTopLeft = 0.6f;
                this.colorBlueTopRight = 0.6f;
                this.colorBlueBottomRight = 0.6f;
                this.colorBlueBottomLeft = 0.6f;
                this.colorBlueTopLeft = 0.6f;
            }
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f4;
            this.colorGreenBottomLeft *= f4;
            this.colorBlueBottomLeft *= f4;
            this.colorRedBottomRight *= f5;
            this.colorGreenBottomRight *= f5;
            this.colorBlueBottomRight *= f5;
            this.colorRedTopRight *= f6;
            this.colorGreenTopRight *= f6;
            this.colorBlueTopRight *= f6;
            iicon = this.getBlockIcon(block, this.blockAccess, xPos, yPos, zPos, 5);
            CustomOreBlockRenderer.renderFaceXPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            RenderBlocks.getInstance();
            if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !this.hasOverrideBlockTexture()) {
                this.colorRedTopLeft *= R;
                this.colorRedBottomLeft *= R;
                this.colorRedBottomRight *= R;
                this.colorRedTopRight *= R;
                this.colorGreenTopLeft *= G;
                this.colorGreenBottomLeft *= G;
                this.colorGreenBottomRight *= G;
                this.colorGreenTopRight *= G;
                this.colorBlueTopLeft *= B;
                this.colorBlueBottomLeft *= B;
                this.colorBlueBottomRight *= B;
                this.colorBlueTopRight *= B;
                CustomOreBlockRenderer.renderFaceXPos(aWorld, aRenderer, block, xPos, yPos, zPos, aTextures);
            }
            flag = true;
        }
        this.enableAO = false;
        return flag;
    }
}

