/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IFluidLockable;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.gui.modularui.widget.FluidLockWidget;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MTEDigitalTankBase
extends MTEBasicTank
implements IFluidLockable,
IAddUIWidgets,
IAddGregtechLogo {
    public boolean mOutputFluid = false;
    public boolean mVoidFluidPart = false;
    public boolean mVoidFluidFull = false;
    public boolean mLockFluid = false;
    protected String lockedFluidName = null;
    public boolean mAllowInputFromOutputSide = false;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTEDigitalTankBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{StatCollector.func_74837_a((String)"GT5U.machines.digitaltank.tooltip", (Object[])new Object[]{GTUtility.formatNumbers(MTEDigitalTankBase.commonSizeCompute(aTier))}), StatCollector.func_74838_a((String)"GT5U.machines.digitaltank.tooltip1")}, new ITexture[0]);
    }

    protected static int commonSizeCompute(int tier) {
        int n;
        switch (tier) {
            case 1: {
                n = 4000000;
                break;
            }
            case 2: {
                n = 8000000;
                break;
            }
            case 3: {
                n = 16000000;
                break;
            }
            case 4: {
                n = 32000000;
                break;
            }
            case 5: {
                n = 64000000;
                break;
            }
            case 6: {
                n = 128000000;
                break;
            }
            case 7: {
                n = 256000000;
                break;
            }
            case 8: {
                n = 512000000;
                break;
            }
            case 9: {
                n = 1024000000;
                break;
            }
            case 10: {
                n = 0x7FFFFFF8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static int tierPump(int tier) {
        int n;
        switch (tier) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 5;
                break;
            }
            case 8: {
                n = 6;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 10: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public MTEDigitalTankBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public MTEDigitalTankBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && (stack.field_77990_d.func_74764_b("mFluid") || stack.field_77990_d.func_74764_b("lockedFluidName"))) {
            FluidStack tContents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d.func_74775_l("mFluid"));
            if (tContents != null && tContents.amount > 0) {
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_TANK_INFO", "Contains Fluid: ") + EnumChatFormatting.YELLOW + tContents.getLocalizedName() + EnumChatFormatting.GRAY);
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_TANK_AMOUNT", "Fluid Amount: ") + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tContents.amount) + " L" + EnumChatFormatting.GRAY);
            } else if (stack.field_77990_d.func_74764_b("lockedFluidName")) {
                String fluidName = stack.field_77990_d.func_74779_i("lockedFluidName");
                Fluid fluid = FluidRegistry.getFluid((String)fluidName);
                if (fluid == null) {
                    return;
                }
                tooltip.add(StatCollector.func_74837_a((String)"GT5U.item.tank.locked_to", (Object[])new Object[]{EnumChatFormatting.YELLOW + fluid.getLocalizedName()}));
            }
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.mFluid != null && this.mFluid.amount >= 0) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.mOutputFluid) {
            aNBT.func_74757_a("mOutputFluid", true);
        }
        if (this.mVoidFluidPart) {
            aNBT.func_74757_a("mVoidOverflow", true);
        }
        if (this.mVoidFluidFull) {
            aNBT.func_74757_a("mVoidFluidFull", true);
        }
        if (this.mLockFluid) {
            aNBT.func_74757_a("mLockFluid", true);
        }
        if (this.mLockFluid && GTUtility.isStringValid(this.lockedFluidName)) {
            aNBT.func_74778_a("lockedFluidName", this.lockedFluidName);
        }
        if (this.mAllowInputFromOutputSide) {
            aNBT.func_74757_a("mAllowInputFromOutputSide", true);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mOutputFluid", this.mOutputFluid);
        aNBT.func_74757_a("mVoidOverflow", this.mVoidFluidPart);
        aNBT.func_74757_a("mVoidFluidFull", this.mVoidFluidFull);
        aNBT.func_74757_a("mLockFluid", this.mLockFluid);
        if (this.mLockFluid && GTUtility.isStringValid(this.lockedFluidName)) {
            aNBT.func_74778_a("lockedFluidName", this.lockedFluidName);
        } else {
            aNBT.func_82580_o("lockedFluidName");
        }
        aNBT.func_74757_a("mAllowInputFromOutputSide", this.mAllowInputFromOutputSide);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOutputFluid = aNBT.func_74767_n("mOutputFluid");
        this.mVoidFluidPart = aNBT.func_74767_n("mVoidOverflow");
        this.mVoidFluidFull = aNBT.func_74767_n("mVoidFluidFull");
        this.mLockFluid = aNBT.func_74767_n("mLockFluid");
        if (this.mLockFluid) {
            this.setLockedFluidName(aNBT.func_74779_i("lockedFluidName"));
        } else {
            this.setLockedFluidName(null);
        }
        this.mAllowInputFromOutputSide = aNBT.func_74767_n("mAllowInputFromOutputSide");
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return !this.mLockFluid || this.lockedFluidName == null || this.lockedFluidName.equals(aFluid.getFluid().getName());
    }

    @Override
    public boolean isFluidChangingAllowed() {
        return !this.mLockFluid || this.lockedFluidName == null;
    }

    @Override
    public void onEmptyingContainerWhenEmpty() {
        if (this.lockedFluidName == null && this.mFluid != null && this.isFluidLocked()) {
            this.setLockedFluidName(this.mFluid.getFluid().getName());
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public void setLockedFluidName(String lockedFluidName) {
        Fluid fluid;
        this.lockedFluidName = lockedFluidName = GTUtility.isStringInvalid(lockedFluidName) ? null : lockedFluidName;
        if (lockedFluidName != null && (fluid = FluidRegistry.getFluid((String)lockedFluidName)) != null) {
            this.setFillableStack(new FluidStack(fluid, this.getFluidAmount()));
            this.mLockFluid = true;
        }
    }

    @Override
    public String getLockedFluidName() {
        return this.lockedFluidName;
    }

    @Override
    public void lockFluid(boolean lock) {
        this.mLockFluid = lock;
        if (!lock) {
            this.setLockedFluidName(null);
        }
    }

    @Override
    public boolean isFluidLocked() {
        return this.mLockFluid;
    }

    @Override
    public boolean acceptsFluidLock(String name) {
        if (name == null || this.getFluidAmount() == 0) {
            return true;
        }
        return this.mFluid != null && this.mFluid.getFluid().getName().equals(name);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection != ForgeDirection.UP) {
            if (sideDirection == baseMetaTileEntity.getFrontFacing()) {
                return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
            }
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_QTANK), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_QTANK_GLOW).glow().build()};
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mAllowInputFromOutputSide = !this.mAllowInputFromOutputSide;
            GTUtility.sendChatToPlayer(aPlayer, this.mAllowInputFromOutputSide ? GTUtility.getTrans("095") : GTUtility.getTrans("096"));
        }
    }

    @Override
    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (this.mFluid != null) {
            this.mFluid.amount = Math.min(this.mFluid.amount, this.getRealCapacity());
        }
        return this.mFluid;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (this.mFluid != null) {
            this.mFluid.amount = Math.min(this.mFluid.amount, this.getRealCapacity());
        }
        return this.mFluid;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            FluidStack tFluid;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            if (this.mVoidFluidFull && this.getFillableStack() != null) {
                this.mVoidFluidPart = false;
                this.mLockFluid = false;
                this.setFillableStack(null);
            }
            if (this.doesEmptyContainers() && (tFluid = GTUtility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true)) != null && this.isFluidInputAllowed(tFluid)) {
                if (this.getFillableStack() == null) {
                    if (this.isFluidInputAllowed(tFluid) && (tFluid.amount <= this.getRealCapacity() || this.mVoidFluidPart)) {
                        tFluid = tFluid.copy();
                        if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GTUtility.getContainerForFilledItem(this.mInventory[this.getInputSlot()], true), 1)) {
                            this.setFillableStack(tFluid);
                            this.onEmptyingContainerWhenEmpty();
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    }
                } else if (tFluid.isFluidEqual(this.getFillableStack()) && ((long)tFluid.amount + (long)this.getFillableStack().amount <= (long)this.getRealCapacity() || this.mVoidFluidPart || this.mVoidFluidFull) && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GTUtility.getContainerForFilledItem(this.mInventory[this.getInputSlot()], true), 1)) {
                    this.getFillableStack().amount += Math.min(tFluid.amount, this.getRealCapacity() - this.getFillableStack().amount);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                }
            }
            if (this.doesFillContainers() && (tOutput = GTUtility.fillFluidContainer(this.getDrainableStack(), this.mInventory[this.getInputSlot()], false, true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid2 = GTUtility.getFluidForFilledItem(tOutput, true);
                aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                if (tFluid2 != null) {
                    this.getDrainableStack().amount -= tFluid2.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
        }
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (this.getFillableStack() != null && !this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        FluidStack fillableStack = this.getFillableStack();
        if (fillableStack == null) {
            fillableStack = aFluid.copy();
            fillableStack.amount = 0;
        }
        int amount = Math.min(aFluid.amount, this.getRealCapacity() - fillableStack.amount);
        if (doFill) {
            fillableStack.amount += amount;
            if (this.getFillableStack() == null) {
                this.setFillableStack(fillableStack);
            }
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return this.mVoidFluidPart || this.mVoidFluidFull ? aFluid.amount : amount;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        int tFilledAmount;
        FluidStack tDrained;
        IFluidHandler tTank;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mOutputFluid && this.getDrainableStack() != null && aTick % 20L == 0L && (tTank = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null && (tDrained = this.drain(20 * (1 << 3 + 2 * MTEDigitalTankBase.tierPump(this.mTier)), false)) != null && (tFilledAmount = tTank.fill(aBaseMetaTileEntity.getBackFacing(), tDrained, false)) > 0) {
            tTank.fill(aBaseMetaTileEntity.getBackFacing(), this.drain(tFilledAmount, true), true);
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return this.mAllowInputFromOutputSide || side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    public boolean allowOverflow() {
        return this.mVoidFluidPart || this.mVoidFluidFull;
    }

    @Override
    public int getCapacity() {
        return this.allowOverflow() ? Integer.MAX_VALUE : this.getRealCapacity();
    }

    @Override
    public int getRealCapacity() {
        return MTEDigitalTankBase.commonSizeCompute(this.mTier);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    @Nonnull
    public FluidTankInfo[] getRealTankInfo(ForgeDirection side) {
        return new FluidTankInfo[]{new FluidTankInfo(this.getFluid(), this.getRealCapacity())};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        FluidStack fluid;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        FluidStack fluidStack = fluid = tag.func_74764_b("mFluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("mFluid")) : null;
        if (fluid != null && fluid.amount >= 0) {
            currenttip.remove(0);
            currenttip.add(0, GTUtility.formatNumbers(fluid.amount) + " / " + GTUtility.formatNumbers(this.getRealCapacity()) + " L " + fluid.getLocalizedName());
        } else {
            currenttip.add(0, "Tank Empty");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            tag.func_74782_a("mFluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        } else if (tag.func_74764_b("mFluid")) {
            tag.func_82580_o("mFluid");
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.fluidTank.setAllowOverflow(this.allowOverflow());
        this.fluidTank.setPreventDraining(this.mLockFluid);
        FluidSlotWidget fluidSlotWidget = new FluidSlotWidget((IFluidTank)this.fluidTank);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getInputSlot()).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getOutputSlot()).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_OUT}).setPos(79, 43))).widget(fluidSlotWidget.setOnClickContainer(widget -> this.onEmptyingContainerWhenEmpty()).setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(58, 41))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.digitaltank.fluid.amount")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format(this.mFluid != null ? (long)this.mFluid.amount : 0L)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(98, 16).setSize(71, 45))).widget(new FluidLockWidget(this).setPos(149, 41))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.digitaltank.lockfluid.label")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(101, 20))).widget(TextWidget.dynamicString(() -> {
            FluidStack fluidStack = FluidRegistry.getFluidStack((String)this.lockedFluidName, (int)1);
            return fluidStack != null ? fluidStack.getLocalizedName() : StatCollector.func_74838_a((String)"GT5U.machines.digitaltank.lockfluid.empty");
        }).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(65).setPos(101, 30))).widget(new CycleButtonWidget().setToggle(() -> this.mOutputFluid, val -> {
            this.mOutputFluid = val;
            if (!this.mOutputFluid) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("262", "Fluid Auto Output Disabled"));
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("263", "Fluid Auto Output Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_AUTOOUTPUT_FLUID).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.autooutput.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(7, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mLockFluid, val -> {
            this.lockFluid((boolean)val);
            this.fluidTank.setPreventDraining(this.mLockFluid);
            if (this.mLockFluid) {
                String inBrackets;
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = GTUtility.trans("264", "currently none, will be locked to the next that is put in");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getFluid().getName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), String.format("%s (%s)", GTUtility.trans("265", "1 specific Fluid"), inBrackets));
            } else {
                this.fluidTank.drain(0, true);
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("266", "Lock Fluid Mode Disabled"));
            }
            fluidSlotWidget.notifyTooltipChange();
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_LOCK).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.lockfluid.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(25, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mAllowInputFromOutputSide, val -> {
            this.mAllowInputFromOutputSide = val;
            if (!this.mAllowInputFromOutputSide) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.getTrans("096"));
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.getTrans("095"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_INPUT_FROM_OUTPUT_SIDE).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.inputfromoutput.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(43, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mVoidFluidPart, val -> {
            this.mVoidFluidPart = val;
            this.fluidTank.setAllowOverflow(this.allowOverflow());
            if (!this.mVoidFluidPart) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("267", "Overflow Voiding Mode Disabled"));
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("268", "Overflow Voiding Mode Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_TANK_VOID_EXCESS).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.voidoverflow.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(98, 63).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.mVoidFluidFull, val -> {
            this.mVoidFluidFull = val;
            this.fluidTank.setAllowOverflow(this.allowOverflow());
            if (!this.mVoidFluidFull) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("269", "Void Full Mode Disabled"));
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), GTUtility.trans("270", "Void Full Mode Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_TANK_VOID_ALL).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.digitaltank.voidfull.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(116, 63).setSize(18, 18));
    }
}

