/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverChest
extends CoverBehaviorBase<ChestInventory> {
    private final int slots;
    private final int stackSizeLimit = 1;

    public CoverChest(int slots, ITexture coverTexture) {
        super(ChestInventory.class, coverTexture);
        if (slots <= 0) {
            throw new IllegalArgumentException("slots must be greater than 0");
        }
        this.slots = slots;
    }

    @Override
    public ChestInventory createDataObject(int aLegacyData) {
        return new ChestInventory(this.slots, 1);
    }

    @Override
    public ChestInventory createDataObject() {
        return new ChestInventory(this.slots, 1);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean isSimpleCover() {
        return true;
    }

    @Override
    public boolean allowsCopyPasteTool() {
        return false;
    }

    @Override
    public boolean allowsTickRateAddition() {
        return false;
    }

    @Override
    protected void onDroppedImpl(ForgeDirection side, int aCoverID, ChestInventory aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity.getWorld().field_72995_K) {
            return;
        }
        aCoverVariable.dropAll(aTileEntity, side);
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, ChestInventory aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable.firstTick ? 1 : 0;
    }

    @Override
    protected ChestInventory doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ChestInventory aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable.items.getSlots() != this.slots) {
            if (aCoverVariable.items.getSlots() > this.slots) {
                for (int i = this.slots; i < aCoverVariable.items.getSlots(); ++i) {
                    ItemStack item = aCoverVariable.items.getStackInSlot(i);
                    if (item == null) continue;
                    CoverChest.dropItem(aTileEntity, side, item);
                }
            }
            ChestInventory newData = this.createDataObject();
            int toCopy = Math.min(newData.items.getSlots(), aCoverVariable.items.getSlots());
            for (int i = 0; i < toCopy; ++i) {
                newData.items.setStackInSlot(i, aCoverVariable.items.getStackInSlot(i));
            }
            return newData;
        }
        aCoverVariable.firstTick = false;
        return super.doCoverThingsImpl(side, aInputRedstone, aCoverID, aCoverVariable, aTileEntity, aTimer);
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ChestUIFactory(buildContext).createWindow();
    }

    private static void dropItem(ICoverable coverable, ForgeDirection direction, ItemStack tItem) {
        EntityItem tItemEntity = new EntityItem(coverable.getWorld(), (double)((float)coverable.getXCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetX), (double)((float)coverable.getYCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetY), (double)((float)coverable.getZCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetZ), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
        if (tItem.func_77942_o()) {
            tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
        }
        tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05 + 0.2;
        tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        tItemEntity.field_70172_ad = 999999;
        tItemEntity.lifespan = 60000;
        coverable.getWorld().func_72838_d((Entity)tItemEntity);
    }

    public static class ChestInventory
    implements ISerializableObject {
        final LimitingItemStackHandler items;
        boolean firstTick;

        public ChestInventory(int slots, int stackSize) {
            this.items = new LimitingItemStackHandler(slots, stackSize);
        }

        @Override
        @NotNull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            this.items.deserializeNBT(ISerializableObject.readCompoundTagFromGreggyByteBuf(aBuf));
            return this;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            ByteBufUtils.writeTag((ByteBuf)aBuf, (NBTTagCompound)this.items.serializeNBT());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (!(aNBT instanceof NBTTagCompound)) {
                return;
            }
            this.items.deserializeNBT((NBTTagCompound)aNBT);
            this.firstTick = true;
        }

        @Override
        @NotNull
        public NBTBase saveDataToNBT() {
            return this.items.serializeNBT();
        }

        @Override
        @NotNull
        public ISerializableObject copy() {
            ChestInventory copy = new ChestInventory(this.items.getSlots(), this.items.getSlotLimit(0));
            for (int i = 0; i < this.items.getSlots(); ++i) {
                copy.items.setStackInSlot(i, this.items.getStackInSlot(i));
            }
            return copy;
        }

        public void dropAll(ICoverable coverable, ForgeDirection direction) {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack tItem = this.items.getStackInSlot(i);
                if (tItem == null) continue;
                CoverChest.dropItem(coverable, direction, tItem);
                this.items.setStackInSlot(i, null);
            }
        }
    }

    private static class LimitingItemStackHandler
    extends ItemStackHandler {
        private final int slotLimit;

        private LimitingItemStackHandler(int slots, int slotLimit) {
            super(slots);
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit(int slot) {
            return this.slotLimit;
        }
    }

    public class ChestUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public ChestUIFactory(CoverUIBuildContext buildContext) {
            super(CoverChest.this, buildContext);
        }

        @Override
        protected int getGUIHeight() {
            int height = CoverChest.this.slots / 3 * 18 + 8;
            if (!this.getUIBuildContext().isAnotherWindow()) {
                return height + 72 + 14;
            }
            return height;
        }

        @Override
        protected void addTitleToUI(ModularWindow.Builder builder) {
        }

        @Override
        protected int getGUIWidth() {
            if (this.getUIBuildContext().isAnotherWindow()) {
                return 74;
            }
            return 182;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            CoverDataControllerWidget<ChestInventory> w = new CoverDataControllerWidget<ChestInventory>(this::getCoverData, this::setCoverData, CoverChest.this);
            ChestInventory d = (ChestInventory)this.getCoverData();
            if (d == null) {
                return;
            }
            LimitingItemStackHandler h = d.items;
            SlotGroup slotGroup = SlotGroup.ofItemHandler((IItemHandlerModifiable)h, (int)3).build();
            if (this.getUIBuildContext().isAnotherWindow()) {
                slotGroup.setPos(4, 4);
            } else {
                slotGroup.setPos(this.getGUIWidth() / 2 - 27, 6);
            }
            w.addChild((Widget)slotGroup);
            builder.widget(w);
            builder.setPos((p, t) -> Alignment.Center.getAlignedPos(new Size(this.getUIBuildContext().isAnotherWindow() ? t.getPos().x : p.width, p.height), new Size(this.getGUIWidth(), this.getGUIHeight())));
        }

        @Override
        protected boolean doesBindPlayerInventory() {
            return true;
        }
    }
}

