/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.regularBlock;

import goodgenerator.blocks.regularBlock.BlockCasing;
import goodgenerator.blocks.regularBlock.ITextureBlock;
import goodgenerator.blocks.tileEntity.base.MTELargeTurbineBase;
import goodgenerator.client.render.BlockRenderHandler;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTurbineCasing
extends BlockCasing
implements ITextureBlock {
    public static IIconContainer[][] turbineShape = new IIconContainer[3][9];
    public IIconContainer base;

    public BlockTurbineCasing(String name, String texture) {
        super(name, new String[]{"GoodGenerator:" + texture});
        this.base = new Textures.BlockIcons.CustomIcon("icons/" + texture);
    }

    private static int isTurbineControllerWithSide(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return 0;
        }
        IGregTechTileEntity tTile = (IGregTechTileEntity)tTileEntity;
        if (tTile.getMetaTileEntity() instanceof MTELargeTurbineBase && tTile.getFrontFacing() == side) {
            if (tTile.isActive()) {
                return 1;
            }
            return ((MTELargeTurbineBase)tTile.getMetaTileEntity()).hasTurbine() ? 2 : 3;
        }
        return 0;
    }

    public ITexture[] getTurbineCasing(int iconIndex, boolean active, boolean hasTurbine) {
        int states = active ? 0 : (hasTurbine ? 1 : 2);
        return new ITexture[]{TextureFactory.of(this.base), TextureFactory.of(turbineShape[states][iconIndex])};
    }

    @Override
    public ITexture[] getTexture(Block aBlock, ForgeDirection side, IBlockAccess aWorld, int xCoord, int yCoord, int zCoord) {
        int ordinalSide = side.ordinal();
        int tInvertLeftRightMod = ordinalSide % 2 * 2 - 1;
        switch (ordinalSide / 2) {
            case 0: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockTurbineCasing.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord, zCoord + i, side)) == 0) continue;
                        return this.getTurbineCasing(4 - i * 3 - j, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 1: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockTurbineCasing.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord + i, zCoord, side)) == 0) continue;
                        return this.getTurbineCasing(4 + i * 3 - j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 2: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = BlockTurbineCasing.isTurbineControllerWithSide(aWorld, xCoord, yCoord + i, zCoord + j, side)) == 0) continue;
                        return this.getTurbineCasing(4 + i * 3 + j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
        }
        return this.getTexture(aBlock, side);
    }

    @Override
    public ITexture[] getTexture(Block aBlock, int aMeta, ForgeDirection side) {
        return new ITexture[]{TextureFactory.of(this.base)};
    }

    public int func_149645_b() {
        if (BlockRenderHandler.INSTANCE == null) {
            return super.func_149645_b();
        }
        return BlockRenderHandler.INSTANCE.mRenderID;
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 1; j <= 9; ++j) {
                BlockTurbineCasing.turbineShape[i][j - 1] = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_" + i + j);
            }
        }
    }
}

