/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util.log;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DebugLog {
    private static boolean init;
    static FileHandler fh;
    private static Logger utilLog;

    public static void initDebugLog(FMLPreInitializationEvent event) throws IOException {
        if (init) {
            return;
        }
        fh = new FileHandler(new File(new File(event.getModConfigurationDirectory().getParentFile(), "logs"), "BWLog.log").toString());
        utilLog = Logger.getLogger("DebugLog");
        utilLog.setUseParentHandlers(false);
        utilLog.addHandler(fh);
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord record) {
                SimpleDateFormat logTime = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(record.getMillis());
                return "Level: " + record.getLevel() + " at " + logTime.format(cal.getTime()) + " " + record.getMessage() + "\n";
            }
        };
        fh.setFormatter(formatter);
        init = true;
    }

    public static void log(String record) {
        if (!init) {
            return;
        }
        utilLog.info(record);
    }
}

