/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.gui.helpers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiEndPortalRenderer {
    private static final ResourceLocation texPortalSky = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation texPortal = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random consistentRandom = new Random(31100L);
    private final GuiScreen gui;
    private final int portalWidthHalf;
    private final int portalHeightHalf;
    private final int portalTopOffset;
    private int portalTranslation;
    private int prevPortalTranslation;

    public GuiEndPortalRenderer(GuiScreen ownerGui, int portalWidth, int portalHeight, int portalTopOffset) {
        this.gui = ownerGui;
        this.portalWidthHalf = portalWidth >> 1;
        this.portalHeightHalf = portalHeight >> 1;
        this.portalTopOffset = portalTopOffset;
        this.prevPortalTranslation = this.portalTranslation = this.gui.field_146297_k.field_71441_e.field_73012_v.nextInt(10000);
    }

    public void update(int speed) {
        this.prevPortalTranslation = this.portalTranslation;
        this.portalTranslation += speed;
    }

    public void draw(float x, float y, float portalScale, float partialTickTime) {
        int hw = this.gui.field_146294_l >> 1;
        int hh = this.gui.field_146295_m >> 1;
        float div = (float)this.portalWidthHalf / (float)this.portalHeightHalf;
        GL11.glDisable((int)2896);
        consistentRandom.setSeed(31100L);
        for (int layer = 0; layer < 16; ++layer) {
            float revLayer = 16 - layer;
            float scale = 0.09625f;
            float colorMultiplier = 1.0f / (revLayer + 1.0f);
            float layerMp = 1.0f + (float)layer * 0.4f;
            if (layer == 0) {
                this.gui.field_146297_k.func_110434_K().func_110577_a(texPortalSky);
                colorMultiplier = 0.1f;
                scale = 1.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (layer >= 1) {
                this.gui.field_146297_k.func_110434_K().func_110577_a(texPortal);
                if (layer == 1) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)1);
                    scale = 0.2f;
                }
            }
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)(layerMp * ((float)this.prevPortalTranslation + (float)(this.portalTranslation - this.prevPortalTranslation) * partialTickTime) * 2.0E-5f), (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glScalef((float)(1.0f + revLayer * 0.15f), (float)(1.0f + revLayer * 0.15f), (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(layer * layer * 4321 + layer * 9) * 4.0f + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(x * 0.0025f * layerMp), (float)(y * 0.0025f * layerMp), (float)0.0f);
            GL11.glTranslatef((float)(0.5f * div), (float)0.5f, (float)0.0f);
            GL11.glScalef((float)(4.0f * portalScale), (float)(4.0f * portalScale), (float)1.0f);
            GL11.glTranslatef((float)(-0.5f * div), (float)-0.5f, (float)0.0f);
            GL11.glScalef((float)div, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            float red = consistentRandom.nextFloat() * 0.5f + 0.1f;
            float green = consistentRandom.nextFloat() * 0.5f + 0.4f;
            float blue = consistentRandom.nextFloat() * 0.5f + 0.5f;
            if (layer == 0) {
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            tessellator.func_78369_a(red * colorMultiplier, green * colorMultiplier, blue * colorMultiplier, 1.0f);
            tessellator.func_78374_a((double)(hw - this.portalWidthHalf), (double)(hh + this.portalHeightHalf + this.portalTopOffset), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(hw + this.portalWidthHalf), (double)(hh + this.portalHeightHalf + this.portalTopOffset), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(hw + this.portalWidthHalf), (double)(hh - this.portalHeightHalf + this.portalTopOffset), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(hw - this.portalWidthHalf), (double)(hh - this.portalHeightHalf + this.portalTopOffset), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
    }
}

