/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.CastlingRights;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.utils.BlankRemover;
import com.jamesswafford.chess4j.utils.PieceFactory;

public final class FenParser {
    private static final int MINIMUM_FEN_PARTS = 4;
    private static final int PIECE_PART = 0;
    private static final int PLAYER_PART = 1;
    private static final int CASTLING_PART = 2;
    private static final int EP_PART = 3;
    private static final int HALF_MOVE_CLOCK_PART = 4;
    private static final int FULL_MOVE_COUNTER_PART = 5;

    private FenParser() {
    }

    public static void setPos(Board b, String fen) throws ParseException {
        String myFen = fen.trim();
        b.clearBoard();
        myFen = BlankRemover.trim(myFen);
        String[] fenPieces = myFen.split(" ");
        if (fenPieces.length < 4) {
            throw new ParseException("not enough parts to FEN.");
        }
        FenParser.setPieces(b, fenPieces[0]);
        FenParser.setPlayer(b, fenPieces[1]);
        FenParser.setCastlingRights(b, fenPieces[2]);
        FenParser.setEP(b, fenPieces[3]);
        String halfMoveClock = fenPieces.length > 4 ? fenPieces[4] : null;
        FenParser.setHalfMoveClock(b, halfMoveClock);
        String fullMoveCounter = fenPieces.length > 5 ? fenPieces[5] : null;
        FenParser.setFullMoveCounter(b, fullMoveCounter);
    }

    private static void setHalfMoveClock(Board b, String s) throws ParseException {
        try {
            Integer halfMoves = s == null ? 0 : Integer.valueOf(s);
            b.setFiftyCounter(halfMoves);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e);
        }
    }

    private static void setFullMoveCounter(Board b, String s) throws ParseException {
        try {
            Integer moveCounter = s == null ? 1 : Integer.valueOf(s);
            b.setMoveCounter((moveCounter - 1) * 2);
            if (Color.BLACK.equals((Object)b.getPlayerToMove())) {
                b.setMoveCounter(b.getMoveCounter() + 1);
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(e);
        }
    }

    private static void setCastlingRights(Board b, String s) throws ParseException {
        if (s.equals("-")) {
            return;
        }
        char[] arr = s.toCharArray();
        block6: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case 'K': {
                    b.addCastlingRight(CastlingRights.WHITE_KINGSIDE);
                    continue block6;
                }
                case 'k': {
                    b.addCastlingRight(CastlingRights.BLACK_KINGSIDE);
                    continue block6;
                }
                case 'Q': {
                    b.addCastlingRight(CastlingRights.WHITE_QUEENSIDE);
                    continue block6;
                }
                case 'q': {
                    b.addCastlingRight(CastlingRights.BLACK_QUEENSIDE);
                    continue block6;
                }
                default: {
                    throw new ParseException("invalid character in setCastlingRights: " + s);
                }
            }
        }
    }

    private static void setEP(Board b, String s) throws ParseException {
        if (s.equals("-")) {
            return;
        }
        char[] arr = s.toCharArray();
        if (arr.length != 2) {
            throw new ParseException("invalid string in setEP: " + s);
        }
        int epsq = 0;
        if (arr[0] < 'a' || arr[0] > 'h') {
            throw new ParseException("invalid string in setEP: " + s);
        }
        epsq = arr[0] - 97;
        if (arr[1] < '1' || arr[1] > '8') {
            throw new ParseException("invalid string in setEP: " + s);
        }
        b.setEP(Square.valueOf(epsq += 8 * (8 - (arr[1] - 48))));
    }

    private static void setPieces(Board b, String s) {
        char[] arr = s.toCharArray();
        int sq = 0;
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            Piece piece = PieceFactory.getPiece(String.valueOf(c));
            if (piece != null) {
                b.addPiece(piece, Square.valueOf(sq));
                ++sq;
                continue;
            }
            if (c < '1' || c > '8') continue;
            sq += Integer.valueOf(String.valueOf(c)).intValue();
        }
        assert (sq == 64);
        b.resetKingSquares();
    }

    private static void setPlayer(Board b, String s) throws ParseException {
        Color ptm;
        if (s.equalsIgnoreCase("b")) {
            ptm = Color.BLACK;
        } else if (s.equalsIgnoreCase("w")) {
            ptm = Color.WHITE;
        } else {
            throw new ParseException("could not parse player: " + s);
        }
        if (!ptm.equals((Object)b.getPlayerToMove())) {
            b.swapPlayer();
        }
    }
}

