/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.entities.golems.upgrades;

import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.common.entities.golems.EntityGolemBase;

public abstract class GolemUpgrade<T extends NBTBase> {
    private static final String UPGRADE_COMPOUND = "upgrades";

    public abstract String getName();

    public String getTagName() {
        return this.getName();
    }

    public String getText() {
        return "gadomancy".toLowerCase() + ".upgrades." + this.getName().toLowerCase();
    }

    public ItemStack getUpgradeItem() {
        return null;
    }

    protected T createUpgradeData() {
        return null;
    }

    protected T getUpgradeData(ItemStack stack) {
        return this.getUpgradeData(NBTHelper.getPersistentData(stack));
    }

    protected T getUpgradeData(EntityGolemBase golem) {
        return this.getUpgradeData(NBTHelper.getPersistentData((Entity)golem));
    }

    protected T getUpgradeData(NBTTagCompound compound) {
        if (compound.func_74764_b(UPGRADE_COMPOUND)) {
            NBTTagCompound upgrades = compound.func_74775_l(UPGRADE_COMPOUND);
            try {
                return (T)upgrades.func_74781_a(this.getTagName());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasUpgrade(ItemStack stack) {
        return this.hasUpgrade(NBTHelper.getPersistentData(stack));
    }

    public boolean hasUpgrade(EntityGolemBase golem) {
        return this.hasUpgrade(NBTHelper.getPersistentData((Entity)golem));
    }

    protected boolean hasUpgrade(NBTTagCompound compound) {
        return this.getUpgradeData(compound) != null;
    }

    public void addUpgrade(ItemStack stack) {
        this.addUpgrade(NBTHelper.getPersistentData(stack));
    }

    public void addUpgrade(EntityGolemBase golem) {
        this.addUpgrade(NBTHelper.getPersistentData((Entity)golem));
    }

    protected void addUpgrade(NBTTagCompound compound) {
        NBTTagCompound upgrades = compound.func_74775_l(UPGRADE_COMPOUND);
        if (!compound.func_74764_b(UPGRADE_COMPOUND)) {
            compound.func_74782_a(UPGRADE_COMPOUND, (NBTBase)upgrades);
        }
        T data = this.createUpgradeData();
        upgrades.func_74782_a(this.getTagName(), data == null ? new NBTTagByte(1) : data);
    }

    public void removeUpgrade(ItemStack stack) {
        this.removeUpgrade(NBTHelper.getPersistentData(stack));
    }

    public void removeUpgrade(EntityGolemBase golem) {
        this.removeUpgrade(NBTHelper.getPersistentData((Entity)golem));
    }

    protected void removeUpgrade(NBTTagCompound compound) {
        if (compound.func_74764_b(UPGRADE_COMPOUND)) {
            compound.func_82580_o(this.getTagName());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof GolemUpgrade && ((GolemUpgrade)obj).getName().equals(this.getName());
    }
}

