/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.bukkit.events;

import net.techbrew.journeymapserver.JMServerBukkit;
import net.techbrew.journeymapserver.bukkit.util.BukkitWorldUtil;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.mapcontrol.MappingOptionsHandler;
import net.techbrew.journeymapserver.common.network.PacketManager;
import net.techbrew.journeymapserver.common.util.LogHelper;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BukkitEvents
implements Listener {
    private final JMServerBukkit plugin;

    public BukkitEvents(JMServerBukkit plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerJoinEvent event) {
        LogHelper.info(String.format("%s joined world:%s", event.getPlayer().getName(), BukkitWorldUtil.getWorldNameFromWorld(event.getPlayer().getWorld())));
        BukkitTask task = new SendPlayerPackets(event.getPlayer()).runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerChangedWorldEvent event) {
        LogHelper.info(String.format("%s switched to world:%s", event.getPlayer().getName(), BukkitWorldUtil.getWorldNameFromWorld(event.getPlayer().getWorld())));
        BukkitTask task = new SendPlayerPackets(event.getPlayer()).runTaskLater((Plugin)this.plugin, 20L);
    }

    private void handlePlayer(Player player) {
        MappingOptionsHandler options = new MappingOptionsHandler(BukkitWorldUtil.getWorldNameFromWorld(player.getWorld()));
        if (options.disableRadar(player.getName())) {
            player.sendMessage("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e");
            LogHelper.info("Disabling Radar for player: " + player.getName());
        }
        if (options.disableCaveMapping(player.getName())) {
            player.sendMessage("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d");
            LogHelper.info("Disabling CaveMapping for player: " + player.getName());
        }
    }

    private class SendPlayerPackets
    extends BukkitRunnable {
        private final Player player;

        public SendPlayerPackets(Player player) {
            this.player = player;
        }

        public void run() {
            PacketManager.instance.sendPlayerWorldID(ConfigHandler.getConfigByWorldName(this.player.getWorld().getName()).getWorldID(), this.player.getName());
            BukkitEvents.this.handlePlayer(this.player);
            this.cancel();
        }
    }
}

