/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Modules.ModuleBase;

public class ModuleFlowerRemover
extends ModuleBase {
    private int tick;
    private float bladeangle;
    private float bladespeed = 0.0f;

    public ModuleFlowerRemover(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().field_70170_p.field_72995_K) {
            this.bladeangle += this.getBladeSpindSpeed();
            this.bladespeed = this.getCart().hasFuel() ? Math.min(1.0f, this.bladespeed + 0.005f) : Math.max(0.0f, this.bladespeed - 0.005f);
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.mownTheLawn();
                this.shearEntities();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void mownTheLawn() {
        for (int x = -this.getBlocksOnSide(); x <= this.getBlocksOnSide(); ++x) {
            for (int z = -this.getBlocksOnSide(); z <= this.getBlocksOnSide(); ++z) {
                for (int y = -this.getBlocksFromLevel(); y <= this.getBlocksFromLevel(); ++y) {
                    int z1;
                    int y1;
                    int x1 = x + this.getCart().x();
                    if (!this.isFlower(x1, y1 = y + this.getCart().y(), z1 = z + this.getCart().z())) continue;
                    Block block = this.getCart().field_70170_p.func_147439_a(x1, y1, z1);
                    int m = this.getCart().field_70170_p.func_72805_g(x1, y1, z1);
                    if (block == null) continue;
                    this.addStuff(block.getDrops(this.getCart().field_70170_p, x1, y1, z1, m, 0));
                    this.getCart().field_70170_p.func_147468_f(x1, y1, z1);
                }
            }
        }
    }

    private void shearEntities() {
        List entities = this.getCart().field_70170_p.func_72872_a(EntityLiving.class, this.getCart().field_70121_D.func_72314_b((double)this.getBlocksOnSide(), (double)((float)this.getBlocksFromLevel() + 2.0f), (double)this.getBlocksOnSide()));
        for (EntityLiving target : entities) {
            IShearable shearable;
            if (!(target instanceof IShearable) || !(shearable = (IShearable)target).isShearable(null, (IBlockAccess)this.getCart().field_70170_p, (int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v)) continue;
            this.addStuff(shearable.onSheared(null, (IBlockAccess)this.getCart().field_70170_p, (int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v, 0));
        }
    }

    private boolean isFlower(int x, int y, int z) {
        Block block = this.getCart().field_70170_p.func_147439_a(x, y, z);
        return block != null && block instanceof BlockFlower;
    }

    private void addStuff(ArrayList<ItemStack> stuff) {
        for (ItemStack iStack : stuff) {
            this.getCart().addItemToChest(iStack);
            if (iStack.field_77994_a == 0) continue;
            EntityItem entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = 0.0;
            this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public float getBladeAngle() {
        return this.bladeangle;
    }

    public float getBladeSpindSpeed() {
        return this.bladespeed;
    }
}

