/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Helpers.ITankHolder;
import vswe.stevescarts.Helpers.IconData;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiBase;

public class Tank
implements IFluidTank {
    private FluidStack fluid;
    private int tankSize;
    private ITankHolder owner;
    private int tankid;
    private boolean isLocked;

    public Tank(ITankHolder owner, int tankSize, int tankid) {
        this.owner = owner;
        this.tankSize = tankSize;
        this.tankid = tankid;
    }

    public Tank copy() {
        Tank tank = new Tank(this.owner, this.tankSize, this.tankid);
        if (this.getFluid() != null) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public int getCapacity() {
        return this.tankSize;
    }

    public int getTankPressure() {
        return 0;
    }

    public void containerTransfer() {
        ItemStack item = this.owner.getInputContainer(this.tankid);
        if (item != null) {
            FluidStack fluidContent;
            ItemStack full;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
                int fill;
                FluidStack fluidContent2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
                if (fluidContent2 != null && (fill = this.fill(fluidContent2, false, false)) == fluidContent2.amount) {
                    Item container = item.func_77973_b().func_77668_q();
                    ItemStack containerStack = null;
                    if (container != null) {
                        containerStack = new ItemStack(container, 1);
                        this.owner.addToOutputContainer(this.tankid, containerStack);
                    }
                    if (containerStack == null || containerStack.field_77994_a == 0) {
                        --item.field_77994_a;
                        if (item.field_77994_a <= 0) {
                            this.owner.clearInputContainer(this.tankid);
                        }
                        this.fill(fluidContent2, true, false);
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)item) && (full = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluid, (ItemStack)item)) != null && (fluidContent = FluidContainerRegistry.getFluidForFilledItem((ItemStack)full)) != null) {
                this.owner.addToOutputContainer(this.tankid, full);
                if (full.field_77994_a == 0) {
                    --item.field_77994_a;
                    if (item.field_77994_a <= 0) {
                        this.owner.clearInputContainer(this.tankid);
                    }
                    this.drain(fluidContent.amount, true, false);
                }
            }
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, false);
    }

    public int fill(FluidStack resource, boolean doFill, boolean isRemote) {
        if (resource == null || this.fluid != null && !resource.isFluidEqual(this.fluid)) {
            return 0;
        }
        int free = this.tankSize - (this.fluid == null ? 0 : this.fluid.amount);
        int fill = Math.min(free, resource.amount);
        if (doFill && !isRemote) {
            if (this.fluid == null) {
                this.fluid = resource.copy();
                this.fluid.amount = 0;
            }
            this.fluid.amount += fill;
            this.owner.onFluidUpdated(this.tankid);
        }
        return fill;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain, false);
    }

    public FluidStack drain(int maxDrain, boolean doDrain, boolean isRemote) {
        if (this.fluid == null) {
            return null;
        }
        int amount = this.fluid.amount;
        int drain = Math.min(amount, maxDrain);
        FluidStack ret = this.fluid.copy();
        ret.amount = drain;
        if (doDrain && !isRemote) {
            this.fluid.amount -= drain;
            if (this.fluid.amount <= 0 && !this.isLocked) {
                this.fluid = null;
            }
            this.owner.onFluidUpdated(this.tankid);
        }
        return ret;
    }

    public void setLocked(boolean val) {
        this.isLocked = val;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (this.fluid != null) {
            name = this.fluid.getFluid().getLocalizedName();
            if (name.indexOf(".") != -1) {
                name = FluidRegistry.getFluidName((FluidStack)this.fluid);
            }
            name = name != null && !name.equals("") ? Character.toUpperCase(name.charAt(0)) + name.substring(1) : Localization.MODULES.TANKS.INVALID.translate(new String[0]);
            amount = this.fluid.amount;
        }
        return "\u00a7F" + name + "\n\u00a77" + this.formatNumber(amount) + " / " + this.formatNumber(this.tankSize);
    }

    private String formatNumber(int number) {
        return String.format("%,d", number).replace('\u00a0', ' ');
    }

    public static IconData getIconAndTexture(FluidStack stack) {
        Fluid fluid;
        IIcon icon = null;
        String texture = null;
        if (stack != null && (fluid = stack.getFluid()) != null) {
            icon = fluid.getIcon();
            if (icon == null) {
                if (FluidRegistry.WATER.equals(fluid)) {
                    icon = Blocks.field_150355_j.func_149691_a(0, 0);
                } else if (FluidRegistry.LAVA.equals(fluid)) {
                    icon = Blocks.field_150353_l.func_149691_a(0, 0);
                }
            }
            if (icon != null) {
                texture = "/atlas/blocks.png";
            }
        }
        return new IconData(icon, texture);
    }

    private static float getColorComponent(int color, int id) {
        return (float)((color & 255 << id * 8) >> id * 8) / 255.0f;
    }

    public static void applyColorFilter(FluidStack fluid) {
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor4f((float)Tank.getColorComponent(color, 2), (float)Tank.getColorComponent(color, 1), (float)Tank.getColorComponent(color, 0), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFluid(GuiBase gui, int startX, int startY) {
        if (this.fluid != null) {
            int fluidLevel = (int)(48.0f * ((float)this.fluid.amount / (float)this.tankSize));
            IconData data = Tank.getIconAndTexture(this.fluid);
            if (data.getIcon() == null) {
                return;
            }
            ResourceHelper.bindResource(data.getResource());
            Tank.applyColorFilter(this.fluid);
            for (int y = 0; y < 3; ++y) {
                int pixels = fluidLevel - (2 - y) * 16;
                if (pixels <= 0) continue;
                if (pixels > 16) {
                    pixels = 16;
                }
                for (int x = 0; x < 2; ++x) {
                    this.owner.drawImage(this.tankid, gui, data.getIcon(), startX + 2 + 16 * x, startY + 1 + 16 * y + (16 - pixels), 0, 16 - pixels, 16, pixels);
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.fluid, this.getCapacity());
    }
}

