/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import de.katzenpapst.amunra.crafting.CircuitFabricatorRecipe;
import de.katzenpapst.amunra.crafting.RecipeHelper;
import de.katzenpapst.amunra.inventory.schematic.ContainerSchematicShuttle;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.nei.recipehandler.ARCircuitFab;
import de.katzenpapst.amunra.nei.recipehandler.ARNasaWorkbenchShuttle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import net.minecraft.item.ItemStack;

public class NEIAmunRaConfig
implements IConfigureNEI {
    private static Map<Map<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap<Map<Integer, PositionedStack>, PositionedStack>();
    private static Map<List<PositionedStack>, PositionedStack> shuttleRecipes = new HashMap<List<PositionedStack>, PositionedStack>();

    public String getName() {
        return "AmunRa NEI Plugin";
    }

    public String getVersion() {
        return "0.7.1";
    }

    public void loadConfig() {
        this.initCircuitFabricatorRecipes();
        this.initShuttleRecipes();
        API.registerRecipeHandler((ICraftingHandler)new ARCircuitFab());
        API.registerUsageHandler((IUsageHandler)new ARCircuitFab());
        API.registerRecipeHandler((ICraftingHandler)new ARNasaWorkbenchShuttle());
        API.registerUsageHandler((IUsageHandler)new ARNasaWorkbenchShuttle());
    }

    private void initShuttleRecipes() {
        Vector<INasaWorkbenchRecipe> data = RecipeHelper.getAllRecipesFor(ARItems.shuttleItem);
        int[][] slotData = ContainerSchematicShuttle.slotCoordinateMapping;
        int offsetX = -4;
        boolean offsetY = false;
        for (INasaWorkbenchRecipe recipe : data) {
            ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
            for (int i = 0; i < recipe.getRecipeSize(); ++i) {
                int[] coords = slotData[i];
                ItemStack curStack = (ItemStack)recipe.getRecipeInput().get(i + 1);
                if (curStack == null) continue;
                input1.add(new PositionedStack((Object)curStack, coords[0] + -4, coords[1] + 0));
            }
            shuttleRecipes.put(input1, new PositionedStack((Object)recipe.getRecipeOutput(), 138, 96));
        }
    }

    public static Set<Map.Entry<List<PositionedStack>, PositionedStack>> getShuttleRecipes() {
        return shuttleRecipes.entrySet();
    }

    private void initCircuitFabricatorRecipes() {
        List<CircuitFabricatorRecipe> recipes = RecipeHelper.getCircuitFabricatorRecipes();
        for (CircuitFabricatorRecipe recipe : recipes) {
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            input1.put(0, new PositionedStack(recipe.getCrystal(), 10, 22));
            input1.put(1, new PositionedStack(recipe.getSilicon1(), 69, 51));
            input1.put(2, new PositionedStack(recipe.getSilicon2(), 69, 69));
            input1.put(3, new PositionedStack(recipe.getRedstone(), 117, 51));
            Object optional = recipe.getOptional();
            if (optional != null) {
                input1.put(4, new PositionedStack(optional, 140, 25));
            }
            this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)recipe.output, 147, 91));
        }
    }

    public void registerCircuitFabricatorRecipe(Map<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public static Set<Map.Entry<Map<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }
}

